# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class TemplatesService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """TemplatesService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def apply_template(self, template_apply, **kwargs):  # noqa: E501,D401,D403
        """Apply or dry-run a template.

        Applies a template to create or update a [stack](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/) of InfluxDB [resources](https://docs.influxdata.com/influxdb/latest/reference/cli/influx/export/all/#resources). The response contains the diff of changes and the stack ID.  Use this endpoint to install an InfluxDB template to an organization. Provide template URLs or template objects in your request. To customize which template resources are installed, use the `actions` parameter.  By default, when you apply a template, InfluxDB installs the template to create and update stack resources and then generates a diff of the changes. If you pass `dryRun: true` in the request body, InfluxDB validates the template and generates the resource diff, but doesn’t make any changes to your instance.  #### Custom values for templates  - Some templates may contain [environment references](https://docs.influxdata.com/influxdb/latest/influxdb-templates/create/#include-user-definable-resource-names) for custom metadata.   To provide custom values for environment references, pass the _`envRefs`_   property in the request body.   For more information and examples, see how to   [define environment references](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#define-environment-references).  - Some templates may contain queries that use   [secrets](https://docs.influxdata.com/influxdb/latest/security/secrets/).   To provide custom secret values, pass the _`secrets`_ property   in the request body.   Don't expose secret values in templates.   For more information, see [how to pass secrets when installing a template](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#pass-secrets-when-installing-a-template).  #### Required permissions  - `write` permissions for resource types in the template.  #### Rate limits (with InfluxDB Cloud)  - Adjustable service quotas apply.   For more information, see [limits and adjustable quotas](https://docs.influxdata.com/influxdb/cloud/account-management/limits/).  #### Related guides  - [Use templates](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/) - [Stacks](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.apply_template(template_apply, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TemplateApply template_apply: Parameters for applying templates.  (required)
        :return: TemplateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.apply_template_with_http_info(template_apply, **kwargs)  # noqa: E501
        else:
            (data) = self.apply_template_with_http_info(template_apply, **kwargs)  # noqa: E501
            return data

    def apply_template_with_http_info(self, template_apply, **kwargs):  # noqa: E501,D401,D403
        """Apply or dry-run a template.

        Applies a template to create or update a [stack](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/) of InfluxDB [resources](https://docs.influxdata.com/influxdb/latest/reference/cli/influx/export/all/#resources). The response contains the diff of changes and the stack ID.  Use this endpoint to install an InfluxDB template to an organization. Provide template URLs or template objects in your request. To customize which template resources are installed, use the `actions` parameter.  By default, when you apply a template, InfluxDB installs the template to create and update stack resources and then generates a diff of the changes. If you pass `dryRun: true` in the request body, InfluxDB validates the template and generates the resource diff, but doesn’t make any changes to your instance.  #### Custom values for templates  - Some templates may contain [environment references](https://docs.influxdata.com/influxdb/latest/influxdb-templates/create/#include-user-definable-resource-names) for custom metadata.   To provide custom values for environment references, pass the _`envRefs`_   property in the request body.   For more information and examples, see how to   [define environment references](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#define-environment-references).  - Some templates may contain queries that use   [secrets](https://docs.influxdata.com/influxdb/latest/security/secrets/).   To provide custom secret values, pass the _`secrets`_ property   in the request body.   Don't expose secret values in templates.   For more information, see [how to pass secrets when installing a template](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#pass-secrets-when-installing-a-template).  #### Required permissions  - `write` permissions for resource types in the template.  #### Rate limits (with InfluxDB Cloud)  - Adjustable service quotas apply.   For more information, see [limits and adjustable quotas](https://docs.influxdata.com/influxdb/cloud/account-management/limits/).  #### Related guides  - [Use templates](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/) - [Stacks](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.apply_template_with_http_info(template_apply, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TemplateApply template_apply: Parameters for applying templates.  (required)
        :return: TemplateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._apply_template_prepare(template_apply, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/templates/apply', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='TemplateSummary',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def apply_template_async(self, template_apply, **kwargs):  # noqa: E501,D401,D403
        """Apply or dry-run a template.

        Applies a template to create or update a [stack](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/) of InfluxDB [resources](https://docs.influxdata.com/influxdb/latest/reference/cli/influx/export/all/#resources). The response contains the diff of changes and the stack ID.  Use this endpoint to install an InfluxDB template to an organization. Provide template URLs or template objects in your request. To customize which template resources are installed, use the `actions` parameter.  By default, when you apply a template, InfluxDB installs the template to create and update stack resources and then generates a diff of the changes. If you pass `dryRun: true` in the request body, InfluxDB validates the template and generates the resource diff, but doesn’t make any changes to your instance.  #### Custom values for templates  - Some templates may contain [environment references](https://docs.influxdata.com/influxdb/latest/influxdb-templates/create/#include-user-definable-resource-names) for custom metadata.   To provide custom values for environment references, pass the _`envRefs`_   property in the request body.   For more information and examples, see how to   [define environment references](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#define-environment-references).  - Some templates may contain queries that use   [secrets](https://docs.influxdata.com/influxdb/latest/security/secrets/).   To provide custom secret values, pass the _`secrets`_ property   in the request body.   Don't expose secret values in templates.   For more information, see [how to pass secrets when installing a template](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#pass-secrets-when-installing-a-template).  #### Required permissions  - `write` permissions for resource types in the template.  #### Rate limits (with InfluxDB Cloud)  - Adjustable service quotas apply.   For more information, see [limits and adjustable quotas](https://docs.influxdata.com/influxdb/cloud/account-management/limits/).  #### Related guides  - [Use templates](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/) - [Stacks](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param TemplateApply template_apply: Parameters for applying templates.  (required)
        :return: TemplateSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._apply_template_prepare(template_apply, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/templates/apply', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='TemplateSummary',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _apply_template_prepare(self, template_apply, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['template_apply']  # noqa: E501
        self._check_operation_params('apply_template', all_params, local_var_params)
        # verify the required parameter 'template_apply' is set
        if ('template_apply' not in local_var_params or
                local_var_params['template_apply'] is None):
            raise ValueError("Missing the required parameter `template_apply` when calling `apply_template`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}

        body_params = None
        if 'template_apply' in local_var_params:
            body_params = local_var_params['template_apply']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-jsonnet', 'text/yml'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def create_stack(self, **kwargs):  # noqa: E501,D401,D403
        """Create a stack.

        Creates or initializes a stack.  Use this endpoint to _manually_ initialize a new stack with the following optional information:    - Stack name   - Stack description   - URLs for template manifest files  To automatically create a stack when applying templates, use the [/api/v2/templates/apply endpoint](#operation/ApplyTemplate).  #### Required permissions  - `write` permission for the organization  #### Related guides  - [Initialize an InfluxDB stack](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/init/). - [Use InfluxDB templates](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#apply-templates-to-an-influxdb-instance).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_stack(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostStackRequest post_stack_request:
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_stack_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_stack_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_stack_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """Create a stack.

        Creates or initializes a stack.  Use this endpoint to _manually_ initialize a new stack with the following optional information:    - Stack name   - Stack description   - URLs for template manifest files  To automatically create a stack when applying templates, use the [/api/v2/templates/apply endpoint](#operation/ApplyTemplate).  #### Required permissions  - `write` permission for the organization  #### Related guides  - [Initialize an InfluxDB stack](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/init/). - [Use InfluxDB templates](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#apply-templates-to-an-influxdb-instance).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_stack_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostStackRequest post_stack_request:
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._create_stack_prepare(**kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/stacks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Stack',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def create_stack_async(self, **kwargs):  # noqa: E501,D401,D403
        """Create a stack.

        Creates or initializes a stack.  Use this endpoint to _manually_ initialize a new stack with the following optional information:    - Stack name   - Stack description   - URLs for template manifest files  To automatically create a stack when applying templates, use the [/api/v2/templates/apply endpoint](#operation/ApplyTemplate).  #### Required permissions  - `write` permission for the organization  #### Related guides  - [Initialize an InfluxDB stack](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/init/). - [Use InfluxDB templates](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#apply-templates-to-an-influxdb-instance).
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param PostStackRequest post_stack_request:
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._create_stack_prepare(**kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/stacks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Stack',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _create_stack_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['post_stack_request']  # noqa: E501
        self._check_operation_params('create_stack', all_params, local_var_params)

        path_params = {}

        query_params = []

        header_params = {}

        body_params = None
        if 'post_stack_request' in local_var_params:
            body_params = local_var_params['post_stack_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_stack(self, stack_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a stack and associated resources.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_stack(stack_id, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :param str org_id: The identifier of the organization. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_stack_with_http_info(stack_id, org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_stack_with_http_info(stack_id, org_id, **kwargs)  # noqa: E501
            return data

    def delete_stack_with_http_info(self, stack_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a stack and associated resources.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_stack_with_http_info(stack_id, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :param str org_id: The identifier of the organization. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_stack_prepare(stack_id, org_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/stacks/{stack_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_stack_async(self, stack_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a stack and associated resources.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :param str org_id: The identifier of the organization. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_stack_prepare(stack_id, org_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/stacks/{stack_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_stack_prepare(self, stack_id, org_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['stack_id', 'org_id']  # noqa: E501
        self._check_operation_params('delete_stack', all_params, local_var_params)
        # verify the required parameter 'stack_id' is set
        if ('stack_id' not in local_var_params or
                local_var_params['stack_id'] is None):
            raise ValueError("Missing the required parameter `stack_id` when calling `delete_stack`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `delete_stack`")  # noqa: E501

        path_params = {}
        if 'stack_id' in local_var_params:
            path_params['stack_id'] = local_var_params['stack_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def export_template(self, **kwargs):  # noqa: E501,D401,D403
        """Export a new template.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_template(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TemplateExportByID template_export_by_id: Export resources as an InfluxDB template.
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_template_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.export_template_with_http_info(**kwargs)  # noqa: E501
            return data

    def export_template_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """Export a new template.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_template_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TemplateExportByID template_export_by_id: Export resources as an InfluxDB template.
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._export_template_prepare(**kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/templates/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='list[object]',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def export_template_async(self, **kwargs):  # noqa: E501,D401,D403
        """Export a new template.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param TemplateExportByID template_export_by_id: Export resources as an InfluxDB template.
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._export_template_prepare(**kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/templates/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='list[object]',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _export_template_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['template_export_by_id']  # noqa: E501
        self._check_operation_params('export_template', all_params, local_var_params)

        path_params = {}

        query_params = []

        header_params = {}

        body_params = None
        if 'template_export_by_id' in local_var_params:
            body_params = local_var_params['template_export_by_id']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/x-yaml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def list_stacks(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List installed stacks.

        Lists installed InfluxDB stacks.  To limit stacks in the response, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all installed stacks for the organization.  #### Related guides  - [View InfluxDB stacks](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stacks(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: An organization ID. Only returns stacks owned by the specified [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization).  #### InfluxDB Cloud  - Doesn't require this parameter;   InfluxDB only returns resources allowed by the API token. (required)
        :param str name: A stack name. Finds stack `events` with this name and returns the stacks.  Repeatable. To filter for more than one stack name, repeat this parameter with each name--for example:  - `INFLUX_URL/api/v2/stacks?&orgID=INFLUX_ORG_ID&name=project-stack-0&name=project-stack-1`
        :param str stack_id: A stack ID. Only returns the specified stack.  Repeatable. To filter for more than one stack ID, repeat this parameter with each ID--for example:  - `INFLUX_URL/api/v2/stacks?&orgID=INFLUX_ORG_ID&stackID=09bd87cd33be3000&stackID=09bef35081fe3000`
        :return: ListStacksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_stacks_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_stacks_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def list_stacks_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List installed stacks.

        Lists installed InfluxDB stacks.  To limit stacks in the response, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all installed stacks for the organization.  #### Related guides  - [View InfluxDB stacks](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_stacks_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: An organization ID. Only returns stacks owned by the specified [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization).  #### InfluxDB Cloud  - Doesn't require this parameter;   InfluxDB only returns resources allowed by the API token. (required)
        :param str name: A stack name. Finds stack `events` with this name and returns the stacks.  Repeatable. To filter for more than one stack name, repeat this parameter with each name--for example:  - `INFLUX_URL/api/v2/stacks?&orgID=INFLUX_ORG_ID&name=project-stack-0&name=project-stack-1`
        :param str stack_id: A stack ID. Only returns the specified stack.  Repeatable. To filter for more than one stack ID, repeat this parameter with each ID--for example:  - `INFLUX_URL/api/v2/stacks?&orgID=INFLUX_ORG_ID&stackID=09bd87cd33be3000&stackID=09bef35081fe3000`
        :return: ListStacksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._list_stacks_prepare(org_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/stacks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ListStacksResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def list_stacks_async(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List installed stacks.

        Lists installed InfluxDB stacks.  To limit stacks in the response, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all installed stacks for the organization.  #### Related guides  - [View InfluxDB stacks](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/).
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str org_id: An organization ID. Only returns stacks owned by the specified [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization).  #### InfluxDB Cloud  - Doesn't require this parameter;   InfluxDB only returns resources allowed by the API token. (required)
        :param str name: A stack name. Finds stack `events` with this name and returns the stacks.  Repeatable. To filter for more than one stack name, repeat this parameter with each name--for example:  - `INFLUX_URL/api/v2/stacks?&orgID=INFLUX_ORG_ID&name=project-stack-0&name=project-stack-1`
        :param str stack_id: A stack ID. Only returns the specified stack.  Repeatable. To filter for more than one stack ID, repeat this parameter with each ID--for example:  - `INFLUX_URL/api/v2/stacks?&orgID=INFLUX_ORG_ID&stackID=09bd87cd33be3000&stackID=09bef35081fe3000`
        :return: ListStacksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._list_stacks_prepare(org_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/stacks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ListStacksResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _list_stacks_prepare(self, org_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['org_id', 'name', 'stack_id']  # noqa: E501
        self._check_operation_params('list_stacks', all_params, local_var_params)
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `list_stacks`")  # noqa: E501

        path_params = {}

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'stack_id' in local_var_params:
            query_params.append(('stackID', local_var_params['stack_id']))  # noqa: E501

        header_params = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def read_stack(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a stack.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_stack(stack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.read_stack_with_http_info(stack_id, **kwargs)  # noqa: E501
        else:
            (data) = self.read_stack_with_http_info(stack_id, **kwargs)  # noqa: E501
            return data

    def read_stack_with_http_info(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a stack.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_stack_with_http_info(stack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._read_stack_prepare(stack_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/stacks/{stack_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Stack',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def read_stack_async(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a stack.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._read_stack_prepare(stack_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/stacks/{stack_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Stack',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _read_stack_prepare(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['stack_id']  # noqa: E501
        self._check_operation_params('read_stack', all_params, local_var_params)
        # verify the required parameter 'stack_id' is set
        if ('stack_id' not in local_var_params or
                local_var_params['stack_id'] is None):
            raise ValueError("Missing the required parameter `stack_id` when calling `read_stack`")  # noqa: E501

        path_params = {}
        if 'stack_id' in local_var_params:
            path_params['stack_id'] = local_var_params['stack_id']  # noqa: E501

        query_params = []

        header_params = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def uninstall_stack(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        """Uninstall a stack.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.uninstall_stack(stack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.uninstall_stack_with_http_info(stack_id, **kwargs)  # noqa: E501
        else:
            (data) = self.uninstall_stack_with_http_info(stack_id, **kwargs)  # noqa: E501
            return data

    def uninstall_stack_with_http_info(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        """Uninstall a stack.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.uninstall_stack_with_http_info(stack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._uninstall_stack_prepare(stack_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/stacks/{stack_id}/uninstall', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Stack',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def uninstall_stack_async(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        """Uninstall a stack.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._uninstall_stack_prepare(stack_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/stacks/{stack_id}/uninstall', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Stack',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _uninstall_stack_prepare(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['stack_id']  # noqa: E501
        self._check_operation_params('uninstall_stack', all_params, local_var_params)
        # verify the required parameter 'stack_id' is set
        if ('stack_id' not in local_var_params or
                local_var_params['stack_id'] is None):
            raise ValueError("Missing the required parameter `stack_id` when calling `uninstall_stack`")  # noqa: E501

        path_params = {}
        if 'stack_id' in local_var_params:
            path_params['stack_id'] = local_var_params['stack_id']  # noqa: E501

        query_params = []

        header_params = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def update_stack(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        """Update a stack.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_stack(stack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :param PatchStackRequest patch_stack_request:
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_stack_with_http_info(stack_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_stack_with_http_info(stack_id, **kwargs)  # noqa: E501
            return data

    def update_stack_with_http_info(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        """Update a stack.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_stack_with_http_info(stack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :param PatchStackRequest patch_stack_request:
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._update_stack_prepare(stack_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/stacks/{stack_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Stack',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def update_stack_async(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        """Update a stack.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str stack_id: The identifier of the stack. (required)
        :param PatchStackRequest patch_stack_request:
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._update_stack_prepare(stack_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/stacks/{stack_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Stack',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _update_stack_prepare(self, stack_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['stack_id', 'patch_stack_request']  # noqa: E501
        self._check_operation_params('update_stack', all_params, local_var_params)
        # verify the required parameter 'stack_id' is set
        if ('stack_id' not in local_var_params or
                local_var_params['stack_id'] is None):
            raise ValueError("Missing the required parameter `stack_id` when calling `update_stack`")  # noqa: E501

        path_params = {}
        if 'stack_id' in local_var_params:
            path_params['stack_id'] = local_var_params['stack_id']  # noqa: E501

        query_params = []

        header_params = {}

        body_params = None
        if 'patch_stack_request' in local_var_params:
            body_params = local_var_params['patch_stack_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
