# This script updates the nightly release on Github for micro
# Must be run from inside the micro git repository

commitID=$(git rev-parse --short HEAD)

go run remove-nightly-assets.go

echo "Cross compiling binaries"
./cross-compile.sh $1
mv ../binaries .

MESSAGE=$'Nightly build\n\nAutogenerated nightly build of micro'

echo "Updating release"
hub release edit nightly \
    --prerelease \
    --draft=false \
    --message "$MESSAGE (please DISREGARD the creation date of this Github release). Assets uploaded on $(date) for commit $commitID." \
    --attach "binaries/micro-$1-osx.tar.gz" \
    --attach "binaries/micro-$1-macos-arm64.tar.gz" \
    --attach "binaries/micro-$1-linux64.tar.gz" \
    --attach "binaries/micro-$1-linux64-static.tar.gz" \
    --attach "binaries/micro-$1-amd64.deb" \
    --attach "binaries/micro-$1-linux32.tar.gz" \
    --attach "binaries/micro-$1-linux-arm.tar.gz" \
    --attach "binaries/micro-$1-linux-arm64.tar.gz" \
    --attach "binaries/micro-$1-freebsd64.tar.gz" \
    --attach "binaries/micro-$1-freebsd32.tar.gz" \
    --attach "binaries/micro-$1-openbsd64.tar.gz" \
    --attach "binaries/micro-$1-openbsd32.tar.gz" \
    --attach "binaries/micro-$1-netbsd64.tar.gz" \
    --attach "binaries/micro-$1-netbsd32.tar.gz" \
    --attach "binaries/micro-$1-win64.zip" \
    --attach "binaries/micro-$1-win32.zip"
