/*
 * Copyright (c) 2003-2011
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 *
 * $Id: rlink.h 2528 2011-09-23 21:54:05Z brachman $
 */

#ifndef _RLINK_H_
#define _RLINK_H_

/*
 * The number of different rnames will be the number of characters
 * in RNAME_ALPHABET ^ RNAME_LENGTH.
 * Up to a point, the larger this value is, the greater the security.
 *
 * The default is for an rname to consist of upper and lower case alphabetics
 * and digits: (26+26+10) ^ RNAME_LENGTH
 * An RNAME_LENGTH of 8 yields a space larger than 10^14.
 * An RNAME_LENGTH of 11 yields a space larger than 2^64.
 *
 * Because rlinks can be stored in the filesystem, RNAME_ALPHABET should
 * consist of valid and distinct characters allowed in a filename by the OS.
 */

#define RNAME_ALPHABET			"a-zA-Z0-9"
#define RNAME_IDENT_SEP_CHAR	':'
#define RNAME_IPTR_SEP_CHAR		';'

enum {
  RNAME_LENGTH = 8
};

typedef struct Rlink {
  char *rname;
  char *ident;
  char *iptr;
  char *expr;
  char *rule_vfs;
  Credentials *credentials;
} Rlink;

#ifdef __cplusplus
extern "C" {
#endif

extern Rlink *acs_rlink_lookup(Kwv *kwv, Kwv *kwv_args, Credentials *cr);
extern int acs_rlink_check(Rlink *rlink, Acs_environment *env,
						   Credentials *scredentials, Acs_result *result);
extern int acs_rname_parse(Rlink *rlink, char *rname);
extern int acs_rlink_update(Rlink *rlink, char *uri,
							Credentials *scredentials);
extern int acs_rlink_delete(Rlink *rlink, char *uri,
							Credentials *scredentials);

extern char *rlink_get(char *vfs_uri, char *rname);

#ifdef __cplusplus
}
#endif

#endif
