/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;

public class TextMatcherEditor
extends AbstractMatcherEditor {
    private final TextFilterator filterator;
    private String[] filters = new String[0];

    public TextMatcherEditor() {
        this(null);
    }

    public TextMatcherEditor(TextFilterator filterator) {
        this.filterator = filterator;
    }

    public TextFilterator getFilterator() {
        return this.filterator;
    }

    public void setFilterText(String[] filterStrings) {
        String[] oldFilters = this.filters;
        this.filters = TextMatcher.normalizeFilters(filterStrings);
        if (!TextMatcher.isFilterEqual(oldFilters, this.filters)) {
            if (this.filters.length == 0) {
                this.fireMatchAll();
            } else if (TextMatcher.isFilterRelaxed(oldFilters, this.filters)) {
                this.fireRelaxed(new TextMatcher(this.filters, this.filterator));
            } else if (TextMatcher.isFilterConstrained(oldFilters, this.filters)) {
                this.fireConstrained(new TextMatcher(this.filters, this.filterator));
            } else {
                this.fireChanged(new TextMatcher(this.filters, this.filterator));
            }
        }
    }
}

