/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.beans;

import ca.odell.glazedlists.ObservableElementList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;

public class JavaBeanEventListConnector
implements ObservableElementList.Connector {
    private Method addListenerMethod = null;
    private Method removeListenerMethod = null;
    private ObservableElementList list = null;
    protected PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    private Object[] reflectionParameters = new Object[]{this.propertyChangeListener};

    public JavaBeanEventListConnector(Class beanClass) {
        Method[] methods = beanClass.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            if (methods[m].getParameterTypes().length != 1 || methods[m].getParameterTypes()[0] != (class$java$beans$PropertyChangeListener == null ? JavaBeanEventListConnector.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
            if (methods[m].getName().startsWith("add")) {
                this.addListenerMethod = methods[m];
            }
            if (!methods[m].getName().startsWith("remove")) continue;
            this.removeListenerMethod = methods[m];
        }
        if (this.addListenerMethod == null || this.removeListenerMethod == null) {
            throw new IllegalArgumentException("Couldn't find listener methods for " + beanClass.getName());
        }
    }

    public JavaBeanEventListConnector(Class beanClass, String addListenerMethodName, String removeListenerMethodName) {
        try {
            this.addListenerMethod = beanClass.getMethod(addListenerMethodName, PropertyChangeListener.class);
            this.removeListenerMethod = beanClass.getMethod(removeListenerMethodName, PropertyChangeListener.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to find method " + e.getMessage() + " in " + beanClass);
        }
    }

    public EventListener installListener(Object element) {
        try {
            this.addListenerMethod.invoke(element, this.reflectionParameters);
            return this.propertyChangeListener;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getCause());
        }
    }

    public void uninstallListener(Object element, EventListener listener) {
        try {
            this.removeListenerMethod.invoke(element, this.reflectionParameters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void setObservableElementList(ObservableElementList list) {
        this.list = list;
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            JavaBeanEventListConnector.this.list.elementChanged(event.getSource());
        }
    }
}

