/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.IndexedTree;
import ca.odell.glazedlists.impl.adt.IndexedTreeNode;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public final class GroupingList
extends TransformedList {
    private static final Object TODO = Barcode.BLACK;
    private static final Object DONE = Barcode.WHITE;
    private Comparator comparator;
    private IndexedTree groupLists = new IndexedTree();
    private Barcode barcode = new Barcode();
    private static final Object UNIQUE = Barcode.BLACK;
    private static final Object DUPLICATE = Barcode.WHITE;
    private static final Object UNIQUE_WITH_DUPLICATE = null;
    private static final int LEFT_GROUP = -1;
    private static final int NO_GROUP = 0;
    private static final int RIGHT_GROUP = 1;

    public GroupingList(EventList source) {
        this(source, GlazedLists.comparableComparator());
    }

    public GroupingList(EventList source, Comparator comparator) {
        this(new SortedList(source, comparator), comparator);
    }

    private GroupingList(SortedList source, Comparator comparator) {
        super(source);
        this.comparator = comparator;
        this.buildDataStructures();
        source.addListEventListener(this);
    }

    private void buildDataStructures() {
        int i;
        if (!this.barcode.isEmpty()) {
            throw new IllegalStateException("Attempted to build internal data structures twice.");
        }
        for (i = 0; i < this.source.size(); ++i) {
            this.barcode.add(i, this.groupTogether(i, i - 1) ? DUPLICATE : UNIQUE, 1);
        }
        for (i = 0; i < this.barcode.colourSize(UNIQUE); ++i) {
            this.insertGroupList(i);
        }
    }

    private void insertGroupList(int index) {
        GroupList groupList = new GroupList();
        IndexedTreeNode indexedTreeNode = this.groupLists.addByNode(index, groupList);
        groupList.setTreeNode(indexedTreeNode);
    }

    private void removeGroupList(int index) {
        IndexedTreeNode indexedTreeNode = this.groupLists.removeByIndex(index);
        ((GroupList)indexedTreeNode.getValue()).setTreeNode(null);
    }

    public int size() {
        return this.barcode.blackSize();
    }

    protected int getSourceIndex(int index) {
        return this.barcode.getIndex(index, UNIQUE);
    }

    protected boolean isWritable() {
        return true;
    }

    public void listChanged(ListEvent listChanges) {
        int changeType;
        int changeIndex;
        Barcode toDoList = new Barcode();
        toDoList.addWhite(0, this.barcode.size());
        LinkedList<Object> removedValues = new LinkedList<Object>();
        while (listChanges.next()) {
            changeIndex = listChanges.getIndex();
            changeType = listChanges.getType();
            if (changeType == 2) {
                this.barcode.add(changeIndex, UNIQUE, 1);
                toDoList.add(changeIndex, TODO, 1);
                continue;
            }
            if (changeType == 1) {
                if (this.barcode.get(changeIndex) != UNIQUE || changeIndex + 1 >= this.barcode.size() || this.barcode.get(changeIndex + 1) != DUPLICATE) continue;
                this.barcode.set(changeIndex, UNIQUE, 2);
                toDoList.set(changeIndex, TODO, 1);
                continue;
            }
            if (changeType != 0) continue;
            Object deleted = this.barcode.get(changeIndex);
            this.barcode.remove(changeIndex, 1);
            toDoList.remove(changeIndex, 1);
            if (deleted == UNIQUE && changeIndex < this.barcode.size() && this.barcode.get(changeIndex) == DUPLICATE) {
                this.barcode.set(changeIndex, UNIQUE, 1);
                deleted = UNIQUE_WITH_DUPLICATE;
            }
            removedValues.addLast(deleted);
        }
        this.updates.beginEvent(true);
        listChanges.reset();
        while (listChanges.next()) {
            int groupDeletedIndex;
            changeIndex = listChanges.getIndex();
            changeType = listChanges.getType();
            if (changeType == 2) {
                if (this.tryJoinExistingGroup(changeIndex, toDoList) == 0) {
                    int groupIndex = this.barcode.getColourIndex(changeIndex, UNIQUE);
                    this.insertGroupList(groupIndex);
                    this.updates.addInsert(groupIndex);
                    continue;
                }
                this.updates.addUpdate(this.barcode.getColourIndex(changeIndex, true, UNIQUE));
                continue;
            }
            if (changeType == 1) {
                int oldGroup = 0;
                if (toDoList.get(changeIndex) == TODO) {
                    oldGroup = 1;
                } else if (this.barcode.get(changeIndex) == DUPLICATE) {
                    oldGroup = -1;
                } else if (this.barcode.get(changeIndex) == UNIQUE) {
                    oldGroup = 0;
                }
                int newGroup = this.tryJoinExistingGroup(changeIndex, toDoList);
                int groupIndex = this.barcode.getColourIndex(changeIndex, true, UNIQUE);
                if (newGroup == 0) {
                    if (oldGroup == 0) {
                        this.updates.addUpdate(groupIndex);
                        continue;
                    }
                    if (oldGroup == -1) {
                        this.updates.addUpdate(groupIndex - 1);
                        this.insertGroupList(groupIndex);
                        this.updates.addInsert(groupIndex);
                        continue;
                    }
                    if (oldGroup != 1) continue;
                    this.insertGroupList(groupIndex);
                    this.updates.addInsert(groupIndex);
                    this.updates.addUpdate(groupIndex + 1);
                    continue;
                }
                if (newGroup == -1) {
                    if (oldGroup == 0) {
                        this.updates.addUpdate(groupIndex);
                        this.removeGroupList(groupIndex + 1);
                        this.updates.addDelete(groupIndex + 1);
                        continue;
                    }
                    if (oldGroup == -1) {
                        this.updates.addUpdate(groupIndex);
                        continue;
                    }
                    if (oldGroup != 1) continue;
                    this.updates.addUpdate(groupIndex);
                    if (groupIndex + 1 >= this.barcode.blackSize()) continue;
                    this.updates.addUpdate(groupIndex + 1);
                    continue;
                }
                if (newGroup != 1) continue;
                if (oldGroup == 0) {
                    this.removeGroupList(groupIndex);
                    this.updates.addDelete(groupIndex);
                    this.updates.addUpdate(groupIndex);
                    continue;
                }
                if (oldGroup == -1) {
                    if (groupIndex - 1 >= 0) {
                        this.updates.addUpdate(groupIndex - 1);
                    }
                    this.updates.addUpdate(groupIndex);
                    continue;
                }
                if (oldGroup != 1) continue;
                this.updates.addUpdate(groupIndex);
                continue;
            }
            if (changeType != 0) continue;
            Object deleted = removedValues.removeFirst();
            int sourceDeletedIndex = deleted == DUPLICATE ? changeIndex - 1 : changeIndex;
            int n = groupDeletedIndex = sourceDeletedIndex < this.barcode.size() ? this.barcode.getBlackIndex(sourceDeletedIndex, true) : this.barcode.blackSize();
            if (deleted == UNIQUE) {
                this.removeGroupList(groupDeletedIndex);
                this.updates.addDelete(groupDeletedIndex);
                continue;
            }
            this.updates.addUpdate(groupDeletedIndex);
        }
        this.updates.commitEvent();
    }

    private int tryJoinExistingGroup(int changeIndex, Barcode toDoList) {
        int predecessorIndex = changeIndex - 1;
        if (this.groupTogether(predecessorIndex, changeIndex)) {
            this.barcode.set(changeIndex, DUPLICATE, 1);
            return -1;
        }
        int successorIndex = changeIndex + 1;
        while (this.groupTogether(changeIndex, successorIndex)) {
            if (toDoList.get(successorIndex) == DONE) {
                this.barcode.set(changeIndex, UNIQUE, 1);
                this.barcode.set(successorIndex, DUPLICATE, 1);
                return 1;
            }
            ++successorIndex;
        }
        this.barcode.set(changeIndex, UNIQUE, 1);
        return 0;
    }

    public Object get(int x0) {
        int index = x0;
        return (List)this.groupLists.get(index);
    }

    private boolean groupTogether(int sourceIndex0, int sourceIndex1) {
        if (sourceIndex0 < 0 || sourceIndex0 >= this.source.size()) {
            return false;
        }
        if (sourceIndex1 < 0 || sourceIndex1 >= this.source.size()) {
            return false;
        }
        return this.comparator.compare(this.source.get(sourceIndex0), this.source.get(sourceIndex1)) == 0;
    }

    public Object remove(int x0) {
        int index = x0;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot remove at " + index + " on list of size " + this.size());
        }
        List removed = (List)this.get(index);
        ArrayList result = new ArrayList(removed);
        removed.clear();
        return result;
    }

    public Object set(int x0, Object x1) {
        int index = x0;
        List value = (List)x1;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot set at " + index + " on list of size " + this.size());
        }
        this.updates.beginEvent(true);
        List result = (List)this.remove(index);
        this.add(index, value);
        this.updates.commitEvent();
        return result;
    }

    public void add(int x0, Object x1) {
        int index = x0;
        List value = (List)x1;
        this.source.addAll(value);
    }

    public void dispose() {
        ((SortedList)this.source).dispose();
        super.dispose();
    }

    private class GroupList
    extends AbstractList {
        private IndexedTreeNode treeNode;

        private GroupList() {
        }

        private void setTreeNode(IndexedTreeNode treeNode) {
            this.treeNode = treeNode;
        }

        private int getStartIndex() {
            int groupIndex = this.treeNode.getIndex();
            return GroupingList.this.getSourceIndex(groupIndex);
        }

        private int getEndIndex() {
            int groupIndex = this.treeNode.getIndex();
            if (groupIndex < GroupingList.this.barcode.blackSize() - 1) {
                return GroupingList.this.barcode.getIndex(groupIndex + 1, UNIQUE);
            }
            return GroupingList.this.barcode.size();
        }

        private int getSourceIndex(int index) {
            return this.getStartIndex() + index;
        }

        public Object set(int index, Object element) {
            return GroupingList.this.source.set(this.getSourceIndex(index), element);
        }

        public Object get(int index) {
            return GroupingList.this.source.get(this.getSourceIndex(index));
        }

        public int size() {
            return this.getEndIndex() - this.getStartIndex();
        }

        public void clear() {
            GroupingList.this.source.subList(this.getStartIndex(), this.getEndIndex()).clear();
        }

        public Object remove(int index) {
            return GroupingList.this.source.remove(this.getSourceIndex(index));
        }

        public void add(int index, Object element) {
            GroupingList.this.source.add(this.getSourceIndex(index), element);
        }
    }
}

