/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionLostException;
import Ice.LocalException;
import Ice.Logger;
import Ice.SocketException;
import Ice.TimeoutException;
import IceInternal.BasicStream;
import IceInternal.ByteBuffer;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TraceLevels;
import IceUtil.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;

public final class Transceiver {
    private Socket _fd;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private String _desc;
    private InputStream _in;
    private OutputStream _out;
    private volatile boolean _shutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object;
        if (this._traceLevels.network >= 1) {
            object = "closing tcp connection\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, (String)object);
        }
        object = this;
        synchronized (object) {
            try {
                this._fd.close();
            }
            catch (IOException iOException) {
                SocketException socketException = new SocketException();
                socketException.initCause(iOException);
                throw socketException;
            }
            finally {
                this._fd = null;
            }
        }
    }

    public void shutdownWrite() {
    }

    public void shutdownReadWrite() {
        if (this._traceLevels.network >= 2) {
            String string = "shutting down tcp connection for reading and writing\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, string);
        }
        this._shutdown = true;
    }

    public void write(BasicStream basicStream, int n) {
        ByteBuffer byteBuffer = basicStream.prepareWrite();
        byte[] byArray = byteBuffer.array();
        try {
            if (n == -1) {
                n = 0;
            } else if (n == 0) {
                n = 1;
            }
            this._fd.setSoTimeout(n);
        }
        catch (java.net.SocketException socketException) {
            SocketException socketException2 = new SocketException();
            socketException2.initCause(socketException);
            throw socketException2;
        }
        while (byteBuffer.hasRemaining() && !this._shutdown) {
            int n2 = byteBuffer.position();
            try {
                int n3 = byteBuffer.remaining();
                this._out.write(byArray, n2, n3);
                byteBuffer.position(n2 + n3);
                if (this._traceLevels.network < 3) break;
                String string = "sent " + n3 + " of " + byteBuffer.limit() + " bytes via tcp\n" + this.toString();
                this._logger.trace(this._traceLevels.networkCat, string);
                break;
            }
            catch (InterruptedIOException interruptedIOException) {
                byteBuffer.position(n2 + interruptedIOException.bytesTransferred);
            }
            catch (IOException iOException) {
                SocketException socketException = new SocketException();
                socketException.initCause(iOException);
                throw socketException;
            }
        }
        if (this._shutdown && byteBuffer.hasRemaining()) {
            throw new ConnectionLostException();
        }
    }

    public void read(BasicStream basicStream, int n) {
        ByteBuffer byteBuffer = basicStream.prepareRead();
        int n2 = 0;
        if (this._traceLevels.network >= 3) {
            n2 = byteBuffer.remaining();
        }
        byte[] byArray = byteBuffer.array();
        int n3 = 500;
        if (n >= 0 && n < n3) {
            n3 = n;
        }
        while (byteBuffer.hasRemaining() && !this._shutdown) {
            Object object;
            int n4 = byteBuffer.position();
            try {
                this._fd.setSoTimeout(n3);
                int n5 = this._in.read(byArray, n4, byteBuffer.remaining());
                if (n5 == -1) {
                    throw new ConnectionLostException();
                }
                if (n5 <= 0) continue;
                if (this._traceLevels.network >= 3) {
                    object = "received " + n5 + " of " + n2 + " bytes via tcp\n" + this.toString();
                    this._logger.trace(this._traceLevels.networkCat, (String)object);
                }
                byteBuffer.position(n4 + n5);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (interruptedIOException.bytesTransferred > 0) {
                    byteBuffer.position(n4 + interruptedIOException.bytesTransferred);
                }
                if (n < 0) continue;
                if (n3 >= n) {
                    throw new TimeoutException();
                }
                n -= n3;
            }
            catch (IOException iOException) {
                if (Network.connectionLost(iOException)) {
                    object = new ConnectionLostException();
                    ((LocalException)object).initCause(iOException);
                    throw object;
                }
                object = new SocketException();
                ((LocalException)object).initCause(iOException);
                throw object;
            }
        }
        if (this._shutdown) {
            throw new ConnectionLostException();
        }
    }

    public String type() {
        return "tcp";
    }

    public String toString() {
        return this._desc;
    }

    Transceiver(Instance instance, Socket socket) {
        this._fd = socket;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.logger();
        this._desc = Network.fdToString(this._fd);
        try {
            this._in = this._fd.getInputStream();
            this._out = this._fd.getOutputStream();
        }
        catch (IOException iOException) {
            try {
                this._fd.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this._fd = null;
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
        this._shutdown = false;
    }

    protected synchronized void finalize() throws Throwable {
        Debug.FinalizerAssert(this._fd == null);
    }
}

