/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.Connection;
import Ice.FeatureNotSupportedException;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import Ice.RouterPrx;
import IceInternal.BasicStream;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceInternal.Reference;
import IceUtil.Arrays;
import java.util.Hashtable;
import java.util.Random;

public class FixedReference
extends Reference {
    private Connection[] _fixedConnections;
    private Random _rand = new Random();

    public FixedReference(Instance instance, Communicator communicator, Identity identity, Hashtable hashtable, String string, int n, Connection[] connectionArray) {
        super(instance, communicator, identity, hashtable, string, n, false);
        this._fixedConnections = connectionArray;
    }

    public final Connection[] getFixedConnections() {
        return this._fixedConnections;
    }

    public Endpoint[] getEndpoints() {
        return new Endpoint[0];
    }

    public Reference changeRouter(RouterPrx routerPrx) {
        return this;
    }

    public Reference changeLocator(LocatorPrx locatorPrx) {
        return this;
    }

    public Reference changeTimeout(int n) {
        return this;
    }

    public void streamWrite(BasicStream basicStream) throws MarshalException {
        throw new MarshalException("Cannot marshal a fixed proxy");
    }

    public String toString() throws MarshalException {
        throw new MarshalException("Cannot marshal a fixed proxy");
    }

    public Connection getConnection() {
        if (this.getSecure() || this.getMode() == 3 || this.getMode() == 4 || this._fixedConnections.length == 0) {
            if (this._fixedConnections.length == 0) {
                NoEndpointException noEndpointException = new NoEndpointException();
                noEndpointException.proxy = "";
                throw noEndpointException;
            }
            FeatureNotSupportedException featureNotSupportedException = new FeatureNotSupportedException();
            if (this.getSecure()) {
                featureNotSupportedException.unsupportedFeature = "ssl";
            } else if (this.getMode() == 3) {
                featureNotSupportedException.unsupportedFeature = "datagram";
            } else if (this.getMode() == 4) {
                featureNotSupportedException.unsupportedFeature = "batch datagram";
            }
            throw featureNotSupportedException;
        }
        Connection connection = this._fixedConnections[Math.abs(this._rand.nextInt() % this._fixedConnections.length)];
        connection.throwException();
        return connection;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FixedReference)) {
            return false;
        }
        FixedReference fixedReference = (FixedReference)object;
        if (!super.equals(fixedReference)) {
            return false;
        }
        return Arrays.equals(this._fixedConnections, fixedReference._fixedConnections);
    }

    protected FixedReference() {
    }

    protected void shallowCopy(FixedReference fixedReference) {
        super.shallowCopy(fixedReference);
        fixedReference._fixedConnections = this._fixedConnections;
        fixedReference._rand = this._rand;
    }

    public Object ice_clone() {
        FixedReference fixedReference = new FixedReference();
        this.shallowCopy(fixedReference);
        return fixedReference;
    }
}

