/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.sort;

import com.icl.saxon.Context;
import com.icl.saxon.Loader;
import com.icl.saxon.expr.DummyStaticContext;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.om.Name;
import com.icl.saxon.sort.Compare_en;
import com.icl.saxon.sort.Comparer;
import com.icl.saxon.sort.DoubleComparer;
import com.icl.saxon.sort.StringComparer;
import com.icl.saxon.sort.TextComparer;
import org.xml.sax.SAXException;

public class SortKeyDefinition {
    private Expression sortKey;
    private Expression order;
    private Expression dataType;
    private Expression caseOrder;
    private Expression language;
    private StaticContext staticContext = new DummyStaticContext();
    private Comparer comparer = null;

    public void setSortKey(Expression expression) {
        this.sortKey = expression;
    }

    public void setOrder(Expression expression) {
        this.order = expression;
    }

    public void setDataType(Expression expression) {
        this.dataType = expression;
    }

    public void setCaseOrder(Expression expression) {
        this.caseOrder = expression;
    }

    public void setLanguage(Expression expression) {
        this.language = expression;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public Expression getOrder() {
        return this.order == null ? new StringValue("ascending") : this.order;
    }

    public Expression getDataType() {
        return this.dataType == null ? new StringValue("text") : this.dataType;
    }

    public Expression getCaseOrder() {
        return this.caseOrder == null ? new StringValue("#default") : this.caseOrder;
    }

    public Expression getLanguage() {
        return this.language == null ? new StringValue("en") : this.language;
    }

    public void bindComparer() throws SAXException {
        if (this.dataType instanceof StringValue && this.order instanceof StringValue && this.caseOrder instanceof StringValue && this.language instanceof StringValue) {
            this.comparer = this.makeComparer(null);
        }
    }

    public Comparer getComparer(Context context) throws SAXException {
        if (this.comparer == null) {
            return this.makeComparer(context);
        }
        return this.comparer;
    }

    private Comparer makeComparer(Context context) throws SAXException {
        int n;
        Name name;
        boolean bl;
        String string = this.order == null ? "ascending" : this.order.evaluateAsString(context);
        if (string.equals("ascending")) {
            bl = true;
        } else if (string.equals("descending")) {
            bl = false;
        } else {
            throw new SAXException("order must be ascending or descending");
        }
        String string2 = this.dataType == null ? "text" : this.dataType.evaluateAsString(context);
        if (string2.equals("text")) {
            name = null;
        } else if (string2.equals("number")) {
            name = null;
        } else {
            if (string2.indexOf(58) < 0) {
                throw new SAXException("data-type must be text, number, or a prefixed name");
            }
            name = this.staticContext.makeName(string2, false);
        }
        String string3 = this.caseOrder == null ? "#default" : this.caseOrder.evaluateAsString(context);
        if (string3.equals("#default")) {
            n = 0;
        } else if (string3.equals("lower-first")) {
            n = 1;
        } else if (string3.equals("upper-first")) {
            n = 2;
        } else {
            throw new SAXException("case-order must be lower-first or upper-first");
        }
        if (string2.equals("text")) {
            if (this.language == null) {
                this.comparer = new StringComparer();
            } else {
                String string4 = this.language.evaluateAsString(context);
                String string5 = "com.icl.saxon.sort.Compare_";
                int n2 = 0;
                while (n2 < string4.length()) {
                    if (Character.isLetter(string4.charAt(n2))) {
                        string5 = string5 + string4.charAt(n2);
                    }
                    ++n2;
                }
                try {
                    this.comparer = SortKeyDefinition.loadComparer(string5);
                }
                catch (Exception exception) {
                    this.comparer = new Compare_en();
                }
            }
        } else if (string2.equals("number")) {
            this.comparer = new DoubleComparer();
        } else {
            String string6 = name.getLocalName();
            try {
                this.comparer = SortKeyDefinition.loadComparer(string6);
            }
            catch (Exception exception) {
                System.err.println("Warning: no comparer " + string6 + " found; using default");
                this.comparer = new StringComparer();
            }
        }
        this.comparer = this.comparer.setDataType(name);
        this.comparer = this.comparer.setOrder(bl);
        if (this.comparer instanceof TextComparer) {
            this.comparer = ((TextComparer)this.comparer).setCaseOrder(n);
        }
        return this.comparer;
    }

    private static TextComparer loadComparer(String string) throws SAXException {
        try {
            return (TextComparer)Loader.getInstance(string);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException("Failed to load TextComparer  " + string + ": it does not implement the TextComparer interface");
        }
    }
}

