/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.Version;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.Name;
import java.util.Vector;
import org.xml.sax.SAXException;

public class SystemProperty
extends Function {
    public String getName() {
        return "system-property";
    }

    public int getDataType() {
        return -1;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        int n = this.checkArgumentCount(1, 1);
        Value value = (Value)vector.elementAt(0);
        String string = value.asString();
        Name name = this.getStaticContext().makeName(string, false);
        return SystemProperty.getProperty(name);
    }

    public static Value getProperty(Name name) {
        String string;
        String string2 = name.getURI();
        String string3 = name.getLocalName();
        if (string2 == "http://www.w3.org/1999/XSL/Transform") {
            if (string3.equals("version")) {
                return new NumericValue(Version.getXSLVersion());
            }
            if (string3.equals("vendor")) {
                return new StringValue(Version.getProductName());
            }
            if (string3.equals("vendor-url")) {
                return new StringValue(Version.getWebSiteAddress());
            }
        }
        if ((string = System.getProperty(string3)) == null) {
            string = "";
        }
        return new StringValue(string);
    }

    public static Value getProperty(String string) throws SAXException {
        String string2;
        String string3;
        int n = string.indexOf("^");
        if (n < 0) {
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        return SystemProperty.getProperty(new Name("prefix", string3, string2));
    }
}

