/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Bindery;
import com.icl.saxon.Context;
import com.icl.saxon.DOMDriver;
import com.icl.saxon.DecimalFormatManager;
import com.icl.saxon.KeyManager;
import com.icl.saxon.LastPositionFinder;
import com.icl.saxon.Mode;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.PreviewManager;
import com.icl.saxon.RuleManager;
import com.icl.saxon.StandardURIResolver;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FunctionProxy;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.handlers.NodeHandler;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.output.OutputManager;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.trace.SaxonEventMulticaster;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.trax.Result;
import com.icl.saxon.trax.TransformException;
import com.icl.saxon.trax.Transformer;
import com.icl.saxon.trax.URIResolver;
import com.icl.saxon.trax.serialize.OutputFormat;
import com.icl.saxon.trax.serialize.QName;
import com.icl.saxon.tree.Builder;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.Stripper;
import java.io.IOException;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.ParserAdapter;

public class Controller
implements Transformer {
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    private Bindery bindery = new Bindery();
    private ContentHandler inputContentHandler = null;
    private ContentHandler outputContentHandler = null;
    private Context defaultContext;
    private DecimalFormatManager decimalFormatManager;
    private Emitter messageEmitter;
    private LexicalHandler lexicalHandler = null;
    private RuleManager ruleManager;
    private OutputDetails output;
    private OutputManager outputManager = new OutputManager();
    private ParameterSet parameters;
    private PreparedStyleSheet preparedStyleSheet;
    private TraceListener traceListener;
    private URIResolver uriResolver = new StandardURIResolver();
    private XMLReader sourceParser;
    private XSLStyleSheet styleSheetElement;
    private int recoveryPolicy = 1;
    private boolean outputterIsInitialized = false;
    private Hashtable sourceDocumentPool = new Hashtable();
    private Hashtable userDataTable = new Hashtable();
    private boolean lineNumbering;
    private boolean preview;
    private SAXException transformFailure = null;
    private String diagnosticName = "";

    public Controller() {
        this.defaultContext = this.makeContext(new DocumentImpl());
    }

    public void setDiagnosticName(String string) {
        this.diagnosticName = string;
    }

    public String toString() {
        return this.diagnosticName;
    }

    public void run(DocumentInfo documentInfo) throws SAXException {
        this.initializeOutputter();
        Context context = this.makeContext(documentInfo);
        this.applyTemplates(context, new SingletonNodeSet(documentInfo), this.getRuleManager().getMode(null), null);
    }

    private void visit(Context context, Mode mode) throws SAXException {
        NodeInfo nodeInfo = context.getCurrentNode();
        NodeHandler nodeHandler = this.ruleManager.getHandler(nodeInfo, mode, context);
        context.setMode(mode);
        if (nodeHandler == null) {
            nodeInfo.defaultAction(context);
        } else if (this.traceListener != null) {
            this.traceListener.enterSource(nodeHandler, context);
            nodeHandler.start(nodeInfo, context);
            this.traceListener.leaveSource(nodeHandler, context);
        } else {
            nodeHandler.start(nodeInfo, context);
        }
    }

    public void applyTemplates(Context context, Expression expression, Mode mode, ParameterSet parameterSet) throws SAXException {
        if (expression == null) {
            NodeInfo nodeInfo = context.getCurrentNode();
            int n = nodeInfo.getNumberOfChildren();
            if (n == 0) {
                return;
            }
            if (n == 1) {
                NodeInfo nodeInfo2 = (NodeInfo)nodeInfo.getFirstChild();
                Context context2 = context.newContext();
                context2.setLast(1);
                this.bindery.openStackFrame(parameterSet);
                context2.setCurrentNode(nodeInfo2);
                context2.setContextNode(nodeInfo2);
                context2.setPosition(1);
                this.visit(context2, mode);
                this.bindery.closeStackFrame();
            } else {
                NodeInfo[] nodeInfoArray = nodeInfo.getAllChildNodes();
                Context context3 = context.newContext();
                context3.setLast(n);
                int n2 = 0;
                while (n2 < n) {
                    this.bindery.openStackFrame(parameterSet);
                    context3.setCurrentNode(nodeInfoArray[n2]);
                    context3.setContextNode(nodeInfoArray[n2]);
                    context3.setPosition(n2 + 1);
                    this.visit(context3, mode);
                    this.bindery.closeStackFrame();
                    ++n2;
                }
            }
        } else {
            NodeSetValue nodeSetValue = expression.evaluateAsNodeSet(context);
            NodeEnumeration nodeEnumeration = nodeSetValue.enumerate();
            if (!(nodeEnumeration instanceof LastPositionFinder)) {
                nodeEnumeration = new LookaheadEnumerator(nodeEnumeration);
            }
            int n = 1;
            Context context4 = context.newContext();
            context4.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration));
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                this.bindery.openStackFrame(parameterSet);
                context4.setCurrentNode(nodeInfo);
                context4.setContextNode(nodeInfo);
                context4.setPosition(n++);
                this.visit(context4, mode);
                this.bindery.closeStackFrame();
            }
        }
    }

    public void applyImports(Context context, Mode mode, int n, int n2) throws SAXException {
        NodeInfo nodeInfo = context.getCurrentNode();
        NodeHandler nodeHandler = this.ruleManager.getHandler(nodeInfo, mode, n, n2, context);
        if (nodeHandler != null) {
            this.bindery.openStackFrame(null);
            nodeHandler.start(nodeInfo, context);
            this.bindery.closeStackFrame();
        }
    }

    public void setOutputManager(OutputManager outputManager) {
        this.outputManager = outputManager;
    }

    public OutputManager getOutputManager() {
        return this.outputManager;
    }

    private void initializeOutputter() throws SAXException {
        if (!this.outputterIsInitialized) {
            if (this.output == null) {
                this.output = new OutputDetails();
            }
            if (this.output.getEmitter() == null && this.styleSheetElement != null) {
                this.styleSheetElement.updateOutputDetails(this.output);
            }
            this.setNewOutputDetails(this.output);
        }
        this.outputterIsInitialized = true;
    }

    public Outputter getOutputter() {
        return this.outputManager.getOutputter();
    }

    public OutputDetails getInitialOutputDetails() {
        return this.output;
    }

    public void setOutputDetails(OutputDetails outputDetails) throws SAXException {
        this.output = outputDetails;
    }

    public void setNewOutputDetails(OutputDetails outputDetails) throws SAXException {
        this.outputManager.setOutputDetails(outputDetails);
    }

    public OutputDetails getCurrentOutputDetails() {
        return this.outputManager.getOutputDetails();
    }

    public Outputter resetOutputDetails() throws SAXException {
        return this.outputManager.resetOutputDetails();
    }

    public void setMessageEmitter(Emitter emitter) {
        this.messageEmitter = emitter;
    }

    public Emitter getMessageEmitter() {
        return this.messageEmitter;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void reportRecoverableError(String string, NodeInfo nodeInfo) throws SAXException {
        String string2;
        String string3 = string2 = nodeInfo == null ? ":" : " at line " + nodeInfo.getLineNumber();
        if (!"".equals(this.diagnosticName)) {
            string2 = string2 + " in transformation " + this.diagnosticName;
        }
        if (this.recoveryPolicy != 0) {
            if (this.recoveryPolicy == 1) {
                System.err.println("Recoverable error" + string2);
                System.err.println(string);
            } else {
                System.err.println("Recoverable error" + string2);
                System.err.println(string);
                System.err.println("Processing terminated because error recovery is disabled");
                throw new SAXException(string);
            }
        }
    }

    public Hashtable getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public Stripper getStripper() {
        return this.styleSheetElement.getStripper();
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public Context makeContext(NodeInfo nodeInfo) {
        Context context = new Context(this);
        context.setBindery(this.bindery);
        context.setCurrentNode(nodeInfo);
        context.setContextNode(nodeInfo);
        context.setPosition(1);
        context.setLast(1);
        return context;
    }

    public void setBindery(Bindery bindery) {
        this.bindery = bindery;
        this.defaultContext.setBindery(bindery);
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public KeyManager getKeyManager() {
        return this.styleSheetElement.getKeyManager();
    }

    public void setDecimalFormatManager(DecimalFormatManager decimalFormatManager) {
        this.decimalFormatManager = decimalFormatManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        return this.decimalFormatManager;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null;
    }

    public void setPreparedStyleSheet(PreparedStyleSheet preparedStyleSheet) {
        this.preparedStyleSheet = preparedStyleSheet;
        this.sourceParser = preparedStyleSheet.getXMLReader();
        this.styleSheetElement = (XSLStyleSheet)preparedStyleSheet.getStyleSheetDocument().getDocumentElement();
        if (this.uriResolver == null) {
            try {
                this.uriResolver = (URIResolver)preparedStyleSheet.getURIResolver().getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                this.uriResolver = new StandardURIResolver();
            }
            catch (IllegalAccessException illegalAccessException) {
                this.uriResolver = new StandardURIResolver();
            }
        }
    }

    public void setSourceParser(Parser parser) {
        this.setXMLReader(new ParserAdapter(parser));
    }

    public void setParams(ParameterSet parameterSet) {
        this.parameters = parameterSet;
    }

    private XSLStyleSheet getXSLStyleSheet() throws SAXException {
        return this.styleSheetElement;
    }

    private void initializeController() throws SAXException {
        this.setRuleManager(this.styleSheetElement.getRuleManager());
        this.setDecimalFormatManager(this.styleSheetElement.getDecimalFormatManager());
        if (this.traceListener != null) {
            this.traceListener.open();
        }
        Bindery bindery = new Bindery();
        this.setBindery(bindery);
        this.styleSheetElement.initialiseBindery(bindery);
        bindery.defineGlobalParameters(this.parameters);
    }

    public void transformDocument(DocumentInfo documentInfo) throws SAXException {
        block10: {
            this.transformFailure = null;
            if (this.styleSheetElement == null) {
                throw new SAXException("Stylesheet has not been prepared");
            }
            if (!this.preview) {
                this.initializeController();
            }
            Context context = this.makeContext(documentInfo);
            this.styleSheetElement.process(context);
            try {
                this.run(documentInfo);
            }
            catch (SAXException sAXException) {
                this.transformFailure = sAXException;
            }
            try {
                String string;
                if (this.traceListener != null) {
                    this.traceListener.close();
                }
                if ((string = this.styleSheetElement.getMediaType()) != null) {
                    this.output.setMediaType(string);
                }
                if (!this.preview) {
                    this.resetOutputDetails();
                }
            }
            catch (SAXException sAXException) {
                if (this.transformFailure != null) break block10;
                this.transformFailure = sAXException;
            }
        }
        if (this.transformFailure != null) {
            throw new SAXException(this.transformFailure);
        }
    }

    public void strip(DocumentInfo documentInfo) throws SAXException {
        if (this.styleSheetElement == null) {
            throw new SAXException("Stylesheet has not been prepared");
        }
        this.styleSheetElement.getStripper().strip(documentInfo);
    }

    public void addTraceListener(TraceListener traceListener) {
        this.traceListener = SaxonEventMulticaster.add(this.traceListener, traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        this.traceListener = SaxonEventMulticaster.remove(this.traceListener, traceListener);
    }

    public Object getUserData(NodeInfo nodeInfo, String string) {
        String string2 = string + " " + nodeInfo.hashCode();
        return this.userDataTable.get(string2);
    }

    public void setUserData(NodeInfo nodeInfo, String string, Object object) {
        String string2 = string + " " + nodeInfo.hashCode();
        if (object == null) {
            this.userDataTable.remove(string2);
        } else {
            this.userDataTable.put(string2, object);
        }
    }

    public void transform(InputSource inputSource) throws TransformException {
        try {
            if (this.preparedStyleSheet == null) {
                throw new TransformException("Stylesheet has not been prepared");
            }
            PreviewManager previewManager = this.styleSheetElement.getPreviewManager();
            boolean bl = this.preview = previewManager != null;
            if (this.preview) {
                this.initializeController();
                previewManager.setController(this);
                this.initializeOutputter();
                Builder builder = new Builder();
                builder.setXMLReader(this.sourceParser);
                builder.setStripper(this.styleSheetElement.getStripper());
                builder.setLineNumbering(this.lineNumbering);
                builder.setPreviewManager(previewManager);
                DocumentImpl documentImpl = builder.build(inputSource);
                builder = null;
                this.transformDocument(documentImpl);
                this.resetOutputDetails();
            } else {
                Builder builder = new Builder();
                builder.setXMLReader(this.sourceParser);
                builder.setStripper(this.styleSheetElement.getStripper());
                builder.setLineNumbering(this.lineNumbering);
                DocumentImpl documentImpl = builder.build(inputSource);
                builder = null;
                this.transformDocument(documentImpl);
            }
        }
        catch (SAXException sAXException) {
            throw new TransformException("Transform failed: " + this.diagnosticName + " " + sAXException.getMessage());
        }
    }

    public void transform(InputSource inputSource, Result result) throws TransformException {
        if (this.output == null) {
            this.output = new OutputDetails();
        }
        if (result.getByteStream() != null) {
            this.output.setOutputStream(result.getByteStream());
            this.output.setCloseAfterUse(false);
        } else if (result.getCharacterStream() != null) {
            this.output.setWriter(result.getCharacterStream());
            this.output.setCloseAfterUse(false);
        } else if (result.getNode() != null) {
            this.output.setMethod("saxon:dom");
            Node node = result.getNode();
            this.output.setDOMNode(node);
            if (!(node instanceof Document) && !(node instanceof Element)) {
                throw new TransformException("Result node must be a Document or Element node");
            }
        }
        this.transform(inputSource);
    }

    public void transformNode(Node node, Result result) throws TransformException {
        try {
            DOMDriver dOMDriver = new DOMDriver();
            dOMDriver.setStartNode(node);
            this.sourceParser = dOMDriver;
            InputSource inputSource = new InputSource();
            this.transform(inputSource, result);
        }
        catch (SAXException sAXException) {
            throw new TransformException(sAXException);
        }
    }

    public void transformNode(Node node) throws TransformException {
        if (node instanceof DocumentInfo) {
            try {
                this.transformDocument((DocumentInfo)node);
            }
            catch (SAXException sAXException) {
                throw new TransformException(sAXException);
            }
        } else {
            this.transformNode(node, new Result(System.out));
        }
    }

    public ContentHandler getInputContentHandler() {
        this.inputContentHandler = new ActiveBuilder();
        return this.inputContentHandler;
    }

    public DeclHandler getInputDeclHandler() {
        return null;
    }

    public LexicalHandler getInputLexicalHandler() {
        return (LexicalHandler)((Object)this.inputContentHandler);
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        if (this.output == null) {
            this.output = new OutputDetails();
        }
        this.output.setMethod(outputFormat.getMethod());
        this.output.setVersion(outputFormat.getVersion());
        this.output.setIndent(outputFormat.getIndent() ? "yes" : "no");
        this.output.setEncoding(outputFormat.getEncoding());
        this.output.setMediaType(outputFormat.getMediaType());
        this.output.setDoctypePublic(outputFormat.getDoctypePublicId());
        this.output.setDoctypeSystem(outputFormat.getDoctypeSystemId());
        this.output.setOmitDeclaration(outputFormat.getOmitXMLDeclaration() ? "yes" : "no");
        QName[] qNameArray = outputFormat.getCDataElements();
        int n = 0;
        while (n < qNameArray.length) {
            this.output.addCdataElement(Name.reconstruct(qNameArray[n].getPrefix(), qNameArray[n].getNamespaceURI(), qNameArray[n].getLocalName()));
            ++n;
        }
    }

    public void setParameter(String string, String string2, Object object) {
        Value value;
        if (this.parameters == null) {
            this.parameters = new ParameterSet();
        }
        try {
            value = FunctionProxy.convertJavaObjectToXPath(object);
        }
        catch (SAXException sAXException) {
            value = new StringValue(object.toString());
        }
        if (string2 == null || string2.equals("")) {
            this.parameters.put(string.intern(), value);
        } else {
            String string3 = Name.reconstruct("prefix", string2, string).getAbsoluteName();
            this.parameters.put(string3, value);
        }
    }

    public void resetParameters() {
        this.parameters = null;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver == null ? new StandardURIResolver() : uRIResolver;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.sourceParser = xMLReader;
    }

    public XMLReader getXMLReader() {
        return this.sourceParser;
    }

    public void setParent(XMLReader xMLReader) {
        this.setXMLReader(xMLReader);
    }

    public XMLReader getParent() {
        return this.getXMLReader();
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return false;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            if (!bl) {
                throw new SAXNotSupportedException(string);
            }
        } else if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            if (bl) {
                throw new SAXNotSupportedException(string);
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!string.equals("http://xml.org/sax/properties/lexical-handler")) throw new SAXNotRecognizedException(string);
        if (!(object instanceof LexicalHandler)) throw new SAXNotSupportedException("Lexical Handler must be instance of org.xml.sax.ext.LexicalHandler");
        Emitter emitter = null;
        if (this.output != null) {
            emitter = this.output.getEmitter();
        }
        if (emitter == null || !(emitter instanceof ContentHandlerProxy)) {
            throw new SAXNotSupportedException("Controller: cannot register a lexical handler unless a content handler has been registered");
        }
        this.lexicalHandler = (LexicalHandler)object;
        ((ContentHandlerProxy)emitter).setLexicalHandler(this.lexicalHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (this.output == null) {
            this.output = new OutputDetails();
        }
        this.outputContentHandler = contentHandler;
        ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
        contentHandlerProxy.setUnderlyingContentHandler(contentHandler);
        this.output.setMethod("saxon:user");
        this.output.setEmitter(contentHandlerProxy);
    }

    public ContentHandler getContentHandler() {
        return this.outputContentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.transform(inputSource);
    }

    public void parse(String string) throws IOException, SAXException {
        this.transform(new InputSource(string));
    }

    private class ActiveBuilder
    extends Builder {
        private ActiveBuilder() {
        }

        public void endDocument() throws SAXException {
            if (!this.failed) {
                try {
                    super.endDocument();
                    DocumentImpl documentImpl = this.getCurrentDocument();
                    Controller.this.transformDocument(documentImpl);
                }
                catch (SAXException sAXException) {
                    Controller.this.transformFailure = sAXException;
                    throw sAXException;
                }
            }
        }
    }
}

