# -*- encoding: utf-8 -*-
##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: account.py 1005 2005-07-25 08:41:42Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from osv import fields, osv
import ir

class res_partner(osv.osv):
	_name = 'res.partner'
	_inherit = 'res.partner'
	_columns = {
		'property_stock_customer': fields.property(
		  'stock.location',
		  type='many2one', 
		  relation='stock.location', 
		  string="Customer Location", 
		  method=True,
		  view_load=True,
		  group_name="Inventory Properties",
		  help="This stock location will be used, instead of the default one, as the destination location for goods you send to this partner"),
		'property_stock_supplier': fields.property(
		  'stock.location',
		  type='many2one', 
		  relation='stock.location', 
		  string="Supplier Location", 
		  method=True,
		  view_load=True,
		  group_name="Inventory Properties",
		  help="This stock location will be used, instead of the default one, as the source location for goods you receive from the current partner"),
	}
res_partner()


