/* org.sablevm.vm.BootstrapClassLoader
   Copyright (C) 2002 Free Software Foundation
 
Modifications Copyright (C) 2004 by Etienne Gagnon.
Modifications Copyright (C) 2004 by David Belanger.
Modifications Copyright (C) 2004, 2005 by Grzegorz Prokopski.

This file is part of the SableVM class library.
 
The SableVM class library is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2, or (at
your option) any later version.
 
The SableVM class library is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with the SableVM class library; see the file COPYING.  If not,
write to the Free Software Foundation, Inc., 59 Temple Place, Suite
330, Boston, MA 02111-1307 USA.
 
Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.
 
As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package java.lang;

import java.io.*;
import java.util.*;
import java.lang.reflect.*;

/**
 * @author Etienne M. Gagnon <etienne.gagnon@uqam,ca>
 */
class VirtualMachine
{
  /* useful routines for debugging (they do not require the full
   * java.io infrastructure). */
  public static native void print(boolean b);
  public static native void print(byte b);
  public static native void print(short s);
  public static native void print(char c);
  public static native void print(int i);
  public static native void print(long l);
  public static native void print(float f);
  public static native void print(double d);
  public static native void print(String s);

  public static native void println(boolean b);
  public static native void println(byte b);
  public static native void println(short s);
  public static native void println(char c);
  public static native void println(int i);
  public static native void println(long l);
  public static native void println(float f);
  public static native void println(double d);
  public static native void println(String s);

  private static void exceptionDescribe(Throwable e)
  {
    e.printStackTrace();
  }

  private static String exceptionDescription(Throwable e) throws IOException
  {
      StringWriter sw = new StringWriter();
      PrintWriter pw = new PrintWriter(sw);
      e.printStackTrace(pw);
      pw.close();
      sw.close();
      return sw.toString();
  }

  private static String exceptionTruncatedDescription(Throwable e)
  {
      return e.toString();
  }

  private static void main(String[] args)
  throws ClassNotFoundException
  {
    ClassLoader cl = ClassLoader.getSystemClassLoader();
    Class mainClass = cl.loadClass(args[0]);

    // If you want to use the bootstrap class loader instead, replace
    // the above two lines by the following one:
    // Class mainClass = VMClassLoader.loadClass(args[0], false);

    String[] newArgs = new String[args.length - 1];
    System.arraycopy(args, 1, newArgs, 0, args.length - 1);

    invokeMain (mainClass, newArgs);
  }

  private static native void invokeMain(Class mainClass, String[] newArgs);

  private static Class createClass(ClassLoader cl, String name)
  throws ClassNotFoundException
  {
    return cl.loadClass(name.replace('/','.'));
  }

  private static Class createArray(ClassLoader cl, String name)
  throws ClassNotFoundException
  {
    return cl.createArray(name.replace('/','.'), false);
  }

  private static int numRootThreadsCreated;

  private static Thread createRootThread(byte[] vmData)
  {
    Thread thread = new Thread("Main-" + ++numRootThreadsCreated, ThreadGroup.root);
    thread.vmData = vmData;

    return thread;
  }

  private static void runThread()
  {
    Thread.currentThread().callRun();
  }

  private static byte[] getSystemClassLoader()
  {
    return ClassLoader.getSystemClassLoader().vmData;
  }
}
