require 'runit/testcase'
require 'runit/cui/testrunner'
require 'runit/ext/testsetup'

class SetupFile
  include RUNIT::EXT::TestSetup
  attr_reader :out
  attr_reader :outfile
  def setup
    @outfile = File.expand_path("./tmp.txt")
    @out = open(@outfile, "w")
  end
  def teardown
    @out.close
    File.delete(@outfile)
  end
end

class TestSampleTestSetup < RUNIT::TestCase
  def decorated(setupfile)
    @setupfile = setupfile
  end

  def test_write
    assert_equal(3, @setupfile.out.write("foo"))
  end
  def test_write2
    assert_equal(4, @setupfile.out.write("abcd"))
  end
end

if $0 == __FILE__
  RUNIT::CUI::TestRunner.run(SetupFile.new(TestSampleTestSetup.suite))
end
