use strict;
use warnings;

use RT::Test tests => undef;

my $ticket = RT::Ticket->new(RT::CurrentUser->new('root'));
my ($ok, $msg) = $ticket->Create(Queue => 1, Owner => 'nobody', Subject => 'bad music');
ok($ok);

my ($baseurl, $m) = RT::Test->started_ok;

my $test_page = "/Ticket/Display.html?id=$ok;Action=Take";

$m->get_ok($test_page);
$m->content_contains("update a ticket");
ok($m->form_name('login'),"Found the login form");
$m->submit_form(
    form_name => 'login',
    fields    => {
        user => 'root',
        pass => 'password'
    }
);
$m->content_contains('Owner changed from Nobody to root');

$ticket->Load($ticket->Id);
is($ticket->OwnerObj->Name,'root',"Ticket was assigned to root");

undef $m;
done_testing;
