
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Volatility.i,v 1.4 2002/03/14 17:40:08 lballabio Exp $

#ifndef quantlib_volatility_i
#define quantlib_volatility_i

%include Date.i
%include DayCounters.i
%include Vectors.i
%include Matrix.i
%include Observer.i


// swaption volatilities

%{
using QuantLib::SwaptionVolatilityStructure;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;
typedef Handle<SwaptionVolatilityStructure>
    SwaptionVolatilityStructureHandle;
typedef RelinkableHandle<SwaptionVolatilityStructure>
    SwaptionVolatilityStructureRelinkableHandle;
%}

// export Handle to base class
%name(SwaptionVolatilityStructure) 
class SwaptionVolatilityStructureHandle : public ObservableHandle {
  private:
    // abstract class - no constructor exported
    SwaptionVolatilityStructureHandle();
  public:
	~SwaptionVolatilityStructureHandle();
};

// replicate the SwaptionVolatilityStructure interface
%addmethods SwaptionVolatilityStructureHandle {
	Date todaysDate() {
		return (*self)->todaysDate();
	}
	double _volatilityVsDate(Date exercise, Period length, Rate strike) {
		return (*self)->volatility(exercise,length,strike);
	}
	double _volatilityVsTime(Time exercise, double length, Rate strike) {
		return (*self)->volatility(exercise,length,strike);
	}
	bool __nonzero__() {
		return !self->isNull();
	}
}

AllowNoneAsInput(SwaptionVolatilityStructureHandle,
                 SwaptionVolatilityStructure);


// export RelinkableHandle to base class
%name(SwaptionVolatilityStructureHandle) 
class SwaptionVolatilityStructureRelinkableHandle
: public ObservableHandle {
  public:
    SwaptionVolatilityStructureRelinkableHandle(
        SwaptionVolatilityStructureHandle);
	~SwaptionVolatilityStructureRelinkableHandle();
	void linkTo(SwaptionVolatilityStructureHandle);
};

%addmethods SwaptionVolatilityStructureRelinkableHandle {
    bool __nonzero__() {
        return !self->isNull();
    }
}


// cap/floor volatilities

%{
using QuantLib::CapFlatVolatilityStructure;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;
typedef Handle<CapFlatVolatilityStructure>
    CapFlatVolatilityStructureHandle;
typedef RelinkableHandle<CapFlatVolatilityStructure>
    CapFlatVolatilityStructureRelinkableHandle;
%}

// export Handle to base class
%name(CapFlatVolatilityStructure) 
class CapFlatVolatilityStructureHandle : public ObservableHandle {
  private:
    // abstract class - no constructor exported
    CapFlatVolatilityStructureHandle();
  public:
	~CapFlatVolatilityStructureHandle();
};

// replicate the SwaptionVolatilityStructure interface
%addmethods CapFlatVolatilityStructureHandle {
	Date todaysDate() {
		return (*self)->todaysDate();
	}
	double _volatilityVsDate(Date end, Rate strike) {
		return (*self)->volatility(end,strike);
	}
	double _volatilityVsTime(Time end, Rate strike) {
		return (*self)->volatility(end,strike);
	}
	bool __nonzero__() {
		return !self->isNull();
	}
}

AllowNoneAsInput(CapFlatVolatilityStructureHandle,
                 CapFlatVolatilityStructure);


// export RelinkableHandle to base class
%name(CapFlatVolatilityStructureHandle) 
class CapFlatVolatilityStructureRelinkableHandle
: public ObservableHandle {
  public:
    CapFlatVolatilityStructureRelinkableHandle(
        CapFlatVolatilityStructureHandle);
	~CapFlatVolatilityStructureRelinkableHandle();
	void linkTo(CapFlatVolatilityStructureHandle);
};

%addmethods CapFlatVolatilityStructureRelinkableHandle {
    bool __nonzero__() {
        return !self->isNull();
    }
}




// actual structures

%{
using QuantLib::Volatilities::SwaptionVolatilityMatrix;
typedef Handle<SwaptionVolatilityMatrix> SwaptionVolatilityMatrixHandle;
%}

// Fake inheritance between Handles

%name(SwaptionVolatilityMatrix) 
class SwaptionVolatilityMatrixHandle 
: public SwaptionVolatilityStructureHandle {
  public:
    // constructor redefined below
    ~SwaptionVolatilityMatrixHandle();
};

%addmethods SwaptionVolatilityMatrixHandle {
    SwaptionVolatilityMatrixHandle(Date today, DateVector dates, 
        PeriodVector lengths, Matrix vols, DayCounter dayCounter) {
            return new SwaptionVolatilityMatrixHandle(
                new SwaptionVolatilityMatrix(today,dates,lengths,
                                             vols,dayCounter));
    }
}



%{
using QuantLib::Volatilities::CapFlatVolatilityVector;
typedef Handle<CapFlatVolatilityVector> CapFlatVolatilityVectorHandle;
%}

// Fake inheritance between Handles

%name(CapFlatVolatilityVector) 
class CapFlatVolatilityVectorHandle 
: public CapFlatVolatilityStructureHandle {
  public:
    // constructor redefined below
    ~CapFlatVolatilityVectorHandle();
};

%addmethods CapFlatVolatilityVectorHandle {
    CapFlatVolatilityVectorHandle(Date today, Calendar calendar,
        int settlementDays, PeriodVector lengths, DoubleVector vols, 
        DayCounter dayCounter) {
            return new CapFlatVolatilityVectorHandle(
                new CapFlatVolatilityVector(today,calendar,settlementDays,
                                            lengths,vols,dayCounter));
    }
}


#endif
