#line 10 "headerlexer.l"
/*
 * This file is part of Wireless Display Software for Linux OS
 *
 * Copyright (C) 2015 Intel Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <stdint.h>

#define YY_NO_UNISTD_H 1



#line 30 "gen/headerscanner.cpp"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE header_restart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via header_restart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void header_restart (FILE *input_file ,yyscan_t yyscanner );
void header__switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE header__create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void header__delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void header__flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void header_push_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void header_pop_buffer_state (yyscan_t yyscanner );

static void header_ensure_buffer_stack (yyscan_t yyscanner );
static void header__load_buffer_state (yyscan_t yyscanner );
static void header__init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER header__flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE header__scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE header__scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE header__scan_bytes (yyconst char *bytes,int len ,yyscan_t yyscanner );

void *header_alloc (yy_size_t ,yyscan_t yyscanner );
void *header_realloc (void *,yy_size_t ,yyscan_t yyscanner );
void header_free (void * ,yyscan_t yyscanner );

#define yy_new_buffer header__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        header_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            header__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        header_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            header__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define header_wrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
static void yy_fatal_error (yyconst char msg[] ,yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 46
#define YY_END_OF_BUFFER 47
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[646] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   47,   45,   11,    2,    3,    7,    6,    5,
       10,   42,    9,    8,    4,   45,   45,   45,   45,   45,
       45,   45,   45,   45,   45,   45,   45,   45,   31,   45,
       45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
       45,   45,   45,   45,    5,   42,   45,   45,   45,   45,
       45,   45,   45,   45,   45,   45,   45,   45,   45,   30,
        7,    6,    5,   10,   30,    9,    4,   30,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   11,
        1,   42,    0,    0,    0,    0,   29,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   31,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   42,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       30,   30,   30,   30,   29,   30,   30,   30,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,   41,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       30,   30,   30,   30,    0,    0,    0,    0,    0,    0,
        0,    0,   18,    0,    0,    0,    0,    0,    0,    0,
        0,   32,    0,    0,    0,    0,   37,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   18,   37,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   18,
        0,    0,    0,    0,    0,    0,    0,   30,   30,   30,
       30,   30,   30,   18,   30,   30,   30,   30,   30,   30,

       30,   30,    0,    0,    0,    0,    0,   22,    0,    0,
       20,    0,    0,    0,   29,    0,   17,    0,    0,    0,
        0,    0,    0,   39,   36,    0,    0,    0,    0,    0,
        0,   20,   39,   17,   36,    0,    0,    0,    0,    0,
        0,    0,   20,    0,    0,    0,    0,   17,    0,    0,
       30,   30,   30,   22,   30,   30,   20,   30,   30,   30,
       29,   30,   17,   30,   30,   30,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   41,    0,    0,    0,    0,   41,    0,

        0,    0,   30,   30,   30,   30,   30,   30,   30,   30,
       30,   30,   30,   30,    0,    0,    0,    0,    0,    0,
       14,   23,    0,    0,    0,    0,    0,    0,    0,   33,
        0,    0,    0,    0,    0,   14,   33,    0,    0,    0,
        0,    0,   14,    0,    0,    0,    0,   30,   30,   30,
       30,   14,   23,   30,   30,   30,   30,   30,   30,    0,
        0,   43,   44,    0,    0,   29,   43,   27,    0,   19,
        0,    0,    0,    0,   38,    0,    0,    0,    0,   19,
       38,    0,   19,    0,   30,   30,   30,   30,   29,   30,
       27,   30,   19,   30,    0,   12,    0,    0,    0,    0,

       21,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   30,   30,   30,   30,   30,    0,    0,
        0,    0,    0,    0,   29,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   30,   30,   30,   30,   29,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   30,   30,   30,   30,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   30,   30,   30,   30,   13,
        0,   25,   16,    0,   15,    0,   35,    0,   34,   16,
       35,   15,   34,    0,   30,   25,   16,   15,    0,    0,

        0,   40,    0,   30,   26,    0,    0,   26,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   24,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   28,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    1,    7,    8,    9,   10,   11,   12,   13,
       13,   13,   13,   13,   13,   13,   13,   14,   15,    1,
       16,    1,    1,    1,   17,   18,   19,   20,   21,   22,
       23,   24,   25,   26,   26,   27,   28,   29,   30,   31,
       32,   33,   34,   35,   36,   37,   38,   26,   39,   26,
        1,    1,    1,    1,   40,    1,   41,   42,   43,   44,

       45,   46,   47,   48,   49,   26,   26,   50,   51,   52,
       53,   54,   55,   56,   57,   58,   59,   60,   61,   26,
       62,   26,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[63] =
    {   0,
        1,    2,    3,    4,    2,    1,    1,    5,    1,    6,
        5,    5,    5,    7,    8,    1,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    7,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5
    } ;

static yyconst flex_int16_t yy_base[659] =
    {   0,
        0,   56,   14,   17,   23,   26,  117,  153,  211,  267,
      328,  384, 1713, 2645,   23, 2645, 1704, 2645, 2645, 2645,
     2645,   29, 2645,  100, 2645,   91, 1660,  125,   10,   18,
      127,  132,  124,  147,  194,  151,  123,    0,   32,    2,
      198,  215,  115,  121,  183,  323,  433,  188,  434,  331,
      435,  437,  336,  449, 1654,   40, 1647,  442,  224,  474,
      226,  462,  489,  497,  499,  505,  507,  514,  520,    0,
        0,    0,    0,    0,  180,    0,    0,  127,  357,  576,
      587,  564,  633,  692,  606,  750,  652,  664,  709,  193,
     2645,  237,  160,  210,  203, 1635, 2645,  481,  536,  227,

      333,  225,  229,  341,  443,  522,  584,  575,  241,  334,
     1635,  551,  311,  314,  433,  422,  444,  488,  445,  570,
      586,  588,  544,  590,  616,  558,  631,  597,  686,  712,
      640,  662, 1627,    0,  684,  673,  672,  738,  718,  739,
      758,  763,  721,  770,  775,  777,  786,  791,  799,  818,
        0,  624,  630,  835,    0,  846,  860,  876,  887,  903,
      914,  926,  940,  951, 1008,  968,  980, 1020,  658,  689,
      691,  788,  772,  457,  487,  346,  339,  768,  778,  819,
      850,  851,  508,  843, 1625, 1587,  606, 1611,  806,  840,
      878,  873,  649,  715,  934,  939,  180,  959,  966,  937,

      989,  999, 1005,  977,  998,    0, 1001, 1034, 1036,  952,
     1042, 1039, 1049, 1056, 1061, 1067, 1070, 1076, 1085, 1095,
     1031, 1122, 1136, 1153, 1165, 1188, 1199, 1210, 1226, 1238,
     1249, 1265, 1281, 1293, 1057,  833,  360, 1094, 1574,  351,
      538,   34, 1573, 1116, 1139,  924, 1182,  710,  885,  243,
     1099, 2645, 1072, 1081, 1117,  934, 2645, 1130, 1145, 1058,
     1156, 1187, 1198, 1200, 1137, 1259, 1563, 1552, 1262, 1282,
     1284, 1294, 1297, 1298,  991, 1309, 1163, 1310, 1318, 1317,
     1319, 1337, 1342, 1350, 1353, 1351, 1360, 1130, 1395, 1412,
     1423, 1435, 1446, 1462, 1473, 1485, 1499, 1510, 1522, 1536,

     1548, 1564, 1204, 1193, 1367, 1551, 1358, 2645,  719, 1043,
     1546, 1369, 1320, 1395, 1537, 1367, 1530,  780,  642, 1312,
     1226, 1205, 1264, 2645, 2645, 1386, 1231, 1417, 1429, 1409,
     1421, 1525, 1519, 1516, 1511, 1471, 1534, 1488, 1526, 1570,
     1562, 1467, 1375, 1575, 1576, 1584, 1589, 1590, 1596, 1591,
     1600, 1504, 1634,    0, 1645, 1659, 1671, 1683, 1694, 1612,
     1493, 1705, 1722, 1738, 1750, 1761, 1313, 1389, 1484, 1474,
     1549,  748,  535, 1461, 1445, 1455, 1624,  805, 1483, 1603,
     1471, 1535, 1617, 1614, 1633, 1684, 1716, 1708, 1719, 1749,
     1755, 1682, 1723, 1448, 1764, 1769, 1669, 1776, 1405, 1777,

     1786, 1788, 1389, 1363, 1824, 1836, 1847, 1861, 1877, 1346,
     1894, 1905, 1919, 1933, 1297, 1647, 1782,    0,  445,  854,
     1321, 2645, 1307, 1801, 1264,  990, 1579, 1818, 1650, 2645,
     1268, 1803, 1689, 1875, 1910, 1254, 1250, 1927, 1931, 1844,
     1850, 1922, 1809, 1825, 1940, 1942, 1945, 1953,  536, 1982,
     1993, 2005,    0, 2016, 1962, 2027, 2038, 2050, 2061, 1754,
     1213, 2645,    0, 2015,  794, 1216, 1117, 2645,  992, 1178,
     1841, 1862, 1856, 1909, 2645, 1953, 1965, 2010, 2021, 1171,
     1135, 2064, 2066, 2072,    0,  885, 2130, 2119, 1143, 1181,
        0, 2142, 2086, 2162, 1923, 2645, 1963, 1956,  603, 1967,

     1390,  663, 1086, 1815, 1863, 1886, 2076, 2087, 2089, 2097,
     2145, 2163, 2075, 2185, 2203, 2217, 2234, 2250, 2007, 2017,
     2110,  740, 2025, 1079, 1082, 2092, 2118, 2125, 2140, 2147,
     2179, 2194, 2218, 2253, 2267, 2281, 2299, 2315, 1055, 2149,
     2222, 2201,  949, 2164, 1026, 2183, 2233, 1026, 2240, 2258,
     2278, 2296, 2297, 2316, 2322, 2345, 2363, 2379, 2395,  982,
     2313,  957,  912,  934, 1256, 2236, 2242,  916, 2281, 2343,
     2361, 2364, 2373, 2393, 2400, 2425, 2436, 2447, 2458, 2645,
     2367, 2645,  894, 2322,  866, 2359, 2645,  818, 2645,  810,
      762,  720,  691, 2452, 2472,    0, 2488, 2500,  690, 2240,

      616, 2645, 2409, 2512, 2645, 2263, 2303,    0,  578, 2361,
     2386, 2439, 2336,  455, 2392, 2449,  350, 2455,  236, 2480,
      190,  184, 2645, 2476, 2486, 2478, 2486, 2500, 2489, 2489,
      128, 2506, 2503, 2506, 2511, 2507, 2502,   14, 2508, 2510,
     2509, 2508,   30, 2645, 2645, 2566, 2574, 2582, 2590, 2594,
     2601, 2605, 2607, 2614, 2621,    4, 2628, 2636
    } ;

static yyconst flex_int16_t yy_def[659] =
    {   0,
      646,  645,  647,  647,  646,  646,  646,    2,  648,  645,
      649,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  650,  650,  650,  650,
      650,  650,  650,  650,  650,  650,  650,  651,  645,  645,
      645,  645,  645,  645,  650,  650,  650,  650,  650,  650,
      650,  650,  650,  650,  652,  652,  652,  652,  653,  653,
      653,  653,  653,  653,  653,  653,  653,  653,  653,  654,
      654,  654,  654,  654,  654,  654,  654,  654,  655,  655,
      655,  655,  655,  655,  655,  655,  655,  655,  655,  645,
      645,  645,  645,  645,  645,  650,  645,  650,  650,  650,

      650,  650,  650,  650,  650,  650,  650,  650,  650,  650,
      651,  645,  645,  645,  645,  645,  645,  645,  645,  650,
      650,  650,  650,  650,  650,  650,  650,  650,  650,  650,
      650,  650,  652,  656,  652,  652,  653,  653,  653,  653,
      653,  653,  653,  653,  653,  653,  653,  653,  653,  653,
      654,  654,  654,  655,  654,  655,  655,  655,  655,  655,
      655,  655,  655,  655,  655,  655,  655,  655,  645,  645,
      645,  650,  650,  650,  650,  650,  650,  650,  650,  650,
      650,  650,  650,  650,  645,  645,  645,  645,  645,  645,
      645,  645,  650,  650,  650,  650,  650,  650,  650,  650,

      650,  650,  650,  650,  650,  656,  652,  653,  653,  653,
      653,  653,  653,  653,  653,  653,  653,  653,  653,  653,
      654,  655,  655,  655,  655,  655,  655,  655,  655,  655,
      655,  655,  655,  655,  645,  645,  645,  650,  650,  650,
      650,  650,  650,  650,  650,  650,  650,  650,  650,  650,
      650,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      650,  650,  650,  650,  650,  650,  650,  650,  650,  650,
      650,  650,  650,  650,  652,  653,  653,  653,  653,  653,
      653,  653,  653,  653,  653,  653,  653,  654,  655,  655,
      655,  655,  655,  655,  655,  655,  655,  655,  655,  655,

      655,  655,  645,  645,  645,  645,  650,  645,  650,  650,
      650,  650,  650,  645,  645,  650,  650,  650,  650,  650,
      645,  645,  645,  645,  645,  645,  645,  650,  650,  650,
      650,  650,  650,  650,  650,  650,  650,  650,  650,  656,
      653,  653,  653,  653,  653,  656,  653,  653,  653,  653,
      654,  654,  655,  654,  655,  655,  655,  655,  655,  654,
      654,  655,  655,  655,  655,  655,  645,  645,  645,  645,
      650,  650,  650,  650,  650,  645,  650,  650,  650,  650,
      645,  645,  645,  645,  645,  650,  650,  650,  650,  650,
      650,  650,  650,  656,  653,  653,  653,  653,  656,  653,

      653,  653,  654,  654,  655,  655,  655,  655,  655,  654,
      655,  655,  655,  655,  645,  645,  645,  657,  650,  650,
      650,  645,  650,  645,  650,  650,  650,  650,  645,  645,
      645,  645,  645,  650,  650,  650,  650,  650,  650,  650,
      650,  653,  653,  653,  653,  653,  653,  654,  658,  655,
      655,  655,  654,  655,  654,  655,  655,  655,  655,  645,
      645,  645,  657,  650,  650,  645,  645,  645,  650,  650,
      650,  645,  645,  645,  645,  650,  650,  650,  650,  650,
      650,  653,  653,  653,  654,  658,  655,  655,  654,  654,
      654,  655,  655,  655,  645,  645,  650,  650,  650,  645,

      645,  650,  650,  645,  645,  645,  650,  650,  650,  650,
      653,  653,  653,  655,  655,  655,  655,  655,  645,  650,
      650,  650,  645,  650,  645,  645,  645,  645,  650,  650,
      650,  650,  653,  653,  655,  655,  655,  655,  654,  645,
      650,  650,  650,  645,  650,  645,  645,  645,  645,  650,
      650,  650,  650,  653,  653,  655,  655,  655,  655,  645,
      650,  650,  650,  645,  650,  645,  645,  645,  645,  650,
      650,  650,  650,  653,  653,  655,  655,  655,  655,  645,
      650,  645,  650,  645,  650,  645,  645,  645,  645,  650,
      650,  650,  650,  653,  655,  654,  655,  655,  650,  645,

      645,  645,  653,  655,  645,  645,  645,  654,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,    0,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645
    } ;

static yyconst flex_int16_t yy_nxt[2708] =
    {   0,
      645,   15,   16,   17,   15,   18,   19,   20,  206,   21,
       22,   22,   22,   23,   24,   25,   16,   17,   14,   16,
       17,   14,  113,   97,   90,   16,   17,   90,   16,   17,
      100,   97,   26,   39,   39,   39,   39,   39,   39,   92,
       92,   92,  112,  112,  112,  644,  113,   97,  101,  134,
      135,  135,  135,  639,  311,   26,   14,   15,   16,   17,
       15,   18,   19,   20,   14,   21,   22,   22,   22,   23,
       24,   25,   27,   27,   28,   27,   27,   27,   29,   27,
       27,   27,   27,   27,   27,   30,   31,   27,   32,   33,
       34,   27,   27,   27,   27,   14,   27,   27,   28,   27,

       27,   27,   27,   27,   27,   27,   27,   27,   27,   35,
       27,   32,   36,   37,   27,   27,   27,   27,   15,   16,
       17,   15,   18,   19,   20,   95,   21,   22,   22,   22,
       23,   24,   25,   93,   94,  118,   97,   97,   97,   40,
       97,  119,  632,  102,  107,   97,   41,   42,   95,   26,
       43,   44,  105,  103,   98,  110,   93,   94,   99,  118,
       97,  153,  104,   40,   97,  119,  106,  109,  108,   41,
       42,  108,   26,   43,   44,   45,  105,   98,  110,  110,
      169,   99,   46,   47,  153,  104,   48,   49,  255,  106,
      152,  152,  152,   97,   90,  108,   97,   90,  624,   50,

      623,   97,  110,  120,  169,   51,   52,   97,  129,   53,
       54,   14,   15,   16,   17,   15,   18,   19,   55,   14,
       21,   56,   56,   56,   23,   24,   25,  121,  114,  104,
      115,  116,  130,  134,  170,  134,  171,   97,   97,   97,
       97,  117,   97,   58,  621,  177,  140,   92,   92,   92,
       14,  114,  104,  115,   97,  116,   97,  183,  170,  171,
      176,  174,  319,   96,  117,   96,   58,   14,   15,   16,
       17,   15,   18,   19,   55,   14,   21,   56,   56,   56,
       23,   24,   25,   59,   59,   60,   59,   59,   59,   61,
       59,   59,   59,   59,   59,   59,   62,   63,   59,   64,

       65,   66,   59,   59,   59,   59,   14,   59,   59,   60,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       67,   59,   64,   68,   69,   59,   59,   59,   59,   15,
       16,   17,   15,   71,   72,   73,   97,   74,   75,   75,
       75,   76,   24,   77,   97,  186,   97,   97,  187,   97,
      184,  121,   97,  122,   97,  123,  130,  151,  178,   97,
       78,  619,  151,  151,   97,  151,  151,  175,  186,  305,
      155,  187,  151,  306,  184,  121,  124,  243,  123,  242,
      130,  309,  178,   78,   70,   15,   16,   17,   15,   71,
       72,   73,   70,   74,   75,   75,   75,   76,   24,   77,

       79,   79,   80,   79,   79,   79,   81,   79,   79,   79,
       79,   79,   79,   82,   83,   79,   84,   85,   86,   79,
       79,   79,   79,   70,   79,   79,   80,   79,   79,   79,
       79,   79,   79,   79,   79,   79,   79,   87,   79,   84,
       88,   89,   79,   79,   79,   79,   97,   97,   97,  125,
       97,  134,  464,  127,  131,  188,   97,  189,   97,  126,
      190,  192,   97,  128,  616,  124,  110,  123,  104,  132,
       97,  134,  104,  127,  179,   97,  136,  127,  132,  188,
      189,  110,  128,  134,  190,  192,  128,   97,  124,  110,
      123,  104,  141,  132,   97,  104,  240,  179,  134,  136,

       97,   96,   97,  138,  110,  142,  134,  139,  134,  172,
       97,  241,   97,   96,  134,  143,  134,  145,   97,  147,
       97,   97,  191,  134,  144,  149,  138,   97,   96,  134,
      139,  146,  172,   97,  148,   97,   96,  150,   96,  463,
      250,  145,  144,  148,   96,  191,   96,  144,   97,   97,
      463,   97,  150,   96,  146,  180,  173,   97,  148,   96,
      150,  112,  112,  112,  151,  144,  197,  310,  421,  151,
      151,   97,  151,  151,  200,  150,  151,  155,  180,  151,
      173,  151,  151,   97,  151,  151,  611,  151,   97,  155,
      197,  151,  151,  151,  159,  151,  151,   97,  201,   97,

      155,   97,  151,   97,  193,  156,  151,  158,  181,  157,
       97,  151,  151,  201,  151,  151,   97,  181,  182,  155,
      194,  151,  195,  522,  196,  607,  165,  194,  156,   97,
      254,  181,  157,  151,  152,  152,  152,  201,  151,  151,
      181,  151,  151,  194,   97,  196,  155,  196,  151,  160,
      166,  198,  151,   97,  254,   97,  204,  151,  151,  161,
      151,  151,   97,  221,  151,  155,  199,  151,  162,  151,
      151,  379,  151,  151,  199,   97,   97,  155,  205,  151,
      205,  134,  134,  524,  166,   97,  221,  162,  261,  199,
      235,  162,  151,  134,  135,  135,  135,  151,  151,   97,

      151,  151,  205,  605,   97,  155,  207,  151,  166,  151,
      162,   96,  163,  235,  151,  151,  236,  151,  151,  181,
      202,  237,  155,   97,  151,   97,  164,  134,   97,  207,
      134,   97,   97,   97,   97,  372,  163,  213,  209,  236,
      317,  168,  181,  203,  237,  181,  203,  134,  134,  164,
      151,   97,   97,   97,  262,  151,  151,   96,  151,  151,
       96,   97,  209,  155,  168,  151,  208,  134,  181,  203,
      167,   97,  134,  210,  543,   97,   97,   96,   96,  134,
      420,   97,  168,   97,  134,   97,  134,  214,   97,  208,
       97,   97,  211,   97,  244,  134,  378,   96,  212,   97,

      134,   97,   96,  239,   97,  168,  215,   97,  134,   96,
      216,  214,   97,  245,   96,  219,   96,  244,   97,  217,
      218,  499,  238,   97,  217,   96,  239,  134,  602,  215,
       96,   97,   97,  216,  220,  151,  245,  426,   96,  256,
      151,  151,  217,  151,  151,  238,  151,  217,  155,  246,
      151,  151,  151,  304,  151,  151,   97,   96,  220,  155,
      151,  151,  256,   97,   97,  151,  151,   97,  151,  151,
      465,  251,  246,  155,  222,  151,  151,  304,  257,   97,
      223,  151,  151,  247,  151,  151,  248,  151,  463,  155,
      249,  151,  151,  151,  251,  151,  151,  222,   97,  463,

      155,  257,  151,  151,  223,  260,  247,   97,  151,  151,
      224,  151,  151,  258,  151,  318,  155,  259,  151,  151,
      151,  225,  151,  151,  588,   97,  151,  155,  260,  151,
      227,  151,  151,  314,  151,  151,  258,  315,  226,  155,
      151,  151,  584,  228,  583,  151,  151,   97,  151,  151,
       97,  151,   97,  155,  324,  151,  151,  151,  263,  151,
      151,  134,   97,  264,  155,   97,  151,  228,  151,  563,
      582,  229,   97,  151,  151,  267,  151,  151,  324,   97,
      151,  155,  264,  151,  230,  151,  151,  264,  151,  151,
       97,  240,  265,  155,  229,  151,  233,  580,  268,  266,

      340,  231,   97,   97,  306,   97,  469,  230,  151,  273,
      134,   97,   97,  151,  151,  266,  151,  151,   97,  502,
      151,  155,  266,  151,  231,  151,  151,  268,  151,  151,
      274,  275,  274,  155,  269,  151,  234,  568,  270,   97,
      271,  231,  232,  134,  272,  134,  565,   97,  134,   97,
      268,  134,   97,  274,  275,   97,   97,  271,  134,  546,
      234,  288,   97,  271,  231,  134,  278,  277,  276,   97,
      134,  373,  279,   96,   97,   96,  134,  327,   96,  134,
       97,   96,  281,   97,  288,  134,  546,  280,   96,   97,
      277,  276,   97,  303,  134,   96,  282,  283,   97,  525,

       96,  327,  321,  284,  134,  281,   96,   97,   97,   96,
      322,  285,   97,  545,  307,  249,  303,  286,  501,  282,
      283,  501,  151,  287,   96,  321,  284,  151,  151,   97,
      151,  151,  320,  322,   96,  155,  151,  151,  307,  351,
      312,  151,  151,  352,  151,  151,  287,  500,   97,  155,
       97,  151,   97,  151,  323,  320,  289,  332,  151,  151,
      325,  151,  151,  313,  312,  151,  155,  290,  151,   97,
      151,  151,  134,  151,  151,  326,  308,  323,  155,  289,
      151,  333,  501,  325,   97,  501,  328,  313,  151,  292,
      290,   97,  291,  151,  151,   97,  151,  151,  326,  151,

       97,  155,   96,  151,  151,  151,  316,  151,  151,  329,
      151,   97,  155,   97,  151,  151,  151,  329,  151,  151,
      500,  293,  368,  155,  367,  151,  151,  330,  496,  331,
      316,  151,  151,  382,  151,  151,  295,  294,  151,  155,
      329,  151,  381,  151,  151,  368,  151,  151,  367,  151,
      331,  155,  331,  151,  151,  151,  382,  151,  151,  295,
      385,  296,  155,   97,  151,  151,  381,   97,  297,   97,
      151,  151,   97,  151,  151,   97,  473,  468,  155,  333,
      151,  151,  298,  385,  296,  383,  151,  151,  585,  151,
      151,  297,  334,  151,  155,   97,  151,   97,  151,  151,

      299,  151,  151,  333,  300,  298,  155,   97,  151,  383,
       97,   97,  336,  301,  335,  335,  338,  339,  134,  134,
      466,  302,   97,   97,  337,   97,  134,  134,  134,  341,
       97,   97,   97,   97,   97,  337,  460,  335,  343,  342,
      339,  339,  380,  344,  302,  415,  134,  337,   96,   96,
       97,  346,  375,  341,  455,  315,   96,   96,   96,  134,
      134,  345,  134,   97,   97,  380,   97,  344,  415,  134,
      349,   97,  449,   97,  347,  375,   96,  369,  369,  369,
       97,   96,   97,  348,  134,  345,  371,  374,   97,   96,
       96,  501,   96,  350,  501,  151,  377,  448,  347,   96,

      151,  151,  384,  151,  151,  376,  376,  376,  155,  371,
      151,  374,  151,  424,   96,  353,  350,  151,  151,  377,
      151,  151,   97,  151,  416,  354,  384,  151,  151,  151,
       97,  151,  151,  386,   97,  151,  155,  388,  151,  353,
      151,  151,   97,  151,  151,  387,  151,  416,  155,  389,
      151,  151,  151,  355,  151,  151,  417,  387,   97,  155,
      389,  151,  151,  424,  356,  423,  357,  151,  151,  387,
      151,  151,  389,  151,  422,  155,  134,  151,  151,  151,
       97,  151,  151,  418,   97,  151,  155,  390,  151,  423,
      151,  151,  417,  151,  151,  396,   97,  358,  155,  151,

      151,   97,  404,  429,  151,  151,   96,  151,  360,  359,
      151,  391,  361,  404,  151,  151,  151,  392,  151,  151,
      427,  358,  151,  155,   97,  151,  429,  151,  151,   97,
      151,  151,   97,  359,  362,  155,  151,  151,   97,   97,
      393,  151,  151,   97,  151,  151,  370,   97,  151,  155,
      391,  151,  363,  151,  151,  393,  151,  151,  362,   97,
      370,  155,   97,  151,  151,   97,  364,  365,  430,  151,
      151,  134,  151,  151,  391,   97,   97,  155,  393,  151,
      394,  394,  394,  419,  134,  134,   97,  308,   97,   97,
      395,  430,   97,  397,  399,  399,  399,  366,  134,  134,

      134,   96,   97,   97,   97,  134,  419,  470,  398,   97,
      403,  403,  403,  395,   96,   96,   97,  397,  400,  255,
      366,  402,  410,  410,  410,  401,  253,  252,   96,   96,
       96,  398,  428,  431,  151,   96,  134,   97,  185,  151,
      151,  400,  151,  151,  402,  151,  432,  155,   97,  151,
      151,  151,  425,  151,  151,  428,  134,  431,  155,  151,
      151,  406,  405,  134,  151,  151,  472,  151,  151,  432,
      433,  151,  155,   97,  151,  425,  151,  151,  134,  151,
      151,  461,  422,  151,  155,  405,  151,  407,  151,  151,
      472,  151,  151,  433,  151,   97,  155,   97,  151,  151,

      151,  408,  151,  151,  461,  151,   91,  155,   96,  151,
      151,  151,  645,  151,  151,  645,  434,  475,  155,  440,
      151,   97,  151,  645,  645,  408,  409,  151,  151,   97,
      151,  151,   97,  645,  411,  155,   97,  151,  151,  435,
      475,  436,  441,  151,  151,  645,  151,  151,  435,  409,
      151,  155,  437,  151,  412,  151,  151,  411,  151,  151,
      441,  151,   97,  155,  437,  151,  151,  151,   97,  151,
      151,  435,  645,  134,  155,  437,  151,   97,  134,  413,
      645,  438,   97,  441,  495,  134,  134,  439,  645,   97,
       97,  414,  462,  462,  462,  134,  444,  134,  442,   97,

      645,   97,  443,   96,  439,  445,  645,  495,   96,  645,
      439,  467,  467,  467,  414,   96,   96,  447,  134,  474,
      444,  442,   97,  446,  151,   96,  645,   96,  445,  151,
      151,   97,  151,  151,  134,  526,  151,  155,  466,  151,
      447,  151,  151,  474,  151,  151,  645,  151,   96,  155,
      471,  151,  151,  151,   97,  151,  151,   97,  450,  526,
      155,  151,  151,   97,   96,  645,  151,  151,  451,  151,
      151,  645,  480,  471,  453,  503,  151,  151,  481,  645,
      452,  450,  151,  151,  527,  151,  151,  645,   97,  504,
      155,  476,  151,  505,  151,  481,  645,  454,  503,  151,

      151,  481,  151,  151,  645,  151,  528,  155,  527,  151,
      151,  151,  504,  151,  151,  477,  505,  645,  155,  151,
      151,  454,  456,   97,  151,  151,  477,  151,  151,  482,
      528,  134,  155,  151,  151,   97,  506,  457,  151,  151,
       97,  151,  151,  478,   97,  456,  155,  479,  151,  134,
      477,  134,  519,  468,  134,   97,  458,  645,   97,  506,
      645,   96,  459,  485,  485,  485,   97,  479,  645,   97,
      483,  479,  490,  490,  490,  519,   97,  484,   97,   96,
      507,   96,  151,  520,   96,  459,  645,  151,  151,  487,
      151,  151,  508,  151,  521,  155,  523,  151,  151,  151,

      484,  151,  151,  508,  645,  151,  155,  520,  151,  488,
      151,  151,  645,  151,  151,  508,  151,  521,  155,  523,
      151,  151,  151,   97,  151,  151,  645,  151,   97,  489,
       97,  151,  151,  151,   97,  151,  151,  509,  151,  540,
      491,  497,  151,  151,  151,  541,  151,  151,  510,  498,
      151,  155,  645,  151,  492,  151,  151,  544,  151,  151,
      510,  151,  540,  155,  497,  151,  151,  151,  541,  151,
      151,  510,  498,  134,  155,  134,  151,   97,  493,   97,
      544,  134,  645,  645,  134,   97,  151,  645,  525,   97,
      511,  151,  151,  494,  151,  151,  529,  645,  512,  155,

       97,  151,   97,   96,  645,   96,  513,  530,  645,  531,
       97,   96,  645,  511,   96,  645,  494,  532,  645,  151,
      530,  512,  645,   97,  151,  151,  547,  151,  151,  513,
      151,  530,  155,  532,  151,  151,  151,  548,  151,  151,
      542,  532,  151,  155,  645,  151,  516,  151,  151,  547,
      151,  151,  645,   97,  134,  155,  514,  151,   97,  549,
       97,  548,  151,  542,  515,  533,  645,  151,  151,  517,
      151,  151,  134,  645,  550,  155,   97,  151,  645,  514,
      645,  551,  549,  560,   96,  151,  564,  515,  645,  533,
      151,  151,   97,  151,  151,  645,  518,  551,  155,  645,

      151,  534,   96,  151,  551,  535,  560,   97,  151,  151,
      564,  151,  151,  552,   97,  566,  155,  151,  151,  518,
      645,  562,  151,  151,  534,  151,  151,  134,  553,  535,
      155,   97,  151,  645,  151,   97,  553,  537,  566,  151,
      151,  536,  151,  151,  561,  562,  554,  155,  645,  151,
      151,  553,  645,  567,  538,  151,  151,   96,  151,  151,
      569,  606,  134,  539,  536,  151,   97,  151,  561,  554,
      586,   97,  151,  151,  587,  151,  151,  567,  570,  609,
      155,  151,  151,  555,  569,  606,  151,  151,  645,  151,
      151,   97,   96,  586,  155,  556,  151,  587,  571,  151,

      645,  645,  571,  609,  151,  151,  555,  151,  151,   97,
       97,  557,  155,  589,  151,  151,  572,  573,  556,  610,
      151,  151,  571,  151,  151,  134,   97,  645,  155,   97,
      151,  134,  645,  558,  557,   97,  589,  645,  574,  645,
      573,  573,  575,  610,  645,  151,  645,  581,  645,  559,
      151,  151,  645,  151,  151,   96,   97,  615,  155,  600,
      151,   96,  574,  151,  645,  645,  575,  576,  151,  151,
      581,  151,  151,  645,   97,  590,  155,   97,  151,  151,
       97,  615,  600,  577,  151,  151,   97,  151,  151,  601,
      599,  576,  155,  591,  151,  151,  592,  612,  591,  578,

      151,  151,  134,  151,  151,  593,   97,  577,  155,  134,
      151,  617,  601,  582,  599,  579,  591,  645,  134,  593,
      612,  645,  605,  613,  645,  151,  645,  594,  593,  645,
      151,  151,   96,  151,  151,  617,  151,  645,  155,   96,
      151,  151,  151,  645,  151,  151,  613,  151,   96,  596,
      594,  151,  151,  151,  645,  151,  151,  645,  151,  595,
      155,  134,  151,  151,  151,   97,  151,  151,  645,  614,
      645,  155,  151,  151,  620,  603,  645,  151,  151,  597,
      151,  151,  595,  645,  618,  155,  645,  151,  151,  645,
      598,   96,  614,  151,  151,  604,  151,  151,  620,  603,

      151,  155,  627,  151,  628,  151,  151,  618,  151,  151,
      622,  625,  151,  155,  626,  151,  629,  151,  151,  604,
      151,  151,  630,  631,  633,  608,  627,  151,  628,  634,
      635,  636,  645,  622,  625,  637,  638,  626,  640,  641,
      629,  642,  643,  645,  645,  630,  631,  645,  633,  645,
      645,  645,  634,  645,  635,  636,  645,  645,  637,  638,
      645,  640,  641,  645,  642,  643,   14,   14,   14,   14,
       14,   14,   14,   14,   38,   38,   38,   38,   38,   38,
       38,   38,   57,   57,   57,   57,   57,   57,   57,   57,
       70,   70,   70,   70,   70,   70,   70,   70,   96,  645,

       96,  111,  111,  645,  645,  111,  111,  111,  111,  133,
      133,  137,  137,  137,  151,  645,  645,  645,  151,  151,
      151,  154,  645,  645,  645,  154,  154,  154,  463,  645,
      645,  463,  463,  463,  463,  463,  486,  645,  645,  486,
      486,  486,  486,  486,   13,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,

      645,  645,  645,  645,  645,  645,  645
    } ;

static yyconst flex_int16_t yy_chk[2708] =
    {   0,
        0,    1,    1,    1,    1,    1,    1,    1,  656,    1,
        1,    1,    1,    1,    1,    1,    3,    3,    3,    4,
        4,    4,   40,   29,   15,    5,    5,   15,    6,    6,
       29,   30,    1,    5,    5,    5,    6,    6,    6,   22,
       22,   22,   39,   39,   39,  643,   40,  242,   30,   56,
       56,   56,   56,  638,  242,    1,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,

        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    7,    7,
        7,    7,    7,    7,    7,   26,    7,    7,    7,    7,
        7,    7,    7,   24,   24,   43,   37,   33,   28,    7,
       31,   44,  631,   31,   33,   32,    7,    7,   26,    7,
        7,    7,   32,   31,   28,   37,   24,   24,   28,   43,
       34,   78,   31,    7,   36,   44,   32,   34,   33,    7,
        7,   36,    7,    7,    7,    8,   32,   28,   37,   34,
       93,   28,    8,    8,   78,   31,    8,    8,  197,   32,
       75,   75,   75,  197,   90,   36,   45,   90,  622,    8,

      621,   48,   34,   45,   93,    8,    8,   35,   48,    8,
        8,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,   45,   41,   35,
       41,   42,   48,   59,   94,   61,   95,   59,  102,   61,
      100,   42,  103,    9,  619,  103,   61,   92,   92,   92,
        9,   41,   35,   41,  109,   42,  250,  109,   94,   95,
      102,  100,  250,   59,   42,   61,    9,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,

       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   11,
       11,   11,   11,   11,   11,   11,   46,   11,   11,   11,
       11,   11,   11,   11,   50,  113,  101,  110,  114,   53,
      110,   50,  177,   46,  104,   46,   53,   79,  104,  176,
       11,  617,   79,   79,  240,   79,   79,  101,  113,  237,
       79,  114,   79,  237,  110,   50,   46,  177,   46,  176,
       53,  240,  104,   11,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,

       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   47,   49,   51,   47,
       52,   58,  419,   52,   49,  115,  105,  116,  419,   47,
      117,  119,   54,   52,  614,   51,   49,   51,   47,   54,
      174,   62,   52,   47,  105,   62,   58,   52,   49,  115,
      116,   54,   47,   60,  117,  119,   52,   60,   51,   49,
       51,   47,   62,   54,   98,   52,  174,  105,   63,   58,

      175,   62,   63,   60,   54,   63,   64,   60,   65,   98,
       64,  175,   65,   60,   66,   63,   67,   64,   66,   65,
       67,  183,  118,   68,   63,   66,   60,   68,   63,   69,
       60,   64,   98,   69,   68,  106,   64,   66,   65,  449,
      183,   64,   67,   65,   66,  118,   67,   63,  373,   99,
      449,  241,   69,   68,   64,  106,   99,  123,   68,   69,
       66,  112,  112,  112,   82,   67,  123,  241,  373,   82,
       82,  126,   82,   82,  126,   69,   80,   82,  106,   82,
       99,   80,   80,  120,   80,   80,  609,   81,  108,   80,
      123,   80,   81,   81,   82,   81,   81,  107,  126,  121,

       81,  122,   81,  124,  120,   80,   85,   81,  108,   80,
      128,   85,   85,  128,   85,   85,  499,  107,  107,   85,
      121,   85,  122,  499,  124,  601,   85,  120,   80,  125,
      187,  108,   80,   83,  152,  152,  152,  128,   83,   83,
      107,   83,   83,  121,  127,  122,   83,  124,   83,   83,
       85,  125,   87,  131,  187,  319,  131,   87,   87,   83,
       87,   87,  193,  153,   88,   87,  127,   87,   83,   88,
       88,  319,   88,   88,  125,  132,  502,   88,  132,   88,
      131,  137,  136,  502,   88,  137,  153,   87,  193,  127,
      169,   83,   84,  135,  135,  135,  135,   84,   84,  129,

       84,   84,  132,  599,  593,   84,  136,   84,   88,   89,
       87,  137,   84,  169,   89,   89,  170,   89,   89,  129,
      129,  171,   89,  248,   89,  130,   84,  139,  194,  136,
      143,  139,  309,  592,  143,  309,   84,  143,  139,  170,
      248,   89,  129,  129,  171,  130,  130,  138,  140,   84,
       86,  138,  140,  522,  194,   86,   86,  139,   86,   86,
      143,  372,  139,   86,   89,   86,  138,  141,  130,  130,
       86,  141,  142,  140,  522,  591,  142,  138,  140,  144,
      372,  178,   86,  144,  145,  173,  146,  144,  145,  138,
      146,  179,  141,  318,  178,  147,  318,  141,  142,  147,

      148,  172,  142,  173,  148,   86,  145,  465,  149,  144,
      146,  144,  149,  179,  145,  149,  146,  178,  378,  147,
      147,  465,  172,  590,  148,  147,  173,  150,  588,  145,
      148,  150,  180,  146,  150,  154,  179,  378,  149,  189,
      154,  154,  147,  154,  154,  172,  156,  148,  154,  180,
      154,  156,  156,  236,  156,  156,  184,  150,  150,  156,
      157,  156,  189,  181,  182,  157,  157,  420,  157,  157,
      420,  184,  180,  157,  156,  157,  158,  236,  190,  585,
      157,  158,  158,  181,  158,  158,  182,  159,  486,  158,
      182,  158,  159,  159,  184,  159,  159,  156,  249,  486,

      159,  190,  159,  160,  157,  192,  181,  583,  160,  160,
      158,  160,  160,  191,  161,  249,  160,  191,  160,  161,
      161,  159,  161,  161,  568,  563,  162,  161,  192,  161,
      161,  162,  162,  246,  162,  162,  191,  246,  160,  162,
      163,  162,  564,  162,  563,  163,  163,  195,  163,  163,
      200,  164,  196,  163,  256,  163,  164,  164,  195,  164,
      164,  210,  543,  196,  164,  210,  164,  162,  166,  543,
      562,  163,  198,  166,  166,  200,  166,  166,  256,  199,
      167,  166,  195,  166,  164,  167,  167,  196,  167,  167,
      204,  210,  198,  167,  163,  167,  167,  560,  200,  199,

      275,  166,  201,  426,  275,  469,  426,  164,  165,  204,
      207,  205,  202,  165,  165,  198,  165,  165,  203,  469,
      168,  165,  199,  165,  166,  168,  168,  201,  168,  168,
      205,  207,  204,  168,  202,  168,  168,  548,  202,  545,
      203,  165,  165,  208,  203,  209,  545,  208,  212,  209,
      201,  211,  212,  205,  207,  211,  310,  202,  213,  539,
      168,  221,  213,  203,  165,  214,  211,  209,  208,  214,
      215,  310,  212,  208,  215,  209,  216,  260,  212,  217,
      216,  211,  214,  217,  221,  218,  525,  213,  213,  218,
      209,  208,  524,  235,  219,  214,  215,  216,  219,  503,

      215,  260,  253,  217,  220,  214,  216,  238,  220,  217,
      254,  218,  251,  524,  238,  218,  235,  219,  467,  215,
      216,  467,  222,  220,  219,  253,  217,  222,  222,  244,
      222,  222,  251,  254,  220,  222,  223,  222,  238,  288,
      244,  223,  223,  288,  223,  223,  220,  489,  481,  223,
      265,  223,  245,  224,  255,  251,  222,  265,  224,  224,
      258,  224,  224,  245,  244,  225,  224,  223,  224,  261,
      225,  225,  277,  225,  225,  259,  277,  255,  225,  222,
      225,  265,  490,  258,  480,  490,  261,  245,  226,  225,
      223,  470,  224,  226,  226,  247,  226,  226,  259,  227,

      262,  226,  277,  226,  227,  227,  247,  227,  227,  261,
      228,  263,  227,  264,  227,  228,  228,  262,  228,  228,
      466,  226,  304,  228,  303,  228,  229,  263,  461,  264,
      247,  229,  229,  322,  229,  229,  228,  227,  230,  229,
      262,  229,  321,  230,  230,  304,  230,  230,  303,  231,
      263,  230,  264,  230,  231,  231,  322,  231,  231,  228,
      327,  229,  231,  437,  231,  232,  321,  436,  230,  565,
      232,  232,  266,  232,  232,  269,  431,  425,  232,  266,
      232,  233,  231,  327,  229,  323,  233,  233,  565,  233,
      233,  230,  269,  234,  233,  270,  233,  271,  234,  234,

      232,  234,  234,  266,  232,  231,  234,  272,  234,  323,
      273,  274,  270,  233,  271,  269,  273,  274,  276,  278,
      423,  234,  276,  278,  272,  320,  280,  279,  281,  276,
      280,  279,  281,  313,  421,  270,  415,  271,  279,  278,
      273,  274,  320,  281,  234,  367,  282,  272,  276,  278,
      282,  283,  313,  276,  410,  283,  280,  279,  281,  284,
      286,  282,  285,  284,  286,  320,  285,  281,  367,  287,
      286,  307,  404,  287,  284,  313,  282,  305,  305,  305,
      316,  283,  312,  285,  343,  282,  307,  312,  343,  284,
      286,  501,  285,  287,  501,  289,  316,  403,  284,  287,

      289,  289,  326,  289,  289,  314,  314,  314,  289,  307,
      289,  312,  290,  399,  343,  289,  287,  290,  290,  316,
      290,  290,  330,  291,  368,  290,  326,  290,  291,  291,
      328,  291,  291,  328,  331,  292,  291,  330,  291,  289,
      292,  292,  329,  292,  292,  329,  293,  368,  292,  331,
      292,  293,  293,  291,  293,  293,  394,  328,  375,  293,
      330,  293,  294,  376,  292,  375,  293,  294,  294,  329,
      294,  294,  331,  295,  374,  294,  342,  294,  295,  295,
      342,  295,  295,  370,  336,  296,  295,  336,  295,  375,
      296,  296,  369,  296,  296,  342,  379,  295,  296,  297,

      296,  338,  361,  381,  297,  297,  342,  297,  297,  296,
      298,  336,  297,  352,  297,  298,  298,  338,  298,  298,
      379,  295,  299,  298,  335,  298,  381,  299,  299,  334,
      299,  299,  333,  296,  298,  299,  300,  299,  332,  339,
      338,  300,  300,  317,  300,  300,  315,  337,  301,  300,
      337,  300,  299,  301,  301,  339,  301,  301,  298,  311,
      306,  301,  371,  301,  302,  268,  300,  301,  382,  302,
      302,  341,  302,  302,  337,  341,  267,  302,  339,  302,
      340,  340,  340,  371,  344,  345,  243,  239,  344,  345,
      341,  382,  427,  344,  346,  346,  346,  302,  347,  348,

      350,  341,  347,  348,  350,  349,  371,  427,  345,  349,
      351,  351,  351,  341,  344,  345,  380,  344,  347,  188,
      302,  350,  360,  360,  360,  349,  186,  185,  347,  348,
      350,  345,  380,  383,  353,  349,  133,  377,  111,  353,
      353,  347,  353,  353,  350,  355,  384,  353,   96,  353,
      355,  355,  377,  355,  355,  380,   57,  383,  355,  356,
      355,  355,  353,   55,  356,  356,  429,  356,  356,  384,
      385,  357,  356,   27,  356,  377,  357,  357,  397,  357,
      357,  416,  397,  358,  357,  353,  357,  356,  358,  358,
      429,  358,  358,  385,  359,  392,  358,  386,  358,  359,

      359,  358,  359,  359,  416,  362,   17,  359,  397,  359,
      362,  362,   13,  362,  362,    0,  386,  433,  362,  392,
      362,  388,  363,    0,    0,  358,  359,  363,  363,  387,
      363,  363,  389,    0,  362,  363,  393,  363,  364,  386,
      433,  388,  392,  364,  364,    0,  364,  364,  387,  359,
      365,  364,  389,  364,  364,  365,  365,  362,  365,  365,
      393,  366,  390,  365,  388,  365,  366,  366,  391,  366,
      366,  387,    0,  395,  366,  389,  366,  395,  396,  365,
        0,  390,  396,  393,  460,  398,  400,  391,    0,  398,
      400,  366,  417,  417,  417,  401,  398,  402,  395,  401,

        0,  402,  396,  395,  390,  400,    0,  460,  396,    0,
      391,  424,  424,  424,  366,  398,  400,  402,  443,  432,
      398,  395,  443,  401,  405,  401,    0,  402,  400,  405,
      405,  428,  405,  405,  444,  504,  406,  405,  444,  405,
      402,  406,  406,  432,  406,  406,    0,  407,  443,  406,
      428,  406,  407,  407,  471,  407,  407,  440,  405,  504,
      407,  408,  407,  441,  444,    0,  408,  408,  406,  408,
      408,    0,  440,  428,  408,  471,  408,  409,  441,    0,
      407,  405,  409,  409,  505,  409,  409,    0,  434,  472,
      409,  434,  409,  473,  411,  440,    0,  409,  471,  411,

      411,  441,  411,  411,    0,  412,  506,  411,  505,  411,
      412,  412,  472,  412,  412,  434,  473,    0,  412,  413,
      412,  409,  411,  435,  413,  413,  435,  413,  413,  442,
      506,  442,  413,  414,  413,  442,  474,  412,  414,  414,
      438,  414,  414,  438,  439,  411,  414,  439,  414,  445,
      435,  446,  495,  445,  447,  446,  413,    0,  447,  474,
        0,  442,  414,  448,  448,  448,  476,  438,    0,  498,
      446,  439,  455,  455,  455,  495,  497,  447,  477,  445,
      476,  446,  450,  497,  447,  414,    0,  450,  450,  450,
      450,  450,  477,  451,  498,  450,  500,  450,  451,  451,

      447,  451,  451,  476,    0,  452,  451,  497,  451,  451,
      452,  452,    0,  452,  452,  477,  454,  498,  452,  500,
      452,  454,  454,  478,  454,  454,    0,  456,  464,  454,
      520,  454,  456,  456,  479,  456,  456,  478,  457,  519,
      456,  464,  456,  457,  457,  520,  457,  457,  479,  464,
      458,  457,    0,  457,  457,  458,  458,  523,  458,  458,
      478,  459,  519,  458,  464,  458,  459,  459,  520,  459,
      459,  479,  464,  482,  459,  483,  459,  482,  458,  483,
      523,  484,    0,    0,  513,  484,  493,    0,  513,  507,
      482,  493,  493,  459,  493,  493,  507,    0,  482,  493,

      508,  493,  509,  482,    0,  483,  484,  508,    0,  509,
      510,  484,    0,  482,  513,    0,  459,  510,    0,  488,
      507,  482,    0,  521,  488,  488,  526,  488,  488,  484,
      487,  508,  488,  509,  488,  487,  487,  527,  487,  487,
      521,  510,  492,  487,    0,  487,  488,  492,  492,  526,
      492,  492,    0,  529,  511,  492,  487,  492,  511,  528,
      530,  527,  494,  521,  487,  511,    0,  494,  494,  492,
      494,  494,  512,    0,  529,  494,  512,  494,    0,  487,
        0,  530,  528,  540,  511,  514,  544,  487,    0,  511,
      514,  514,  531,  514,  514,    0,  494,  529,  514,    0,

      514,  512,  512,  515,  530,  514,  540,  532,  515,  515,
      544,  515,  515,  531,  542,  546,  515,  516,  515,  494,
        0,  542,  516,  516,  512,  516,  516,  533,  532,  514,
      516,  533,  516,    0,  517,  541,  531,  516,  546,  517,
      517,  515,  517,  517,  541,  542,  533,  517,    0,  517,
      518,  532,    0,  547,  517,  518,  518,  533,  518,  518,
      549,  600,  534,  518,  515,  518,  534,  535,  541,  533,
      566,  550,  535,  535,  567,  535,  535,  547,  550,  606,
      535,  536,  535,  534,  549,  600,  536,  536,    0,  536,
      536,  551,  534,  566,  536,  535,  536,  567,  551,  537,

        0,    0,  550,  606,  537,  537,  534,  537,  537,  552,
      553,  536,  537,  569,  537,  538,  552,  553,  535,  607,
      538,  538,  551,  538,  538,  554,  561,    0,  538,  554,
      538,  555,    0,  537,  536,  555,  569,    0,  554,    0,
      552,  553,  555,  607,    0,  556,    0,  561,    0,  538,
      556,  556,    0,  556,  556,  554,  570,  613,  556,  584,
      556,  555,  554,  557,    0,    0,  555,  556,  557,  557,
      561,  557,  557,    0,  571,  570,  557,  572,  557,  558,
      581,  613,  584,  557,  558,  558,  573,  558,  558,  586,
      581,  556,  558,  571,  558,  559,  572,  610,  570,  558,

      559,  559,  574,  559,  559,  573,  574,  557,  559,  575,
      559,  615,  586,  575,  581,  559,  571,    0,  603,  572,
      610,    0,  603,  611,    0,  576,    0,  574,  573,    0,
      576,  576,  574,  576,  576,  615,  577,    0,  576,  575,
      576,  577,  577,    0,  577,  577,  611,  578,  603,  577,
      574,  577,  578,  578,    0,  578,  578,    0,  579,  576,
      578,  594,  578,  579,  579,  594,  579,  579,    0,  612,
        0,  579,  595,  579,  618,  594,    0,  595,  595,  578,
      595,  595,  576,    0,  616,  595,    0,  595,  597,    0,
      579,  594,  612,  597,  597,  595,  597,  597,  618,  594,

      598,  597,  626,  597,  627,  598,  598,  616,  598,  598,
      620,  624,  604,  598,  625,  598,  628,  604,  604,  595,
      604,  604,  629,  630,  632,  604,  626,  604,  627,  633,
      634,  635,    0,  620,  624,  636,  637,  625,  639,  640,
      628,  641,  642,    0,    0,  629,  630,    0,  632,    0,
        0,    0,  633,    0,  634,  635,    0,    0,  636,  637,
        0,  639,  640,    0,  641,  642,  646,  646,  646,  646,
      646,  646,  646,  646,  647,  647,  647,  647,  647,  647,
      647,  647,  648,  648,  648,  648,  648,  648,  648,  648,
      649,  649,  649,  649,  649,  649,  649,  649,  650,    0,

      650,  651,  651,    0,    0,  651,  651,  651,  651,  652,
      652,  653,  653,  653,  654,    0,    0,    0,  654,  654,
      654,  655,    0,    0,    0,  655,  655,  655,  657,    0,
        0,  657,  657,  657,  657,  657,  658,    0,    0,  658,
      658,  658,  658,  658,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,

      645,  645,  645,  645,  645,  645,  645
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET

#include <string>

#include "parser.h"
#define yyterminate() return(END)

#define INITIAL 0
#define MATCH_STRING_STATE 1
#define MATCH_RESPONSE_CODE_STATE 2
#define SUPPORTED_METHODS_STATE 3
#define CONTENT_TYPE_STATE 4
#define SESSION_STATE 5

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#define YY_EXTRA_TYPE bool

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

static int yy_init_globals (yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int header_lex_init (yyscan_t* scanner);

int header_lex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int header_lex_destroy (yyscan_t yyscanner );

int header_get_debug (yyscan_t yyscanner );

void header_set_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE header_get_extra (yyscan_t yyscanner );

void header_set_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *header_get_in (yyscan_t yyscanner );

void header_set_in  (FILE * in_str ,yyscan_t yyscanner );

FILE *header_get_out (yyscan_t yyscanner );

void header_set_out  (FILE * out_str ,yyscan_t yyscanner );

int header_get_leng (yyscan_t yyscanner );

char *header_get_text (yyscan_t yyscanner );

int header_get_lineno (yyscan_t yyscanner );

void header_set_lineno (int line_number ,yyscan_t yyscanner );

YYSTYPE * header_get_lval (yyscan_t yyscanner );

void header_set_lval (YYSTYPE * yylval_param ,yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int header_wrap (yyscan_t yyscanner );
#else
extern int header_wrap (yyscan_t yyscanner );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int header_lex \
               (YYSTYPE * yylval_param ,yyscan_t yyscanner);

#define YY_DECL int header_lex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			header_ensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				header__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		header__load_buffer_state(yyscanner );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 646 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 645 );
		yy_cp = yyg->yy_last_accepting_cpos;
		yy_current_state = yyg->yy_last_accepting_state;

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
{ BEGIN(INITIAL); }
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
{ BEGIN(INITIAL); }
	YY_BREAK
case 3:
YY_RULE_SETUP
{ BEGIN(INITIAL); }
	YY_BREAK
/* Convert these */
case 4:
YY_RULE_SETUP
{ return '='; }
	YY_BREAK
case 5:
YY_RULE_SETUP
{ return '-'; }
	YY_BREAK
case 6:
YY_RULE_SETUP
{ return ','; }
	YY_BREAK
case 7:
YY_RULE_SETUP
{ return '*'; }
	YY_BREAK
case 8:
YY_RULE_SETUP
{ return ';'; }
	YY_BREAK
case 9:
YY_RULE_SETUP
{ return ':'; }
	YY_BREAK
case 10:
YY_RULE_SETUP
{ return '/'; }
	YY_BREAK
case 11:
YY_RULE_SETUP
return WFD_SP;
	YY_BREAK
case 12:
YY_RULE_SETUP
return WFD_TIMEOUT;
	YY_BREAK
case 13:
YY_RULE_SETUP
return WFD_SERVER_PORT;
	YY_BREAK
case 14:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    return WFD_OPTIONS;
  }
	YY_BREAK
case 15:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    return WFD_SET_PARAMETER;
  }
	YY_BREAK
case 16:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    return WFD_GET_PARAMETER;
  }
	YY_BREAK
case 17:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    return WFD_SETUP;
  }
	YY_BREAK
case 18:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    return WFD_PLAY;
  }
	YY_BREAK
case 19:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    return WFD_TEARDOWN;
  }
	YY_BREAK
case 20:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    return WFD_PAUSE;
  }
	YY_BREAK
/* RTSP response, get reply code, RTSP/1.0 200 OK */
case 21:
YY_RULE_SETUP
{
    BEGIN(MATCH_RESPONSE_CODE_STATE);
    return WFD_RESPONSE;
  }
	YY_BREAK
/* CSeq: i */
case 22:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    return WFD_CSEQ;
  }
	YY_BREAK
case 23:
YY_RULE_SETUP
{
    BEGIN(SUPPORTED_METHODS_STATE);
    return WFD_RESPONSE_METHODS;
  }
	YY_BREAK
case 24:
YY_RULE_SETUP
{
    return WFD_SUPPORT_CHECK;
  }
	YY_BREAK
case 25:
YY_RULE_SETUP
{
    BEGIN(CONTENT_TYPE_STATE);
    return WFD_CONTENT_TYPE;
  }
	YY_BREAK
case 26:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    return WFD_CONTENT_LENGTH;
  }
	YY_BREAK
case 27:
YY_RULE_SETUP
{
    BEGIN(SESSION_STATE);
    return WFD_SESSION;
  }
	YY_BREAK
case 28:
YY_RULE_SETUP
{
    return WFD_TRANSPORT;
  }
	YY_BREAK
case 29:
YY_RULE_SETUP
{
    BEGIN(MATCH_STRING_STATE);
    yylval->sval = new std::string(yytext, yyleng - 1);
    return WFD_HEADER;
  }
	YY_BREAK
case 30:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    yylval->sval = new std::string(yytext, yyleng);
    return WFD_SESSION_ID;
  }
	YY_BREAK
case 31:
YY_RULE_SETUP
{
    BEGIN(MATCH_STRING_STATE);
    yylval->nval = atoi(yytext);
    return WFD_RESPONSE_CODE;
  }
	YY_BREAK
case 32:
/* rule 32 can match eol */
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    yylval->sval = new std::string(yytext);
    return WFD_STRING;
  }
	YY_BREAK
case 33:
YY_RULE_SETUP
{
    return WFD_OPTIONS;
  }
	YY_BREAK
case 34:
YY_RULE_SETUP
{
    return WFD_SET_PARAMETER;
  }
	YY_BREAK
case 35:
YY_RULE_SETUP
{
    return WFD_GET_PARAMETER;
  }
	YY_BREAK
case 36:
YY_RULE_SETUP
{
    return WFD_SETUP;
  }
	YY_BREAK
case 37:
YY_RULE_SETUP
{
    return WFD_PLAY;
  }
	YY_BREAK
case 38:
YY_RULE_SETUP
{
    return WFD_TEARDOWN;
  }
	YY_BREAK
case 39:
YY_RULE_SETUP
{
    return WFD_PAUSE;
  }
	YY_BREAK
case 40:
YY_RULE_SETUP
{
  return WFD_TAG;
  }
	YY_BREAK
case 41:
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    yylval->sval = new std::string(yytext);
    return WFD_MIME;
  }
	YY_BREAK
case 42:
YY_RULE_SETUP
{
    std::string str(yytext, yyleng);
    str += '\0';
    errno = 0;
    yylval->nval = strtoull(str.c_str(), NULL, 10);
    if (errno)
      yyterminate();
    return WFD_NUM;
  }
	YY_BREAK
/* RTSP request rule,  e.g., OPTIONS * RTSP/1.0 */
case 43:
YY_RULE_SETUP
{
    return WFD_END;
  }
	YY_BREAK
/* GET_PARAMETER rtsp://localhost/wfd1.0 RTSP/1.0 */
case 44:
YY_RULE_SETUP
{
    yylval->sval = new std::string(yytext);
    return WFD_REQUEST_URI;
  }
	YY_BREAK
/* all unmatched */
case 45:
YY_RULE_SETUP
{}
	YY_BREAK
case 46:
YY_RULE_SETUP
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(MATCH_STRING_STATE):
case YY_STATE_EOF(MATCH_RESPONSE_CODE_STATE):
case YY_STATE_EOF(SUPPORTED_METHODS_STATE):
case YY_STATE_EOF(CONTENT_TYPE_STATE):
case YY_STATE_EOF(SESSION_STATE):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * header_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_last_accepting_cpos;
				yy_current_state = yyg->yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( header_wrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of header_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = yyg->yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					header_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			header_restart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) header_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 646 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	register int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	register char *yy_cp = yyg->yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 646 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 645);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					header_restart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( header_wrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void header_restart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        header_ensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            header__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	header__init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	header__load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void header__switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		header_pop_buffer_state();
	 *		header_push_buffer_state(new_buffer);
     */
	header_ensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	header__load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (header_wrap()) processing, but the only time this flag
	 * is looked at is after header_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void header__load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE header__create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) header_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in header__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) header_alloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in header__create_buffer()" );

	b->yy_is_our_buffer = 1;

	header__init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with header__create_buffer()
 * @param yyscanner The scanner object.
 */
    void header__delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		header_free((void *) b->yy_ch_buf ,yyscanner );

	header_free((void *) b ,yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a header_restart() or at EOF.
 */
    static void header__init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	header__flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then header__init_buffer was _probably_
     * called from header_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void header__flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		header__load_buffer_state(yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void header_push_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	header_ensure_buffer_stack(yyscanner);

	/* This block is copied from header__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from header__switch_to_buffer. */
	header__load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void header_pop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	header__delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		header__load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void header_ensure_buffer_stack (yyscan_t yyscanner)
{
	int num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)header_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in header_ensure_buffer_stack()" );
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)header_realloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in header_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE header__scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) header_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in header__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	header__switch_to_buffer(b ,yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to header_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       header__scan_bytes() instead.
 */
YY_BUFFER_STATE header__scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return header__scan_bytes(yystr,strlen(yystr) ,yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to header_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE header__scan_bytes  (yyconst char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) header_alloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in header__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = header__scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in header__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE header_get_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int header_get_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int header_get_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *header_get_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *header_get_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int header_get_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *header_get_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void header_set_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void header_set_lineno (int  line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "header_set_lineno called with no buffer" , yyscanner); 
    
    yylineno = line_number;
}

/** Set the current column.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void header_set_column (int  column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "header_set_column called with no buffer" , yyscanner); 
    
    yycolumn = column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see header__switch_to_buffer
 */
void header_set_in (FILE *  in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = in_str ;
}

void header_set_out (FILE *  out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = out_str ;
}

int header_get_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void header_set_debug (int  bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * header_get_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void header_set_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* User-visible API */

/* header_lex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int header_lex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) header_alloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* header_lex_init_extra has the same functionality as header_lex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to header_alloc in
 * the yyextra field.
 */

int header_lex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    header_set_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) header_alloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    header_set_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from header_lex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * header_lex_init()
     */
    return 0;
}

/* header_lex_destroy is for both reentrant and non-reentrant scanners. */
int header_lex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		header__delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		header_pop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	header_free(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        header_free(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * header_lex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    header_free ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *header_alloc (yy_size_t  size , yyscan_t yyscanner)
{
	return (void *) malloc( size );
}

void *header_realloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void header_free (void * ptr , yyscan_t yyscanner)
{
	free( (char *) ptr );	/* see header_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

