#ifndef VISUAL_WGL_H
#define VISUAL_WGL_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

// wgl - Windows platform-specific GL and windowing code

#include "vector.h"

#include <vector>
#include <utility>
#include <map>
#include <string>

#include "platform.h"
#include "glcontext.h"
#include <GL/gl.h>

namespace visual
{

struct wglFont : glFont 
{
  public:
    // Documentation for these functions is in glFont, not here.
    virtual double getWidth(const char* string);
    virtual double ascent();
    virtual double descent();
    virtual void draw(const char* string);
    virtual void release();

    // for the use of wglContext only:
    wglFont( struct wglContext& cx, HFONT font );
    virtual ~wglFont();
    void addref() {refcount++;}

  private:
    struct wglContext& cx;
    int listBase;
    HFONT hfont;
    int lu_ascent, lu_descent;  // in Windows "logical units"
    int refcount;
};

struct wglContext : glContext 
{
  public:
    void lockMouse();
    void unlockMouse();
    void showMouse();
    void hideMouse();
    int  getMouseButtons();
    int  getMouseButtonsChanged();
    int getShiftKey();
    int getAltKey();
    int getCtrlKey();
    vector  getMouseDelta();
    vector  getMousePos();
    std::string getKeys();

    wglContext();
    ~wglContext();

    bool initWindow( const char* title, int x, int y, int width, int height, int flags );
    bool changeWindow( const char* title, int x, int y, int width, int height, int flags );
    bool isOpen();
    void cleanup();
  
    void makeCurrent();
    void makeNotCurrent();
    void swapBuffers();

    vector origin();   // top left of entire window (or, same as initWindow())
    vector corner();   // bottom right of entire window (or, same as initWindow())
    int width();       // of GL area
    int height();      // of GL area

    std::string lastError() { return error_message; }
    bool   mustPaint;

    glFont* getFont( const char* description, double size);

	void add_pending_glDeleteList(int base, int howmany);

  private:
    std::map< std::pair< std::string, double>, wglFont* > fontCache;
    friend struct wglWindowClass;
    struct wglWindowClass& cls;
    HWND  hWnd;
    HDC   hdc, lasthdc;
    HGLRC hglrc, lastglrc;
    std::string error_message;

    int buttonState, buttonChanged;
    int Kshift, Kalt, Kctrl; //true if down when mouse event happens
    vector mousePos;
    vector mouseDelta;
    bool mouseLocked;
    std::vector< std::string> keys;

    int current;  // incremented by makeCurrent(), decremented by makeNotCurrent()

    LRESULT winMessage( HWND, UINT, WPARAM, LPARAM );
    void error( std::string where);

    friend struct wglFont;
    
    // This is a list of glDeleteLists calls that should be made the next time
    // the context is made active.
    mutex list_lock;
	std::vector<std::pair<int, int> > pending_glDeleteLists;
    
};

} // !namespace visual

#endif // !VISUAL_WGL_H
