#ifndef VISUAL_PRIM_H
#define VISUAL_PRIM_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "displaylist.h"
#include "color.h"
#include "tmatrix.h"
#include "vector.h"
#include <boost/scoped_ptr.hpp>

namespace visual {

class Primitive : public DisplayObject 
{
public:
	Primitive();
	Primitive( const Primitive& other);

	virtual void refreshCache();
	void py_rotate( double angle, vector axis, vector origin);

protected:
	// data:
	shared_vector pos;
	shared_vector axis;
	shared_vector up;
    
	virtual vector getScale();
    
public:    
	// New style getters
	inline shared_vector&
	get_pos()
	{ return pos; }
    
	inline double
	get_x() const
	{ return pos.get_x(); }
    
	inline double
	get_y() const
	{ return pos.get_y(); }
    
	inline double
	get_z() const
	{ return pos.get_z(); }
    
	inline shared_vector&
	get_axis()
	{ return axis; }
    
	inline shared_vector&
	get_up()
	{ return up; }
    
	rgb get_color();
    
	float
	get_blue() const
	{ return color.b; }
    
	float
	get_red() const
	{ return color.r; }
    
	float
	get_green() const
	{ return color.g; }
    
	// These are actually boolean style integers for python's benefit.
    
	// New style setters.  Since mutex locking is involved here, we don't inline these.
	void set_pos( const vector& v);
	void set_pos_t( const boost::python::object& t);
	void set_x( const double& s);
	void set_y( const double& s);
	void set_z( const double& s);
	void set_axis( const vector& v);
	void set_axis_t( const boost::python::object& t);
	void set_up( const vector& v);
	void set_up_t( const boost::python::object& t);
	void set_color( const rgb& t);
	void set_blue( const float& s);
	void set_red( const float& s);
	void set_green( const float& s);
    
protected:
	bool degenerate;
	tmatrix mwt;    // model to world
	tmatrix wlt;    // world to lighting
    
	vector scale;
};

// Provide the interface definition for the python type "primitive_traits"
//   This class is the least derived base class that is exposed to python.
void primitive_init_type();

} // !namespace visual

#endif // !VISUAL_PRIM_H
