# Code to complete the various primitive types
# Users should never import this module directly.  All of the public types and functions
#   will be explicitly imported by __init__.py

import cvisual
from cvisual import vector 
import crayola
color = crayola
from math import pi, sin, cos

# Don't try this at home!
import array_backend
arange = __import__(array_backend.backend[0]).arange


# The following generic algorithm will initialize any primitive in Visual.
# object is a reference to a Visual primitive object.
# keywords must be a dictionary of keyword:value pairs.
def process_init_args_from_keyword_dictionary( displayobject, keywords):
	""" The guts of a factory function that initializes the primitive 
	objects in Visual.  Client code should never call this function."""
	# Filter off these special properties, they must be set last and together
	if keywords.has_key('display'):
		display = keywords['display']
		del keywords['display']
	else:
		display = cvisual.display.get_selected()
	if keywords.has_key('visible'):
		visible = keywords['visible']
		del keywords['visible']
	else:
		visible = 1
	if keywords.has_key('frame'):
		frame = keywords['frame']
		del keywords['frame']
	else:
		frame = None

	# Add special handling for the faces object.
	if displayobject.__class__ == faces:
		if keywords.has_key('pos'):
			displayobject.pos = keywords['pos']
			del keywords['pos']

	# Some objects (like the curve and convex) need to have color set before
	# pos if color is a single tuple.
	if keywords.has_key('color'):
		displayobject.color =  keywords['color']
		del keywords['color']
	else:
		displayobject.color = display.foreground 

	# Assign all other properties
	for key, value in keywords.iteritems():
		displayobject.__setattr__(key, value)

	# Complete the initialization of the object.
	displayobject._complete_init( displayobject, displayobject, 
		visible, display, frame)

def copy_object( copy, other, keywords):
	display = None
	visible = None
	frame = None
	# Strip out the special values.)
	if keywords.has_key( 'display'):
		display = keywords['display']
		del keywords['display']
	else:
		display = other.display
	if keywords.has_key( 'visible'):
		visible = keywords['visible']
		del keywords['visible']
	else:
		visible = other.visible
	if keywords.has_key( 'frame'):
		frame = keywords['frame']
		del keywords['frame']
	else:
		frame = other.frame

	# Copy the user-specified dict.
	copy.__dict__ = dict(other.__dict__)
	# Set the differing properties.
	for key, value in keywords.iteritems():
		copy.__setattr__(key, value)
	# Complete initialization and make this object visible.
	copy._complete_init( copy, copy, visible, display, frame)


# Complete the arrow type.
class arrow (cvisual.arrow):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.arrow.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.arrow.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return arrow(_other=self, **keywords)
	# Set up properties for those that have overloaded setters.
	pos = property( cvisual.primitive._get_pos, cvisual.primitive._set_pos, None)
	axis = property( cvisual.primitive._get_axis, cvisual.primitive._set_axis, None)
	up = property( cvisual.primitive._get_up, cvisual.primitive._set_up, None)


class cone (cvisual.cone):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.cone.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.cone.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return cone(_other=self, **keywords)
	pos = property( cvisual.cone._get_pos, cvisual.cone._set_pos, None)
	axis = property( cvisual.cone._get_axis, cvisual.cone._set_axis, None)
	up = property( cvisual.cone._get_up, cvisual.cone._set_up, None)


class cylinder (cvisual.cylinder):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.cylinder.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.cylinder.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return cylinder(_other=self, **keywords)
	pos = property( cvisual.cylinder._get_pos, cvisual.cylinder._set_pos, None)
	axis = property( cvisual.cylinder._get_axis, cvisual.cylinder._set_axis, None)
	up = property( cvisual.cylinder._get_up, cvisual.cylinder._set_up, None)



class sphere (cvisual.sphere):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.sphere.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.sphere.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return sphere(_other=self, **keywords)
	pos = property( cvisual.sphere._get_pos, cvisual.sphere._set_pos, None)
	axis = property( cvisual.sphere._get_axis, cvisual.sphere._set_axis, None)
	up = property( cvisual.sphere._get_up, cvisual.sphere._set_up, None)


class ring (cvisual.ring):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.ring.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.ring.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return ring(_other=self, **keywords)
	pos = property( cvisual.ring._get_pos, cvisual.ring._set_pos, None)
	axis = property( cvisual.ring._get_axis, cvisual.ring._set_axis, None)
	up = property( cvisual.ring._get_up, cvisual.ring._set_up, None)



class box (cvisual.box):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.box.__init__(self, _other)
			# In the case where both axis and length are set, this ensures that
			# length is set after axis.
			if keywords.has_key('axis'):
				self.axis = keywords['axis']
				del keywords['axis']
			copy_object( self, _other, keywords)
		else:
			cvisual.box.__init__(self)
			if keywords.has_key('axis'):
				self.axis = keywords['axis']
				del keywords['axis']
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return box(_other=self, **keywords)
	pos = property( cvisual.box._get_pos, cvisual.box._set_pos, None)
	axis = property( cvisual.box._get_axis, cvisual.box._set_axis, None)
	up = property( cvisual.box._get_up, cvisual.box._set_up, None)

class ellipsoid (cvisual.ellipsoid):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.ellipsoid.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.ellipsoid.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return ellipsoid(_other=self, **keywords)
	pos = property( cvisual.ellipsoid._get_pos, cvisual.ellipsoid._set_pos, None)
	axis = property( cvisual.ellipsoid._get_axis, cvisual.ellipsoid._set_axis, None)
	up = property( cvisual.ellipsoid._get_up, cvisual.ellipsoid._set_up, None)

class pyramid (cvisual.pyramid):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.pyramid.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.pyramid.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return pyramid(_other=self, **keywords)
	pos = property( cvisual.pyramid._get_pos, cvisual.pyramid._set_pos, None)
	axis = property( cvisual.pyramid._get_axis, cvisual.pyramid._set_axis, None)
	up = property( cvisual.pyramid._get_up, cvisual.pyramid._set_up, None)


class label (cvisual.label):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.label.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.label.__init__(self)
			if keywords.has_key('linecolor'):
				self.linecolor = keywords['linecolor']
				del keywords['linecolor']
			else:
				if keywords.has_key('display'):
					self.linecolor = keywords['display'].foreground
				else:
					self.linecolor = cvisual.display.get_selected().foreground
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return label(_other=self, **keywords)
	pos = property( cvisual.label._get_pos, cvisual.label._set_pos, None)

class frame (cvisual.frame):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.frame.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.frame.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return frame(_other=self, **keywords)
	pos = property( cvisual.frame._get_pos, cvisual.frame._set_pos, None)
	axis = property( cvisual.frame._get_axis, cvisual.frame._set_axis, None)
	up = property( cvisual.frame._get_up, cvisual.frame._set_up, None)

class curve( cvisual.curve):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.curve.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.curve.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return curve(_other=self, **keywords)
	def _get_red( self):
		return self.color[:,0]
	def _get_green(self):
		return self.color[:,1]
	def _get_blue(self):
		return self.color[:,2]
	def _get_x(self):
		return self.pos[:,0]
	def _get_y(self):
		return self.pos[:,1]
	def _get_z(self):
		return self.pos[:,2]
	
	pos = property( cvisual.curve._get_pos, cvisual.curve._set_pos, None)
	color = property( cvisual.curve._get_color, cvisual.curve._set_color, None)
	x = property( _get_x, cvisual.curve._set_x, None)
	y = property( _get_y, cvisual.curve._set_y, None)
	z = property( _get_z, cvisual.curve._set_z, None)
	red = property( _get_red, cvisual.curve._set_red, None)
	green = property( _get_green, cvisual.curve._set_green, None)
	blue = property( _get_blue, cvisual.curve._set_blue, None)

class convex( cvisual.convex):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.convex.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.convex.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return convex(_other=self, **keywords)
	pos = property( cvisual.convex._get_pos, cvisual.convex._set_pos, None)


class faces( cvisual.faces):
	def __init__( self, _other=None, **keywords):
		if _other:
			cvisual.faces.__init__(self, _other)
			copy_object( self, _other, keywords)
		else:
			cvisual.faces.__init__(self)
			process_init_args_from_keyword_dictionary(self, keywords)
	def __copy__( self, **keywords):
		return faces(_other=self, **keywords)
	pos = property( cvisual.faces._get_pos, cvisual.faces._set_pos, None)
	normal = property( cvisual.faces._get_normal, cvisual.faces._set_normal, None)
	color = property( cvisual.faces._get_color, cvisual.faces._set_color, None)


class helix(object):
	def __init__( self, _other=None, pos=vector(), axis=vector(1,0,0), radius=0.2, 
			coils=5, thickness=None, color=color.white):
		axis = vector(axis)
		self.frame = frame(pos=pos, axis=axis.norm())
		self.cached_length = axis.mag
		if thickness is None:
			thickness = radius/20.
		k = coils*(2*pi/self.cached_length)
		dx = (self.cached_length/coils)/12.
		self.helix = curve( frame = self.frame, radius = thickness/2.,
			color = color)
		for x in arange( 0, self.length+dx, dx):
			self.helix.append( pos=vector( x, radius*sin(k*x), 
				radius*cos(k*x)))

	def _set_pos(self, pos):
		self.frame.pos = vector(pos)

	def _get_pos(self):
		return self.frame.pos

	def _set_axis(self, axis):
		self.frame.axis = vector(axis)
		self._set_length(self.frame.axis.mag)

	def _get_axis(self):
		return self.frame.axis

	def _set_length(self, length):
		self.helix.pos[:,0] *= ( length/self.cached_length)
		self.cached_length = length

	def _get_length(self):
		return self.cached_length

	def _get_up(self):
		return self.frame.up

	def _set_up(self, up):
		self.frame.up = up

	pos = property( _get_pos, _set_pos, None)
	axis = property( _get_axis, _set_axis, None)
	length = property( _get_length, _set_length, None)
	up = property( _get_up, _set_up, None)
