#!/usr/bin/env python
""" bank02: More Customers """
from SimPy.Simulation  import *

class Customer(Process):
    """ Customer arrives, looks around and leaves """
        
    def visit(self,timeInBank=0):       
        print "%7.4f %s: Here I am"%(now(),self.name)
        yield hold,self,timeInBank
        print "%7.4f %s: I must leave"%(now(),self.name)

def model():      
    initialize()
    c1=Customer(name="Klaus")                         
    activate(c1,c1.visit(timeInBank=10.0),delay=5.0)
    c2=Customer(name="Tony")
    activate(c2,c2.visit(timeInBank=8.0),delay=2.0)
    c3=Customer(name="Evelyn")
    activate(c3,c3.visit(timeInBank=20.0),delay=12.0) 
    simulate(until=400.0)

model()
