# Copyright (c) 2002 Detlev Offenbach <detlev@die-offenbachs.de>

from qt import *

class MyWidget(QMainWindow):

    def __init__(self, parent=None, name=None):
        QMainWindow.__init__(self, parent, name)
        
        self.central = QVBox(self)
        self.central.setMargin(5)
        self.central.setSpacing(5)
        self.setCentralWidget(self.central)
        
        self.setCaption(self.trUtf8("""Internationalization Example"""))
        
        self.file = QPopupMenu(self)
        self.file.insertItem(self.trUtf8("E&xit"), qApp, SLOT("quit()"),
                QKeySequence(self.trUtf8("Ctrl+Q","File|Quit")))
        self.menuBar().insertItem(self.trUtf8("&File"), self.file)
        
        self.statusBar().message(self.trUtf8('''Language: English'''))
        
        self.label = QLabel(self.trUtf8("The Main Window"), self.central)
        
        self.gbox = QButtonGroup(1, QGroupBox.Horizontal,
                self.trUtf8("View"), self.central)
        rb = QRadioButton(qApp.translate('MyWidget','Perspective'), self.gbox)
        rb = QRadioButton(qApp.translate('MyWidget','Isometric'), self.gbox)
        rb = QRadioButton(qApp.translate('MyWidget','Oblique'), self.gbox)
        
        self.initChoices(self.central)
        
    choices = [
        QT_TRANSLATE_NOOP("MyWidget", "First"),
        QT_TRANSLATE_NOOP("MyWidget", "Second"),
        QT_TRANSLATE_NOOP("MyWidget", "Third")
        ]
        
    def initChoices(self, parent):
        self.lb = QListBox(parent)
        for ch in self.choices:
            self.lb.insertItem(self.trUtf8(ch))
            
    def closeEvent(self, e):
        QWidget.closeEvent(self, e)
        self.emit(PYSIGNAL('closed'), ())
