#define WITHIN32(v, f) (((v) >= f##_MIN32) && ((v) <= f##_MAX32))
#define WITHIN64(v, f) (((v) >= f##_MIN64) && ((v) <= f##_MAX64))

Bool NA_IeeeSpecial32( Float32 *f, Int32 *mask)
{
	Int32 category;
	UInt32 *f1 = (UInt32 *) f;
	UInt32 v = *f1;

	if (v & BIT(31)) {
		if (WITHIN32(v, NEG_NORMALIZED)) {
			category = MSK_NEG_NOR;
		} else if (WITHIN32(v, NEG_DENORMALIZED)) {
			category = MSK_NEG_DEN;
		} else if (WITHIN32(v, NEG_SIGNAL_NAN)) {
			category = MSK_NEG_SNAN;
		} else if (WITHIN32(v, NEG_QUIET_NAN)) {
			category = MSK_NEG_QNAN;
		} else if (v == NEG_INFINITY_MIN32) {
			category = MSK_NEG_INF;
		} else if (v == NEG_ZERO_MIN32) {
			category = MSK_NEG_ZERO;
		} else if (v == INDETERMINATE_MIN32) {
			category = MSK_INDETERM;
		} else {
			category = MSK_BUG;
		}
	} else {
		if (WITHIN32(v, POS_NORMALIZED)) {
			category = MSK_POS_NOR;
		} else if (WITHIN32(v, POS_DENORMALIZED)) {
			category = MSK_POS_DEN;
		} else if (WITHIN32(v, POS_SIGNAL_NAN)) {
			category = MSK_POS_SNAN;
		} else if (WITHIN32(v, POS_QUIET_NAN)) {
			category = MSK_POS_QNAN;
		} else if (v == POS_INFINITY_MIN32) {
			category = MSK_POS_INF;
		} else if (v == POS_ZERO_MIN32) {
			category = MSK_POS_ZERO;
		} else {
			category = MSK_BUG;
		}
	}	
	return (category & *mask) != 0;	
}

Bool NA_IeeeSpecial64( Float64 *f, Int32 *mask)
{
	Int32 category;
	UInt64 *f1 = (UInt64 *) f;
	UInt64 v = *f1;

	if (v & BIT(63)) {
		if (WITHIN64(v, NEG_NORMALIZED)) {
			category = MSK_NEG_NOR;
		} else if (WITHIN64(v, NEG_DENORMALIZED)) {
			category = MSK_NEG_DEN;
		} else if (WITHIN64(v, NEG_SIGNAL_NAN)) {
			category = MSK_NEG_SNAN;
		} else if (WITHIN64(v, NEG_QUIET_NAN)) {
			category = MSK_NEG_QNAN;
		} else if (v == NEG_INFINITY_MIN64) {
			category = MSK_NEG_INF;
		} else if (v == NEG_ZERO_MIN64) {
			category = MSK_NEG_ZERO;
		} else if (v == INDETERMINATE_MIN64) {
			category = MSK_INDETERM;
		} else {
			category = MSK_BUG;
		}
	} else {
		if (WITHIN64(v, POS_NORMALIZED)) {
			category = MSK_POS_NOR;
		} else if (WITHIN64(v, POS_DENORMALIZED)) {
			category = MSK_POS_DEN;
		} else if (WITHIN64(v, POS_SIGNAL_NAN)) {
			category = MSK_POS_SNAN;
		} else if (WITHIN64(v, POS_QUIET_NAN)) {
			category = MSK_POS_QNAN;
		} else if (v == POS_INFINITY_MIN64) {
			category = MSK_POS_INF;
		} else if (v == POS_ZERO_MIN64) {
			category = MSK_POS_ZERO;
		} else {
			category = MSK_BUG;
		}
	}	
	return (category & *mask) != 0;	
}

