/* KInterbasDB Python Package - Implementation of Event Waiting - Windows
**
** Version 3.1
**
** The following contributors hold Copyright (C) over their respective
** portions of code (see license.txt for details):
**
** [Original Author (maintained through version 2.0-0.3.1):]
**   1998-2001 [alex]  Alexander Kuznetsov   <alexan@users.sourceforge.net>
** [Maintainers (after version 2.0-0.3.1):]
**   2001-2002 [maz]   Marek Isalski         <kinterbasdb@maz.nu>
**   2002-2004 [dsr]   David Rushby          <woodsplitter@rocketmail.com>
** [Contributors:]
**   2001      [eac]   Evgeny A. Cherkashin  <eugeneai@icc.ru>
**   2001-2002 [janez] Janez Jere            <janez.jere@void.si>
*/

/* This source file is designed to be directly included in _kievents.c,
** without the involvement of a header file. */

/************************* PUBLIC FUNCTIONS:BEGIN ****************************/

PlatformEventType platform_create_event_object() {
  HANDLE event_handle = CreateEvent(
      NULL, /* no security attributes */

      /* Use *manual* signal reset (rather than automatic, which would reset
      ** the signal when the first waiting thread awakened). */
      TRUE,

      FALSE, /* initial state non-signaled */
      NULL /* name (for access from other processes) */
    );

  return event_handle;
} /* platform_create_event_object */


void platform_free_event_object(PlatformEventType event) {
  if (event == NULL) {
    return;
  }
  CloseHandle(event);
} /* platform_free_event_object */


int event_queue_wait(EventQueue *queue, long timeout_millis) {
  DWORD native_timeout =
    (  timeout_millis == (long) WAIT_INFINITELY
       ? INFINITE : (DWORD) timeout_millis
    );

  DWORD wait_result = WaitForSingleObject(queue->event, native_timeout);

  if (wait_result == WAIT_FAILED) {
    return EVENT_ERROR;
  } else if (wait_result == WAIT_TIMEOUT) {
    return EVENT_TIMEOUT;
  } else {
    return EVENT_OK;
  }
} /* event_queue_wait */


int event_queue_signal(EventQueue *queue) {
  /* SetEvent returns zero on failure. */
  return (SetEvent(queue->event) == 0) ? EVENT_ERROR : EVENT_OK;
} /* event_queue_signal */


int event_queue_unsignal(EventQueue *queue) {
  /* ResetEvent returns zero on failure. */
  return (ResetEvent(queue->event) == 0) ? EVENT_ERROR : EVENT_OK;
} /* event_queue_unsignal */

/************************* PUBLIC FUNCTIONS:END ****************************/
