# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BlobContainer(Model):
    """Azure Storage blob container information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: the name of the blob container.
    :vartype name: str
    :ivar id: the unique identifier of the blob container.
    :vartype id: str
    :ivar type: the type of the blob container.
    :vartype type: str
    :ivar properties: the properties of the blob container.
    :vartype properties: :class:`BlobContainerProperties
     <azure.mgmt.datalake.analytics.account.models.BlobContainerProperties>`
    """ 

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BlobContainerProperties'},
    }

    def __init__(self):
        self.name = None
        self.id = None
        self.type = None
        self.properties = None
