# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.workflows_operations import WorkflowsOperations
from .operations.workflow_versions_operations import WorkflowVersionsOperations
from .operations.workflow_triggers_operations import WorkflowTriggersOperations
from .operations.workflow_trigger_histories_operations import WorkflowTriggerHistoriesOperations
from .operations.workflow_runs_operations import WorkflowRunsOperations
from .operations.workflow_run_actions_operations import WorkflowRunActionsOperations
from .operations.integration_accounts_operations import IntegrationAccountsOperations
from .operations.integration_account_schemas_operations import IntegrationAccountSchemasOperations
from .operations.integration_account_maps_operations import IntegrationAccountMapsOperations
from .operations.integration_account_partners_operations import IntegrationAccountPartnersOperations
from .operations.integration_account_agreements_operations import IntegrationAccountAgreementsOperations
from .operations.integration_account_certificates_operations import IntegrationAccountCertificatesOperations
from . import models


class LogicManagementClientConfiguration(AzureConfiguration):
    """Configuration for LogicManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription id.
    :type subscription_id: str
    :param accept_language: Gets or sets the preferred language for the
     response.
    :type accept_language: str
    :param long_running_operation_retry_timeout: Gets or sets the retry
     timeout in seconds for Long Running Operations. Default value is 30.
    :type long_running_operation_retry_timeout: int
    :param generate_client_request_id: When set to true a unique
     x-ms-client-request-id value is generated and included in each request.
     Default is true.
    :type generate_client_request_id: bool
    :param str base_url: Service URL
    :param str filepath: Existing config
    """

    def __init__(
            self, credentials, subscription_id, accept_language='en-US', long_running_operation_retry_timeout=30, generate_client_request_id=True, base_url=None, filepath=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not isinstance(subscription_id, str):
            raise TypeError("Parameter 'subscription_id' must be str.")
        if accept_language is not None and not isinstance(accept_language, str):
            raise TypeError("Optional parameter 'accept_language' must be str.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(LogicManagementClientConfiguration, self).__init__(base_url, filepath)

        self.add_user_agent('logicmanagementclient/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id
        self.accept_language = accept_language
        self.long_running_operation_retry_timeout = long_running_operation_retry_timeout
        self.generate_client_request_id = generate_client_request_id


class LogicManagementClient(object):
    """Composite Swagger for Logic Management Client

    :ivar config: Configuration for client.
    :vartype config: LogicManagementClientConfiguration

    :ivar workflows: Workflows operations
    :vartype workflows: .operations.WorkflowsOperations
    :ivar workflow_versions: WorkflowVersions operations
    :vartype workflow_versions: .operations.WorkflowVersionsOperations
    :ivar workflow_triggers: WorkflowTriggers operations
    :vartype workflow_triggers: .operations.WorkflowTriggersOperations
    :ivar workflow_trigger_histories: WorkflowTriggerHistories operations
    :vartype workflow_trigger_histories: .operations.WorkflowTriggerHistoriesOperations
    :ivar workflow_runs: WorkflowRuns operations
    :vartype workflow_runs: .operations.WorkflowRunsOperations
    :ivar workflow_run_actions: WorkflowRunActions operations
    :vartype workflow_run_actions: .operations.WorkflowRunActionsOperations
    :ivar integration_accounts: IntegrationAccounts operations
    :vartype integration_accounts: .operations.IntegrationAccountsOperations
    :ivar integration_account_schemas: IntegrationAccountSchemas operations
    :vartype integration_account_schemas: .operations.IntegrationAccountSchemasOperations
    :ivar integration_account_maps: IntegrationAccountMaps operations
    :vartype integration_account_maps: .operations.IntegrationAccountMapsOperations
    :ivar integration_account_partners: IntegrationAccountPartners operations
    :vartype integration_account_partners: .operations.IntegrationAccountPartnersOperations
    :ivar integration_account_agreements: IntegrationAccountAgreements operations
    :vartype integration_account_agreements: .operations.IntegrationAccountAgreementsOperations
    :ivar integration_account_certificates: IntegrationAccountCertificates operations
    :vartype integration_account_certificates: .operations.IntegrationAccountCertificatesOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription id.
    :type subscription_id: str
    :param accept_language: Gets or sets the preferred language for the
     response.
    :type accept_language: str
    :param long_running_operation_retry_timeout: Gets or sets the retry
     timeout in seconds for Long Running Operations. Default value is 30.
    :type long_running_operation_retry_timeout: int
    :param generate_client_request_id: When set to true a unique
     x-ms-client-request-id value is generated and included in each request.
     Default is true.
    :type generate_client_request_id: bool
    :param str base_url: Service URL
    :param str filepath: Existing config
    """

    def __init__(
            self, credentials, subscription_id, accept_language='en-US', long_running_operation_retry_timeout=30, generate_client_request_id=True, base_url=None, filepath=None):

        self.config = LogicManagementClientConfiguration(credentials, subscription_id, accept_language, long_running_operation_retry_timeout, generate_client_request_id, base_url, filepath)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.workflows = WorkflowsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_versions = WorkflowVersionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_triggers = WorkflowTriggersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_trigger_histories = WorkflowTriggerHistoriesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_runs = WorkflowRunsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_actions = WorkflowRunActionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_accounts = IntegrationAccountsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_schemas = IntegrationAccountSchemasOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_maps = IntegrationAccountMapsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_partners = IntegrationAccountPartnersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_agreements = IntegrationAccountAgreementsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_certificates = IntegrationAccountCertificatesOperations(
            self._client, self.config, self._serialize, self._deserialize)
