from Ft.Xml.Lib import TreeCompare

#From the spec

src_1 = """\
<?xml version="1.0"?>
<addresses version="1.0">

  <address id="1">
    <fullname>Andreas Laux</fullname>
    <born day='1' month='12' year='1978'/>
    <town>Leipzig</town>
    <country>Germany</country>
  </address>

</addresses>
"""

xu_1 = """\
<?xml version="1.0"?>
<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
>

  <xupdate:insert-after select="/addresses/address[1]" >

    <xupdate:element name="address">
      <xupdate:attribute name="id">2</xupdate:attribute>
      <fullname>Lars Martin</fullname>
      <born day='2' month='12' year='1974'/>
      <town>Leizig</town>
      <country>Germany</country>
    </xupdate:element>
  </xupdate:insert-after>

</xupdate:modifications>
"""

expected_1 = """<?xml version='1.0' encoding='UTF-8'?><addresses version='1.0'>\n\n  <address id='1'>\n    <fullname>Andreas Laux</fullname>\n    <born day='1' year='1978' month='12'/>\n    <town>Leipzig</town>\n    <country>Germany</country>\n  </address><address id='2'><fullname>Lars Martin</fullname><born day='2' year='1974' month='12'/><town>Leizig</town><country>Germany</country></address>\n\n</addresses>"""

#etc

import test_helper

def test_update(tester):

    tester.startTest("XUpdate")

    repo = test_helper.GetRepo(tester)

    doc = repo.fetchResource("/test/doc1")

    doc.xUpdate(xu_1)

    tester.compare(expected_1, doc.getContent(), diff=1,
                   func=TreeCompare.TreeCompare)

    repo.txRollback()

    tester.testDone()
    return

def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    test = repo.createContainer("/test",1)
    test.createDocument('doc1',src_1)
    repo.txCommit()
    tester.testDone()


def Test(tester):

    cleanup(tester)
    test_update(tester)



