########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Fetch/__init__.py,v 1.5 2004/08/20 21:11:01 mbrown Exp $
"""
Implementation of '4ss fetch' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command retrieves the content of a resource from a \
4Suite repository. It requires a subcommand specifying which type of \
resource to fetch. See the help message for one of the subcommands for \
specific usage info."""

# command modules to register as subcommands
import Container
import DocDef
import Document
import Group
import RawFile
import Resource
import User
import UserData


g_subCommands = [Container,
                 Group,
                 DocDef,
                 Document,
                 RawFile,
                 Resource,
                 User,
                 UserData,
                 ]

def Register():
    from Ft.Lib.CommandLine import Options, Command
    sc = map(lambda x: x.Register(), g_subCommands)
    cmd = Command.Command('fetch',
                          "Retrieve a resource from the repository",
                          None,
                          __doc__,
                          subCommands = sc,
                          fileName = __file__,
                          )
    return cmd

