#!/usr/bin/python
########################################################################
#
# File Name:            FILE
#
# Documentation:        http://docs.4suite.org/4ODS/Parsers/GenerateClass.py.html
#

#Desc.
#WWW: http://4suite.org/4ODS        e-mail: support@4suite.org

#Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
#See  http://4suite.org/COPYRIGHT  for license and copyright information

import string, os, cStringIO

from Ft.Ods.Parsers.Odl import GenerateType
from Ft.Ods.Parsers.Odl import Templates, OdlUtil

from Ft.Ods.MetaData import MetaKind
from Ft.Ods.MetaData import PrimitiveKind

from Ft.Ods.Exception import FtodsUnsupportedError

def GenerateStubs(interface, params,fileName):


    # Write our file
    outFile = open(fileName,'w')
    params.outFile = outFile
    OdlUtil.WriteFileHeader(outFile,interface.name)


    # Print the imports

    outFile.write("from Ft.Ods import Constants\n")


    bases = Templates.GetBases(interface.name, interface.inherits, params)
    if interface.meta_kind == MetaKind.mk_class and interface.extender:
        bases.extend(Templates.GetBases(interface.name, [interface.extender], params))

    if not bases:
        bases.append('Object.Object')
        outFile.write('from Ft.Ods import Object\n')

    outFile.write('from Ft.Ods import Database\n\n')

    for define in interface.defines:
        if define.meta_kind == MetaKind.mk_attribute:
            dType = OdlUtil.NormalizeTypeDefinition(define.type)
            if dType.meta_kind == MetaKind.mk_enumeration:
                GenerateType.WriteImports(dType, params)
        
    if interface.meta_kind == MetaKind.mk_class:
        Templates.GlobalFactory(outFile.write, interface.name)

    # Write the class definition and the constructor
    Templates.ClassHeader(outFile.write, interface.name, bases,interface.meta_kind == MetaKind.mk_interface)

    # FIXME: no support for property_lists

    # Write the init for attributes
    attrs = filter(lambda define:
                   define.meta_kind == MetaKind.mk_attribute,
                   interface.defines)
    Templates.AttributeInit(attrs, params)

    # Write the init for structures
    structs = filter(lambda define:
                     define.meta_kind == MetaKind.mk_structure,
                     interface.defines)
    for struct in structs:
        raise FtodsUnsupportedError('Inline structures')

    # Write the functions for relationships
    relationships = filter(lambda define:
                           define.meta_kind == MetaKind.mk_relationship,
                           interface.defines)
    for relationship in relationships:
        Templates.RelationshipInit(relationship, params)

    operations = filter(lambda define:
                        define.meta_kind == MetaKind.mk_operation,
                        interface.defines)

    for operation in operations:
        Templates.OperationInit(operation, params)

    
    # Write the tuple info
    Templates.TupleDefinitions(interface.defines, bases, params)

    # Write the extents tuple
    if interface.meta_kind == MetaKind.mk_class:
        Templates.InheritedTuples(outFile.write, '_extents', interface.extents, bases)

    outFile.write('    _typeId = %d\n' % interface._4ods_getId())

    # Write the typeIds tuple
    Templates.InheritedTuples(outFile.write, '_typeIds', (interface._4ods_getId(),), bases)

    outFile.write('\n')
    outFile.close()

