
from Ft.Lib.CommandLine import CommandLineTestUtil
import test_prime
from Ft.Server.Client import Core

from Server.Client.Core import test_helper

FIRST_CONTAINER = '/' + test_prime.BASE_CONTAINER + '/con1'

expected_1 = "Deleting: %s\n" % FIRST_CONTAINER

def val1(tester):
    repo = test_helper.GetRepo(tester)
    try:
        return not repo.hasResource(FIRST_CONTAINER)
    finally:
        repo.txRollback()

def Init(repo):
    if repo.hasResource(FIRST_CONTAINER):
        repo.deleteResource(FIRST_CONTAINER)
    repo.createContainer(FIRST_CONTAINER)

def Test(tester):

    test_prime.InitRepo(tester,Init,['4ss','delete'])

    baseConfig = {'host':tester.test_data['ftrpc-host'],
                  'port':tester.test_data['ftrpc-port'],
                  'username':tester.test_data['userName'],
                  'password':tester.test_data['password'],
                  }

    #No options, just get the system user container
    tr = CommandLineTestUtil.TestRun('Basic Delete',
                                     baseConfig,
                                     [FIRST_CONTAINER],
                                     validationFunc=val1,
                                     expectedOut=expected_1)

    #Delete an unknown container
    tr2 = CommandLineTestUtil.TestRun('Error Delete',
                                      baseConfig,
                                      [FIRST_CONTAINER])

    t = CommandLineTestUtil.Test('4ss delete',[tr,tr2])

    return t.test(tester)

