<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    User's play processing

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:import href='draw-screen.xsl'/>

  <xsl:template match="/cribbage">
    <xsl:call-template name='draw-screen'>
      <xsl:with-param name='form-action' select='"../move-human.xsl"'/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name='playing-area'>
    <xsl:param name='cur-dealer'/>
    <!-- Play info -->
    <TABLE BORDER='1'>
      <TR>
        <xsl:for-each select='key("players",1)/played-cards/Card'>
          <TD><IMG src='{@img}'/></TD>
        </xsl:for-each>
        <xsl:if test='count(key("players",1)/played-cards/Card) &lt; 1'>
          <TD><IMG src='/images/cards/X.png'/></TD>
        </xsl:if>
        <xsl:if test='count(key("players",1)/played-cards/Card) &lt; 2'>
          <TD><IMG src='/images/cards/X.png'/></TD>
        </xsl:if>
        <xsl:if test='count(key("players",1)/played-cards/Card) &lt; 3'>
          <TD><IMG src='/images/cards/X.png'/></TD>
        </xsl:if>
        <xsl:if test='count(key("players",1)/played-cards/Card) &lt; 4'>
          <TD><IMG src='/images/cards/X.png'/></TD>
        </xsl:if>
      </TR>
      <TR>
        <xsl:for-each select='key("players",2)/played-cards/Card'>
          <TD><IMG src='{@img}'/></TD>
        </xsl:for-each>
        <xsl:if test='count(key("players",2)/played-cards/Card) &lt; 1'>
          <TD><IMG src='/images/cards/X.png'/></TD>
        </xsl:if>
        <xsl:if test='count(key("players",2)/played-cards/Card) &lt; 2'>
          <TD><IMG src='/images/cards/X.png'/></TD>
        </xsl:if>
        <xsl:if test='count(key("players",2)/played-cards/Card) &lt; 3'>
          <TD><IMG src='/images/cards/X.png'/></TD>
        </xsl:if>
        <xsl:if test='count(key("players",2)/played-cards/Card) &lt; 4'>
          <TD><IMG src='/images/cards/X.png'/></TD>
        </xsl:if>
      </TR>
    </TABLE>
  </xsl:template>

  <xsl:template match='Card' mode='player-hand'>
    <TD>
      <INPUT TYPE='IMAGE' NAME='play{position()}' VALUE='{@short-name}' src="{@img}"/>
    </TD>
  </xsl:template>

  <xsl:template match='Card' mode='cut-card'>
    <TR>
      <TD ALIGN='CENTER' COLSPAN='2'>
        <IMG src='{@img}'/>
      </TD>
    </TR>
  </xsl:template>

  <xsl:template name='cur-count'>
    <TR>
      <TD ALIGN='CENTER' COLSPAN='2'>
        Current Count: <xsl:value-of select='sum(/cribbage/game-info/cur-count/score)'/>
      </TD>
    </TR>
  </xsl:template>

  <xsl:template name='player-hand-other'>
    <INPUT TYPE='SUBMIT' NAME='GO' VALUE='GO'/>
    <!--<INPUT TYPE='CHECKBOX' NAME='NOSUB' VALUE='1'/>No Submit-->
  </xsl:template>

</xsl:stylesheet>
