<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    Start a new hand

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:import href='error.xslt'/>
  <xsl:import href='count-util.xslt'/>
  <xsl:import href='new-game.xslt'/>

  <xsl:output method='html'/>

  <xsl:param name='fres:uri-path'/>

  <xsl:param name='p1' select='/cribbage/player-info/player[@ID="1"]'/>
  <xsl:param name='p2' select='/cribbage/player-info/player[@ID="2"]'/>

  <xsl:template match='/'>

    <!--
      reset the state of the game for a new hand and redirect to the discard page
        1.  Reset current count
        2.  Reset go information
        3.  Reset players played cards
        4.  Reset the games played cards
        4.5 Reset the crib
        5.  swap the dealer
        6.  set the current player
        7.  remove all cards
        8.  redeal the cards
        8.5 pick a new cut card
        9.  move the logs
    -->

    <xsl:variable name='deck'>
      <xsl:call-template name='shuffle-cards'>
        <xsl:with-param name='num-decks' select='1'/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name='dealt'>
      <xsl:apply-templates select='exslt:node-set($deck)/Card[1]' mode='deal'/>
    </xsl:variable>

    <fcore:x-update>
      <xupdate:modifications version="1.0" xmlns:xupdate="http://www.xmldb.org/xupdate">
        <xupdate:update select='/cribbage/game-info/cur-count'>0</xupdate:update>

        <xupdate:update select='/cribbage/player-info/player[@ID=1]/in-go'>0</xupdate:update>
        <xupdate:update select='/cribbage/player-info/player[@ID=2]/in-go'>0</xupdate:update>

        <xupdate:remove select='/cribbage/player-info/player[@ID = 1]/played-cards'/>
        <xupdate:append select='/cribbage/player-info/player[@ID = 1]'><played-cards/></xupdate:append>

        <xupdate:remove select='/cribbage/player-info/player[@ID = 2]/played-cards'/>
        <xupdate:append select='/cribbage/player-info/player[@ID = 2]'><played-cards/></xupdate:append>

        <xupdate:remove select='/cribbage/game-info/cur-played'/>
        <xupdate:append select='/cribbage/game-info'><cur-played/></xupdate:append>

        <xupdate:remove select='/cribbage/game-info/all-played'/>
        <xupdate:append select='/cribbage/game-info'><all-played/></xupdate:append>

        <xupdate:remove select='/cribbage/crib-info'/>
        <xupdate:append select='/cribbage'><crib-info/></xupdate:append>

        <xupdate:update select='/cribbage/game-info/cur-dealer/@IDREF'><xsl:value-of select='number(/cribbage/game-info/cur-dealer/@IDREF = 1) + 1'/></xupdate:update>
        <xupdate:update select='/cribbage/game-info/cur-player/@IDREF'><xsl:value-of select='number(/cribbage/game-info/cur-dealer/@IDREF)'/></xupdate:update>


        <!-- Redeal the deck, not update removes current children -->
        <xupdate:update select='/cribbage/player-info/player[@ID=1]/cards'>
          <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="P1"]'/>
        </xupdate:update>

        <xupdate:update select='/cribbage/player-info/player[@ID=1]/playing-cards'>
          <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="P1"]'/>
        </xupdate:update>

        <xupdate:update select='/cribbage/player-info/player[@ID=2]/cards'>
          <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="P2"]'/>
        </xupdate:update>

        <xupdate:update select='/cribbage/player-info/player[@ID=2]/playing-cards'>
          <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="P2"]'/>
        </xupdate:update>

        <!--Just use 15 cause its easier, still random -->
        <xupdate:update select='/cribbage/game-info/cut-card'>
          <xsl:copy-of select='exslt:node-set($deck)/Card[15]'/>
        </xupdate:update>

      </xupdate:modifications>
    </fcore:x-update>


    <!--Redirect to the proper place -->
    <fhttp:response-uri uri="{$fres:uri-path}?xslt=../later-draw.xsl"/>

  </xsl:template>


</xsl:stylesheet>
