########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Lib/DbUtil.py,v 1.4 2005/03/03 11:18:24 mbrown Exp $
"""
Utilities for database connections

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__all__ = ['EscapeQuotes']

try:
    from EscapeQuotesc import escape as EscapeQuotes
except ImportError:
    def EscapeQuotes(qstr):
        """
        Postgres uses single quotes for string marker, so put a
        backslash before single quotes for insertion into a database.
        Also escape backslashes.
        pre: qstr = string to be escaped
        post: return the string with all single quotes escaped
        """
        if qstr is None:
            return ''
        tmp = qstr.replace("\\","\\\\")
        tmp = tmp.replace("'", "\\'")
        return tmp
