from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model
def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model(db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('Inference Rule')
    
    test.startTest('Syntax')
    if 1:
    #try:
        from Ft.Rdf.Inference import InferenceEngine
        from Ft.Rdf.Parsers.Ril import RilParserImp
    #except:
    #    test.error('Error in syntax', 1)
    test.testDone()


    exp = """<?xml version = "1.0"?>
<ril:expression xmlns:ril = "http://namespaces.rdfinference.org/ril" xmlns:ft = "http://namespaces.fourthought.com/test">
  <ril:assert>
    <ft:running>
        <ril:string-list>
          <ril:string>Mike</ril:string>
          <ril:string>Uche</ril:string>
        </ril:string-list>
    </ft:running>
    <ft:out-of-shape>
        <ril:string>Mike</ril:string>
    </ft:out-of-shape>
    <ft:wet>
        <ril:string-list>
          <ril:string>Jeremy</ril:string>
          <ril:string>Glenn</ril:string>
        </ril:string-list>
    </ft:wet>
    <ft:swimming>
        <ril:string>Glenn</ril:string>
    </ft:swimming>
  </ril:assert>

<!-- if RUNING(X) and OUT-OF-SHAPE(X) or WET(X) and not SWIMMING(X) then SWEATING(X) -->
  <ril:rule>
    <ril:premise>
      <ft:running>
        <ril:variable name='X'/>
      </ft:running>
      <ril:and>
        <ft:out-of-shape>
          <ril:variable name='X'/>
        </ft:out-of-shape>
      </ril:and>
      <ril:or>
        <ft:wet>
          <ril:variable name='X'/>
        </ft:wet>
      </ril:or>
      <ril:not>
        <ft:swimming>
          <ril:variable name='X'/>
        </ft:swimming>
      </ril:not>
    </ril:premise>
    <ril:conclusion>
      <ril:assert>
        <ft:sweating>
          <ril:variable name='X'/>
        </ft:sweating>
      </ril:assert>
    </ril:conclusion>
  </ril:rule>
  <ril:fire/>
  <ril:query>
    <ft:sweating>
      <ril:variable name='X'/>
    </ft:sweating>
  </ril:query>
</ril:expression>"""
    


    #Test the big ass rule
    test.startTest('Parsed Rule')

    p = RilParserImp.RilParserImp()
    defs = p.parse(exp)

    infeng = CreateInfEng()

    results = infeng.execute(defs)

    test.testResults([[('Jeremy', 'http://namespaces.fourthought.com/test#sweating', '1'), ('Mike', 'http://namespaces.fourthought.com/test#sweating', '1')]],results)

    test.testDone()
    test.groupDone()


if __name__ == '__main__':
    import sys
    from Ft.Lib import TestSuite

    testmgr = TestSuite.TestSuite()
    ret_val = Test(testmgr)
    sys.exit(ret_val)

