  /*  prefs-menus.c - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "powershell.h"

GtkWidget * hbox3, * hbox4;
GtkWidget * vbox6, * vbox7, * vbox10;

GtkWidget * label6, * label7, * label8;
GtkWidget * button1, * updatebutton, * button2;

GtkWidget * menu_tab_title, * menu_command, * menu_menu_label;
GtkWidget * run_on_startup;

GtkWidget * commands_list;

GtkWidget * buttonsbox, * scrollbox;

GtkWidget * cur_treeitem;

gint num_rows;

extern GtkWidget * statusbar;
extern GnomeUIInfo menubar[5];
extern GnomeUIInfo * file_menu2;
gchar * list_titles[] = {
  "Tab title", "Menu title", "Command", "Run on Startup"
};

int net_change;
int something_changed;

int row_selected = -1;

GtkWidget * menu_tab_title, * menu_command, * menu_menu_label;
GtkWidget * commands_list, * updatebutton, * buttonsbox;
GtkWidget * run_on_startup;

static void update_menu_item (GtkWidget * w, gpointer user_data)
{
  gchar * mtt, * mc, * mml;
  gchar * txt[3];
  int ros;
  int a;

  mtt = gtk_entry_get_text (GTK_ENTRY(menu_tab_title));
  mc = gtk_entry_get_text (GTK_ENTRY(menu_command));
  mml = gtk_entry_get_text (GTK_ENTRY(menu_menu_label));

  ros = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(run_on_startup));

  if (!mtt || !mc || !mml)
    return;

  if (!strlen(mtt) || !strlen(mc) || !strlen(mml))
    return;

  something_changed = 1;

  a = gtk_object_get_data (GTK_OBJECT(cur_treeitem), "app_index");
  if (a < 0)
    return;
  strcpy (app_entries[a].tab_title, mtt);
  strcpy (app_entries[a].menu_item_title, mml);
  strcpy (app_entries[a].command, mc);
  app_entries[a].run_on_startup = ros;
  
  property_changed (w, NULL);

}

static void add_menu_item (GtkWidget * w, gpointer user_data)
{
  gchar * mtt, * mc, * mml;
  gchar * txt[4];

  mtt = gtk_entry_get_text (GTK_ENTRY(menu_tab_title));
  mc = gtk_entry_get_text (GTK_ENTRY(menu_command));
  mml = gtk_entry_get_text (GTK_ENTRY(menu_menu_label));

  if (!mtt || !mc || !mml)
    return;
  
  if (!strlen(mtt) || !strlen(mc) || !strlen(mml))
    return;

  something_changed = 1;

  txt[0] = (gchar *)malloc (strlen(mtt)+1);
  txt[1] = (gchar *)malloc (strlen(mml)+1);
  txt[2] = (gchar *)malloc (strlen(mc)+1);
  txt[3] = (gchar *)malloc (4);
  strcpy (txt[0], mtt);
  strcpy (txt[1], mml);
  strcpy (txt[2], mc);
  strcpy (txt[3], gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(run_on_startup)) ? "Yes" : "No");

  gtk_clist_insert (GTK_CLIST(commands_list), row_selected, txt);

  free (txt[0]);
  free (txt[1]);
  free (txt[2]);
  free (txt[3]);

  gtk_entry_set_text (GTK_ENTRY(menu_tab_title), "");
  gtk_entry_set_text (GTK_ENTRY(menu_menu_label), "");
  gtk_entry_set_text (GTK_ENTRY(menu_command), "");  
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(run_on_startup), FALSE);
  net_change++;
  property_changed(w, NULL);
}

static void remove_menu_item (GtkWidget * w, gpointer user_data)
{
  if (row_selected >= 0)
    {
      gtk_clist_remove (GTK_CLIST(commands_list), row_selected);
      property_changed(w, NULL);
      net_change--;
      something_changed = 1;
    }
  
}

static void cb_row_selected (GtkTree * tree, gpointer user_data)
{
  gchar * tmp1, *tmp2, *tmp3;
  int a, b;
  int ros;
  GtkWidget * l;
  gchar * str;

  cur_treeitem = user_data;

  /*  row_selected = row;
  gtk_clist_get_text (GTK_CLIST(commands_list), row_selected, 0, &tmp1);
  gtk_entry_set_text (GTK_ENTRY(menu_tab_title), tmp1);

  gtk_clist_get_text (GTK_CLIST(commands_list), row_selected, 1, &tmp2);
  gtk_entry_set_text (GTK_ENTRY(menu_menu_label), tmp2);
 
  gtk_clist_get_text (GTK_CLIST(commands_list), row_selected, 2, &tmp3);
  gtk_entry_set_text (GTK_ENTRY(menu_com_mand), tmp3);

  gtk_clist_get_text (GTK_CLIST(commands_list), row_selected, 3, &tmp3);

  ros = 0;
  if (!strcmp (tmp3, "Yes"))
    ros = 1;

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(run_on_startup), ros);
  */

  l = GTK_LABEL (GTK_BIN (user_data)->child);
  gtk_label_get (l, &str);


  b = gtk_object_get_data (GTK_OBJECT(user_data), "app_index");

  if (b < 0)
    return;

  gtk_entry_set_text (GTK_ENTRY(menu_tab_title), app_entries[b].tab_title);
  gtk_entry_set_text (GTK_ENTRY(menu_menu_label), app_entries[b].menu_item_title);
  gtk_entry_set_text (GTK_ENTRY(menu_command), app_entries[b].command);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(run_on_startup), app_entries[b].run_on_startup);

}

int ApplyPrefsMenus ()
{
  num_rows = num_apps + net_change;
  /*
  free (app_entries);
  app_entries = (appentry *)malloc (sizeof(appentry) * num_rows);
  num_apps = num_rows;

  for (a=0;a<num_rows;a++)
    {
      gtk_clist_get_text (GTK_CLIST(commands_list), a, 0, &tmp1);
      gtk_clist_get_text (GTK_CLIST(commands_list), a, 1, &tmp2);
      gtk_clist_get_text (GTK_CLIST(commands_list), a, 2, &tmp3);
      gtk_clist_get_text (GTK_CLIST(commands_list), a, 3, &tmp4);

      app_entries[a].tab_title = (gchar *)malloc (strlen(tmp1) +1);
      app_entries[a].menu_item_title = (gchar *)malloc (strlen(tmp2) + 1);
      app_entries[a].command = (gchar *)malloc (strlen(tmp3) + 1);

      app_entries[a].run_on_startup = !strcmp (tmp4, "Yes");

      strcpy (app_entries[a].tab_title, tmp1);
      strcpy (app_entries[a].menu_item_title, tmp2);
      strcpy (app_entries[a].command, tmp3);      
    }


  if (something_changed)
    {
      InitMenus (GTK_WIDGET(window));
      gnome_app_install_menu_hints (GNOME_APP(window),menubar);
      gnome_app_install_menu_hints (GNOME_APP(window),file_menu2);
    }
*/

  if (something_changed)
    {
      InitMenus (GTK_WIDGET(window));
      gnome_app_install_menu_hints (GNOME_APP(window), menubar);
      gnome_app_install_menu_hints (GNOME_APP(window), file_menu2);
    }

  something_changed = 0;
  net_change = 0;

}

int CreatePrefsMenus (GtkContainer * area)
{
  int a, b;

  GtkWidget * treeitem;
  GtkWidget * curtree;
  GtkWidget * tmp;

  gchar * entries[4];
  net_change = 0;
  something_changed = 0;

  cur_treeitem = NULL;
  
  for (a=0;a<4;a++)
    entries[a] = (gchar *)malloc (256);

  for (a=0;a<4;a++)
    entries[a] = (gchar *)malloc (256);

  hbox3 = gtk_hbox_new (TRUE, 0);
  hbox4 = gtk_hbox_new (TRUE, 0);
  vbox6 = gtk_vbox_new (TRUE, 0);
  vbox7 = gtk_vbox_new (TRUE, 0);
  vbox10 = gtk_vbox_new (FALSE, 0);

  buttonsbox = gtk_hbox_new (TRUE, 0);

  scrollbox = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrollbox),
				  GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

  gtk_widget_set_usize (GTK_WIDGET(scrollbox), 0, 200);

  gtk_widget_show (GTK_WIDGET(scrollbox));


  label6 = gtk_label_new ("Tab Title");
  label8 = gtk_label_new ("Command");
  label7 = gtk_label_new ("Menu Title");

  button1 = gtk_button_new_with_label ("Add");
  updatebutton = gtk_button_new_with_label ("Update");

  button2 = gtk_button_new_with_label ("Remove");

  menu_tab_title = gtk_entry_new();
  menu_command = gtk_entry_new();
  menu_menu_label = gtk_entry_new();

  run_on_startup = gtk_check_button_new_with_label ("Run on startup");



  gtk_box_pack_start (GTK_BOX(area), vbox10, TRUE, TRUE, 0);


  commands_list = gtk_tree_new();

  gtk_box_pack_start (GTK_BOX(vbox10), hbox3, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox3), vbox6, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox3), vbox7, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(vbox6), label6, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox6), label7, TRUE, TRUE, 0);  
  gtk_box_pack_start (GTK_BOX(vbox6), label8, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(vbox10), run_on_startup, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(vbox7), menu_tab_title, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox7), menu_menu_label, TRUE, TRUE, 0);  
  gtk_box_pack_start (GTK_BOX(vbox7), menu_command, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(vbox10), buttonsbox, FALSE, FALSE, 10);
  gtk_box_pack_start (GTK_BOX(buttonsbox), button1, TRUE, TRUE, 10);
  gtk_box_pack_start (GTK_BOX(buttonsbox), updatebutton, TRUE, TRUE, 10);

  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scrollbox),
					 GTK_WIDGET(commands_list));

  gtk_box_pack_start (GTK_BOX(vbox10), scrollbox, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox10), button2, FALSE, FALSE, 0);

  curtree = commands_list;
  b = 0;

  for (a=0;a<num_apps;a++)
    {
      strcpy (entries[0], app_entries[b].tab_title);
      strcpy (entries[1], app_entries[b].menu_item_title);
      strcpy (entries[2], app_entries[b].command);
      strcpy (entries[3], app_entries[b].run_on_startup ? "Yes" : "No");

      if (!strcmp (entries[0], "<submenu>"))
	{
	  if (!strcmp (entries[2], "<increase>"))
	    {
	      treeitem = gtk_tree_item_new_with_label(entries[1]);
	      gtk_tree_append (GTK_TREE(curtree), GTK_TREE_ITEM(treeitem));
	      curtree = gtk_tree_new();
	      gtk_tree_item_set_subtree (GTK_TREE_ITEM(treeitem), curtree);
	      gtk_object_set_data (GTK_OBJECT(treeitem), "app_index", -1);
	      gtk_signal_connect (GTK_OBJECT(curtree), "select-child",
				  GTK_SIGNAL_FUNC (cb_row_selected),
				  NULL);
	      gtk_widget_show (treeitem);
	    }
	  else
	    {
	      curtree = curtree->parent;
	    }
	}
      else
	{
	  treeitem = gtk_tree_item_new_with_label (entries[1]);
	  gtk_tree_append (GTK_TREE (curtree), GTK_TREE_ITEM(treeitem));
	  gtk_object_set_data (GTK_OBJECT(treeitem), "app_index", a);
	  gtk_widget_show (treeitem);
	}
      b++;
    }

  gtk_signal_connect_object (GTK_OBJECT(button1), "clicked", 
			     GTK_SIGNAL_FUNC(add_menu_item), GTK_OBJECT(area));
  gtk_signal_connect_object (GTK_OBJECT(updatebutton), "clicked",
			     GTK_SIGNAL_FUNC(update_menu_item), GTK_OBJECT(area));
  gtk_signal_connect_object (GTK_OBJECT(button2), "clicked",
			     GTK_SIGNAL_FUNC(remove_menu_item), GTK_OBJECT(area));

  gtk_signal_connect (GTK_OBJECT(commands_list), "select-child",
		      GTK_SIGNAL_FUNC (cb_row_selected),
		      NULL);

}
