require! path: {normalize}

# version
command-eq '-v', ["LiveScript version #{LiveScript.VERSION}"]

# eval print
command-eq '-pe "2 + 2"', [4]

# help
command-eq '-h', [/^Usage: lsc (.|\n)*Misc:(.|\n)*Output control:(.|\n)*Version/]

one-js = 'var f;\nf = function(x){\n  return 1 + x;\n};'
one-path-js = normalize 'test/data/one.js'
one-path-ls = normalize 'test/data/one.ls'

# compile print
command-eq '-cpb --no-header test/data/one.ls', [one-js]

# compile
command-eq '-cb --no-header --debug test/data/one.ls', ["#one-path-ls => #one-path-js"], ->
    try
        ok file-exists one-path-js
        eq one-js, file-read one-path-js
    finally
        file-delete one-path-js

# header
command-eq '-cpb test/data/empty.ls', [
    "// Generated by LiveScript #{LiveScript.VERSION}"
]

# no-header
command-eq '-cpb --no-header test/data/empty.ls', [
    ''
]

# not using bare
command-eq '-cp --no-header test/data/empty.ls', [
    '(function(){\n\n}).call(this);'
]

# json
json-content = '{\n  "moo": 1,\n  "foo": "string"\n}'

# implicit json
command-eq '-cp test/data/data.json.ls', [json-content ]

# explicit json
command-eq '-cp --json test/data/data.ls', [json-content]

# eval print json, explicit
command-eq '-je "@two" test/data/j.json', ['4']

# eval print json, implicit
command-eq '-e "@two" test/data/j.json', ['4']

# map, basic
command-eq '-c --debug --map linked test/data/empty.ls', [
    "#{normalize 'test/data/empty.ls'} => #{normalize 'test/data/empty.js'}, #{normalize 'test/data/empty.js.map'}"
], ->
    try
        ok file-exists 'test/data/empty.js'
        ok file-exists 'test/data/empty.js.map'
        ok //empty\.js\.map//.test file-read 'test/data/empty.js'
    finally
        file-delete 'test/data/empty.js'
        file-delete 'test/data/empty.js.map'
