#TRUSTED 84294d24a088441e0f972b5d51f2853116b501edb70993628c2e56a643580bf4316e8fb28115cef9ce45d9c35da26fc9b1633a3face462d99e750777e9f259e6f0b800d899dea1bdd8360e913a1ff3e7572521244bb51b0159cd4f139ebc3ca6fd30441505a7830a6b3006561e094d429d0b73bbf6e0d65d30afd9c9b5630a0aee53761acd9d141b31ace0a2a3748e8f713e3f68e933f52a50898b7c2ce49b6fa345d220b794341e056832e7e22054484dec931f8704283cf5a3786c7589148f3622e919f0fceb96e3c1d8508ba2a3a2d4918293c668f5dd5fec5d9ea9df6ae694820804a58633449b156dbd799d9bf1a3343177c1ecab5a5df18b3323a01050da520b8cae68c66f91a85d4f6adec1a48ff96f65644ab706a2bfcc6fec1d0d14378c95fcfc61fc5ed80ea857002eb1d81364b2be970dcfe970379bc853a056c13a64db63dde2672a18cf1d25ad5f8d805ecfcef1960a339681b0dddbf4a1c4a02d2333d424ffff91cff79392f908b860da0fdc49e1816898b3b2a355ca14f395fe804cd3a844886dd7ed2590f18ad5936f64752638b6e56870fb29de5e868e599f7eaf58b283a6c4bb0ad8788d28f63eac5636b1e7582d55a7d20242d8a78afa5e5348f16dc9afac728cf2105473424d964973394630b0eec06bb9dd7f3196941e890b3dff94ba7b71faf1892f7f3775d52e074270dbd3871cf529dfbbdce280
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15883);
 script_version ("1.1");
 name["english"] = "Hydra: SAP R3";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SAP R3 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SAP R3 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_add_preference(name: "Client ID (between 0 and 99) : ", type: "entry", value: "");
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/sap-r3", 3299);
 script_dependencies("hydra_options.nasl", "find_service.nes", "amap.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/sap-r3");
if (! port) port = 3299;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

id = script_get_preference("Client ID (between 0 and 99) : ");
if (! id) exit(0);
id = int(id);
if (id < 0 || id > 99) exit(0);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "sapr3";
argv[i++] = id;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/sapr3/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SAP R3 accounts:\n' + report);
