#TRUSTED 1410c937c1039e4293de4ee7e59f367f8479b0e24f3fc0ce414e75906b96f097ab09fa8565218e6f8c9ebde60e20b4e13ef060d2593f3bd89165c0a80e19c238accd8e00e7fdf406d3d4daee0140d131105630293fceb663ef0d1322114788a1eec8e31f4693b336b953d930c623c6d2df08f80054e2909fb6e370293b9ab60783f18d0953b2388ed0c0f0c2f22271272c357b7e39d5d281fffccfbb461991b21002fa43cead9a6ce875ba2d9af376b1204f3aba623154e166888d13a340ef9cddb886b6c2c331e408a5a95e797120981e26c957c3905e8561a66c210416662234bfc6ee0528caff09aa0acca443724e0d3845da22aa11b6c994ea6d76d80d49e55b132e5c6bf8f3a020423e3378eaffc906f86658d586c08d2a6fbdbb7f17c62967b46d0e695a75608fd478ff1756872232f7c06a8646ff808ee198161014251fb54a7e5650d81d6536b6d1bac81ba4336f8b234ff1bb5984ab0a2e62e6040a2bded5e3a8693efd8140e3889c32b083957309ab79d01c3c8fdc31c04135c51db17e8f99b0b5e07e934b5a44d00429881cbb2537feb9a5284815a417c05f48c0e0e5f88bd3a94bbf2617c600d6d78e65d805f0e8b706cca1ca4a0ac81a30d3faa3a942f99600cd9115b25a6b11004b34f36251c9b6efa4c9e1b97672e767d8e06b3b4ef181ce044518e2551997377dc34bf0a562247178d896609434e419e88c
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15869);
 script_version ("1.1");
 name["english"] = "Hydra: Cisco";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find Cisco passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force Cisco authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_ports("Services/telnet", 23);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd == NULL) exit(0);

port = get_kb_item("Services/telnet");
if (! port) port = 23;
if (! get_port_state(port)) exit(0);
soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv(socket: soc, length: 1024);
close(soc);
if ("Password:" >!< r) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-P"; argv[i++] = passwd;
if (empty)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "cisco";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    # l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: 'Hydra/cisco/'+port, value: p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to find the following CISCO passwords:\n' + report);
