# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200411-25.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2004 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(15736);
 script_version("$Revision: 1.2 $");
 script_bugtraq_id( 11653 );
 script_xref(name: "GLSA", value: "200411-25");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200411-25
(SquirrelMail: Encoded text XSS vulnerability)


    SquirrelMail fails to properly sanitize certain strings when
    decoding specially-crafted headers.
  
Impact

    By enticing a user to read a specially-crafted e-mail, an attacker
    can execute arbitrary scripts running in the context of the victim\'s
    browser. This could lead to a compromise of the user\'s webmail account,
    cookie theft, etc.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://article.gmane.org/gmane.mail.squirrelmail.user/21169


Solution: 
    All SquirrelMail users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=mail-client/squirrelmail-1.4.3a-r2"
    Note: Users with the vhosts USE flag set should manually use
    webapp-config to finalize the update.
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2004 Michel Arboi");
 script_name(english: "[GLSA-200411-25] SquirrelMail: Encoded text XSS vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'SquirrelMail: Encoded text XSS vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "mail-client/squirrelmail", unaffected: make_list("ge 1.4.3a-r2"), vulnerable: make_list("lt 1.4.3a-r2")
)) { security_warning(0); exit(0); }
