// viewchanger.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Modifier subclasses for changing attributes of DataView (representing the
// visual display of the Data.

#ifndef VIEWCHANGER_H
#ifdef __GNUG__
#pragma interface
#endif
#define VIEWCHANGER_H

#include "modifier.h"
#include "range.h"

class DataView;
class Data;

class ViewChanger : public Modifier {
	typedef Modifier Super;
public:
	ViewChanger(DataView* view);
	virtual ~ViewChanger();
	redefined int apply();
protected:
	virtual int doApply(DataView* view)=0;
	Data* viewData();
	DataView* myView;
};

class ScaleOptionsSetter : public ViewChanger {
	typedef ViewChanger Super;
public:
	ScaleOptionsSetter(DataView *);
protected:
	redefined Requester* createRequester();
	redefined int doApply(DataView*);
private:
	ChoiceValue smpteFormat;
};

class VisibleFrameRange : public ViewChanger {
	typedef ViewChanger Super;
public:
	VisibleFrameRange(DataView *);
protected:
	redefined Requester* createRequester();
	redefined int doApply(DataView*);
private:
	QueryRange frameRange;
	TimeVal minTime, maxTime;
	int minFrame, maxFrame;
};

class InsertPoint : public ViewChanger {
	typedef ViewChanger Super;
public:
	InsertPoint(DataView *);
protected:
	redefined Requester* createRequester();
	redefined void saveConfig();
	redefined int doApply(DataView*);
private:
	int _insertPoint;
	TimeVal _insertTime;
	static int _savedInsertPoint;
	static TimeVal _savedInsertTime;
	int minChan, maxChan;
};

class EditRegion : public ViewChanger {
	typedef ViewChanger Super;
public:
	EditRegion(DataView *);
protected:
	redefined Requester* createRequester();
	redefined int doApply(DataView*);
private:
	boolean inFrames;
	QueryRange editRange;
	TimeVal minTime, maxTime;
	int minFrame, maxFrame;
	int minChan, maxChan;
};

class ChannelRange : public ViewChanger {
	typedef ViewChanger Super;
protected:
	ChannelRange(DataView *, const Range &);
	redefined int doApply(DataView*);
protected:
	QueryRange displayRange;
	int minVal, maxVal;
};

class ChannelChannelRange : public ChannelRange {
	typedef ChannelRange Super;
public:
	ChannelChannelRange(DataView *);
protected:
	redefined Requester* createRequester();
	redefined void initialize();
};

class FrameChannelRange : public ChannelRange {
	typedef ChannelRange Super;
public:
	FrameChannelRange(DataView *);
protected:
	redefined Requester* createRequester();
	redefined void initialize();
private:
	double maxFrames;
};

#endif
