with Input_Sources.File; use Input_Sources.File;
with DOM.Readers;        use DOM.Readers;
with Sax.Readers;        use Sax.Readers;
with DOM.Core.Nodes;     use DOM.Core.Nodes;
with DOM.Core.Documents; use DOM.Core.Documents;
with Ada.Exceptions;     use Ada.Exceptions;
with Ada.Text_IO;        use Ada.Text_IO;

procedure My_Test is
   Read : File_Input;
   My_Tree_Reader : Tree_Reader;
   Doc : Dom.Core.Document;
   Element2_List : Dom.Core.Node_List;
   Text_Node : Dom.Core.Node;
begin

   Open ("test.xml", Read);

   Parse (My_Tree_Reader, Read);
   Close (Read);

   Doc := Get_Tree(My_Tree_Reader);

   Element2_List := Dom.Core.Documents.Get_Elements_By_Tag_Name(Doc,"element2_node");

   if (Length (Element2_List) > 0) and then Has_Child_Nodes (Item(Element2_List,0)) then

      Text_Node := First_Child (Item(Element2_List,0));

      Ada.Text_Io.Put_Line ("Text Node read from file parsed     => '"&Node_Value(Text_Node)&"'");

      Set_Node_Value (Text_Node , "&&30");

      Ada.Text_Io.Put_Line ("Text Node read after assign a value => '"&Node_Value(Text_Node)&"'");

      Ada.Text_Io.New_Line;

      Ada.Text_Io.Put_Line ("************* PRINT *************");

      Dom.Core.Nodes.Print (Doc);

   else

      Ada.Text_Io.Put_Line ("No element2_node exists...");

   end if;

   Free (Doc);

exception
   when E : XML_Fatal_Error =>
      Close (Read);
      Put_Line (Exception_Message (E));
      Free (My_Tree_Reader);
end My_Test;
