/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;


public class ClientSavepointSapDB
    implements Savepoint
{
    Savepoint originalSavepoint;
    private ClientConnectionSapDB clientConnection;
    
    static java.sql.Savepoint createNew(Savepoint originalSavepoint,
                                        ClientConnectionSapDB clientConnection)
    {
        ClientSavepointSapDB sp=new ClientSavepointSapDB(originalSavepoint, 
                                                         clientConnection);
        return (java.sql.Savepoint)sp;
    }
    

    private ClientSavepointSapDB(Savepoint originalSavepoint,
                                 ClientConnectionSapDB clientConnection)
    {
        this.originalSavepoint=originalSavepoint;
        this.clientConnection=clientConnection;
    }
    
    void exceptionOccurred(SQLException sqlEx) 
    {
        this.clientConnection.exceptionOccurred(sqlEx);
    }

    // Code for delegation of java.sql.Savepoint methods to originalSavepoint

    public int getSavepointId() throws SQLException
    {
        try {
            return originalSavepoint.getSavepointId();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getSavepointName() throws SQLException
    {
        try {
            return originalSavepoint.getSavepointName();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }
    
    static Savepoint setSavepoint(ClientConnectionSapDB connection) 
        throws SQLException
    {
        Savepoint sp = connection.getPhysicalConnection().setSavepoint();
        return sp==null ? null : ClientSavepointSapDB.createNew(sp, connection);
    }

    static Savepoint setSavepoint(String name, ClientConnectionSapDB connection) 
        throws SQLException
    {
        Savepoint sp = connection.getPhysicalConnection().setSavepoint(name);
        return sp==null ? null : ClientSavepointSapDB.createNew(sp, (ClientConnectionSapDB)connection);
    }
    

    static void releaseSavepoint(Connection connection, Savepoint sp)
        throws SQLException
    {
        if(sp instanceof ClientSavepointSapDB) {
            connection.releaseSavepoint( ((ClientSavepointSapDB)sp).originalSavepoint );
        } else {
            connection.releaseSavepoint( sp );
        }
    }

    static void rollback(Connection connection, Savepoint sp)
        throws SQLException
    {
        if(sp instanceof ClientSavepointSapDB) {
            connection.rollback( ((ClientSavepointSapDB)sp).originalSavepoint );
        } else {
            connection.rollback( sp );
        }
    }
}
