package ru.novosoft.uml.gen;

import java.util.*;
import java.io.*;

import ru.novosoft.uml.gen.mmm.*;

public class GenMMFactoryImpl extends GenMMWriter
{
  public static String CLASSNAME = "MFactoryImpl";
  public static String PACKAGE= GenMM.ROOT_PACKAGE;

  protected MPackage root = null;
  
  GenMMFactoryImpl(GenMM g, HashMap hmTypes) throws IOException
  {
    super(g, PACKAGE, CLASSNAME+".java");
    try
    {
      prolog();

      sline("package "); print(PACKAGE); println(";");
      println();

      imports();

      println();
      sline("public final class "); print(CLASSNAME); println(" extends MFactory"); 
      sblock();

      appendResource(PACKAGE, CLASSNAME+".user");

      Iterator i = hmTypes.values().iterator();
      while (i.hasNext())
      {
        MClass c = (MClass)i.next();
        if (c instanceof MElement)
        {
          MElement e = (MElement)c;
          if(!e.isAbstract())
          {
            sline("public final ");
            print(cname(e));
            print(" create");
            print(e.getName());
            println("()");
            sblock();
            sline("return new ");print(iname(e));println("();");
            eblock();
          }
        }
      }
      println();
      eblock();
    }
    finally
    {
      close();
    }
  }

  protected void imports()
  {
    importCollections();
    println();

    line("import ru.novosoft.uml.foundation.core.*;");
    line("import ru.novosoft.uml.foundation.data_types.*;");
    line("import ru.novosoft.uml.foundation.extension_mechanisms.*;");
    line("import ru.novosoft.uml.behavior.*;");
    line("import ru.novosoft.uml.behavior.use_cases.*;");
    line("import ru.novosoft.uml.behavior.common_behavior.*;");
    line("import ru.novosoft.uml.behavior.state_machines.*;");
    line("import ru.novosoft.uml.behavior.collaborations.*;");
    line("import ru.novosoft.uml.behavior.activity_graphs.*;");
    line("import ru.novosoft.uml.model_management.*;");

    line("import ru.novosoft.uml.undo.*;");
    line("import java.util.TooManyListenersException;");
    line("import java.lang.reflect.Method;");

    println();
  }

}