/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.serversocket;

import com.sun.cdc.io.ConnectionBase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class Protocol
extends ConnectionBase
implements StreamConnectionNotifier,
ServerSocketConnection {
    ServerSocket ssocket;

    protected void checkPermission(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(n);
        }
    }

    public void open(String string, int n, boolean bl) throws IOException {
        if (string.charAt(0) != '/' || string.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\" " + string);
        }
        if (string.length() == 2) {
            this.open();
            return;
        }
        if (string.charAt(2) != ':') {
            throw new IllegalArgumentException("Protocol must start with \"//:\" " + string);
        }
        if ((string = string.substring(3)).length() == 0) {
            this.checkPermission(0);
            this.open();
            return;
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            final int n2 = Integer.parseInt(string);
            this.checkPermission(n2);
            this.ssocket = (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PrivilegedActionException, IOException {
                    return new ServerSocket(n2);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port number in " + string);
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = (IOException)privilegedActionException.getException();
            throw iOException;
        }
    }

    public void open() throws IOException {
        this.ssocket = new ServerSocket();
        this.ssocket.bind(null);
    }

    public StreamConnection acceptAndOpen() throws IOException {
        Socket socket = this.ssocket.accept();
        com.sun.cdc.io.j2me.socket.Protocol protocol = new com.sun.cdc.io.j2me.socket.Protocol();
        protocol.open(socket);
        return protocol;
    }

    public void close() throws IOException {
        this.ssocket.close();
    }

    public String getLocalAddress() throws IOException {
        if (this.ssocket.isClosed()) {
            throw new IOException("ServerSocketConnection is closed");
        }
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.getHostAddress();
    }

    public int getLocalPort() throws IOException {
        if (this.ssocket.isClosed()) {
            throw new IOException("ServerSocketConnection is closed");
        }
        return this.ssocket.getLocalPort();
    }
}

