/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.jfree.io.IOUtils;
import org.jfree.xml.generator.ModelBuilder;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.Comments;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.IgnoredPropertyInfo;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MultiplexMappingInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.util.AbstractModelReader;
import org.jfree.xml.util.ObjectDescriptionException;

public class DefaultModelReader
extends AbstractModelReader {
    private DescriptionModel model;
    private ClassDescription currentClassDescription;
    private BeanInfo currentBeanInfo;
    private URL baseURL;
    private String source;
    private MultiplexMappingInfo multiplexInfo;
    private ArrayList multiplexTypeInfos;
    private ArrayList propertyList;
    private ArrayList constructorList;
    static /* synthetic */ Class class$java$lang$Object;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected void endIncludeHandling() {
        this.source = "";
    }

    protected void endMultiplexMapping() throws ObjectDescriptionException {
        TypeInfo[] typeInfos = this.multiplexTypeInfos.toArray(new TypeInfo[this.multiplexTypeInfos.size()]);
        this.multiplexInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.multiplexInfo.setChildClasses(typeInfos);
        this.model.getMappingModel().addMultiplexMapping(this.multiplexInfo);
        this.multiplexInfo = null;
    }

    protected void endObjectDefinition() throws ObjectDescriptionException {
        PropertyInfo[] pis = this.propertyList.toArray(new PropertyInfo[this.propertyList.size()]);
        this.currentClassDescription.setProperties(pis);
        TypeInfo[] tis = this.constructorList.toArray(new TypeInfo[this.constructorList.size()]);
        this.currentClassDescription.setConstructorDescription(tis);
        this.currentClassDescription.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.currentClassDescription.setSource(this.source);
        this.model.addClassDescription(this.currentClassDescription);
        this.propertyList = null;
        this.currentBeanInfo = null;
        this.currentClassDescription = null;
    }

    protected void endRootDocument() {
        this.model.setModelComments(new Comments(this.getOpenComment(), this.getCloseComment()));
    }

    protected void fillSuperClasses() {
        int i = 0;
        while (i < this.model.size()) {
            ClassDescription superCD;
            ClassDescription cd = this.model.get(i);
            Class parent = cd.getObjectClass().getSuperclass();
            if (parent != null && (superCD = this.model.get(parent)) != null) {
                cd.setSuperClass(superCD.getObjectClass());
            }
            ++i;
        }
    }

    protected PropertyDescriptor getPropertyDescriptor(String propertyName) {
        PropertyDescriptor[] pds = this.currentBeanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < pds.length) {
            if (pds[i].getName().equals(propertyName)) {
                return pds[i];
            }
            ++i;
        }
        return null;
    }

    protected void handleAttributeDefinition(String name, String attribName, String handlerClass) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.getInstance().createSimplePropertyInfo(this.getPropertyDescriptor(name));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + name);
        }
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        propertyInfo.setPropertyType(PropertyType.ATTRIBUTE);
        propertyInfo.setXmlName(attribName);
        propertyInfo.setXmlHandler(handlerClass);
        this.propertyList.add(propertyInfo);
    }

    protected void handleConstructorDefinition(String tagName, String parameterClass) throws ObjectDescriptionException {
        Class c = this.loadClass(parameterClass);
        if (c == null) {
            throw new ObjectDescriptionException("Failed to load class " + parameterClass);
        }
        TypeInfo ti = new TypeInfo(tagName, c);
        ti.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.constructorList.add(ti);
    }

    protected void handleElementDefinition(String name, String element) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.getInstance().createSimplePropertyInfo(this.getPropertyDescriptor(name));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + name);
        }
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        propertyInfo.setPropertyType(PropertyType.ELEMENT);
        propertyInfo.setXmlName(element);
        propertyInfo.setXmlHandler(null);
        this.propertyList.add(propertyInfo);
    }

    protected void handleIgnoredProperty(String name) {
        IgnoredPropertyInfo propertyInfo = new IgnoredPropertyInfo(name);
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.propertyList.add(propertyInfo);
    }

    protected void handleLookupDefinition(String name, String lookupKey) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.getInstance().createSimplePropertyInfo(this.getPropertyDescriptor(name));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + name);
        }
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        propertyInfo.setPropertyType(PropertyType.LOOKUP);
        propertyInfo.setXmlName(lookupKey);
        propertyInfo.setXmlHandler(null);
        this.propertyList.add(propertyInfo);
    }

    protected boolean handleManualMapping(String className, String readHandler, String writeHandler) throws ObjectDescriptionException {
        ManualMappingInfo manualMappingInfo = new ManualMappingInfo(this.loadClass(className), this.loadClass(readHandler), this.loadClass(writeHandler));
        manualMappingInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        manualMappingInfo.setSource(this.source);
        this.model.getMappingModel().addManualMapping(manualMappingInfo);
        return true;
    }

    protected void handleMultiplexMapping(String typeName, String className) throws ObjectDescriptionException {
        TypeInfo info = new TypeInfo(typeName, this.loadClass(className));
        info.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.multiplexTypeInfos.add(info);
    }

    public synchronized DescriptionModel load(String file) throws IOException, ObjectDescriptionException {
        this.model = new DescriptionModel();
        this.baseURL = new File(file).toURL();
        this.parseXml(this.baseURL);
        this.fillSuperClasses();
        return this.model;
    }

    protected void startIncludeHandling(URL resource) {
        this.source = IOUtils.getInstance().createRelativeURL(resource, this.baseURL);
        this.model.addSource(this.source);
        this.model.addIncludeComment(this.source, new Comments(this.getOpenComment(), this.getCloseComment()));
    }

    protected void startMultiplexMapping(String className, String typeAttr) {
        this.multiplexInfo = new MultiplexMappingInfo(this.loadClass(className), typeAttr);
        this.multiplexInfo.setSource(this.source);
        this.multiplexTypeInfos = new ArrayList();
    }

    protected boolean startObjectDefinition(String className, String register, boolean ignore) {
        Class c = this.loadClass(className);
        if (c == null) {
            return false;
        }
        this.currentClassDescription = new ClassDescription(c);
        this.currentClassDescription.setPreserve(ignore);
        this.currentClassDescription.setRegisterKey(register);
        try {
            this.currentBeanInfo = Introspector.getBeanInfo(c, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = DefaultModelReader.class$("java.lang.Object")));
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
        this.propertyList = new ArrayList();
        this.constructorList = new ArrayList();
        return true;
    }

    protected void startRootDocument() {
        this.source = "";
    }
}

