/*
     (C)opyright RISKO Gergely, 2001.
     
     This program can be licensed under the terms of 
     GNU Lesser General Public License v2.1 or above,
     it can be found (on Debian systems) in
     /usr/share/common-licenses/LGPL-2.1
     
     This library was written for the game bombardier,
     but if you are a programmer who use this library
     for your own game it is welcomed. Please mail to
     risko@debian.org in this case, just to put here
     the name of your game and your name!
     
     The library is dedicated to Kosa Zsuzsanna.
*/

#include "libhs.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>

struct hs_table * hs_open(char *progname, char *branch, void **defaultdata, int datasize)
{
    struct hs_table *table = malloc(sizeof(struct hs_table));
    
    table->datasize=datasize;
    if ((progname==NULL) || (branch==NULL))
    {
	free(table);
	table=NULL;
    }
    else
    {
	char * filename=malloc(strlen(HS_DIRPREFIX)+1);
	int justcreated=0;
	
	strcpy(filename, HS_DIRPREFIX);
	filename[strlen(HS_DIRPREFIX)]=0;	
	table->progname=malloc(strlen(progname)+1);
	strcpy(table->progname, progname);
	table->progname[strlen(progname)]=0;
	table->branch=malloc(strlen(branch)+1);
	strcpy(table->branch, branch);
	table->branch[strlen(branch)]=0;
	filename=realloc(filename, strlen(filename) + strlen(table->progname) + strlen(table->branch)+2);
	strcat(filename, table->progname);
	strcat(filename, ".");
	strcat(filename, table->branch);
	table->fd=open(filename, O_RDWR);
	table->head=NULL;
	if (table->fd<0)
	{
	    justcreated=1;
	    umask(002);
	    table->fd=creat(filename, 0664);
	}
	if (table->fd>0)
	{
	    if (flock(table->fd, LOCK_EX)==0)
	    {
		/* The file opening and locking is successfull! */
		if ((justcreated) && (defaultdata!=NULL))
		{
		    void **cur;
		    struct hs_item *hscur;
		    
		    cur=defaultdata;
		    table->head=malloc(sizeof(struct hs_item));
		    hscur=table->head;
		    hscur->next=NULL;
		    while(*cur!=NULL)
		    {
			hscur->next=malloc(sizeof(struct hs_item));
			hscur=hscur->next;
			hscur->next=NULL;
			hscur->data=malloc(datasize);
			memcpy(hscur->data, *cur, datasize);
			cur++;
		    }
		    hscur=table->head;
		    table->head=table->head->next;
		    free(hscur);
		}
		else
		{
		    struct hs_item *hscur;
		    void *cur=malloc(datasize);
		    
		    table->head=malloc(sizeof(struct hs_item));
		    hscur=table->head;
		    hscur->next=NULL;
		    while (read(table->fd, cur, datasize)==datasize)
		    {
			hscur->next=malloc(sizeof(struct hs_item));
			hscur=hscur->next;
			hscur->next=NULL;
			hscur->data=malloc(datasize);
			memcpy(hscur->data, cur, datasize);
		    }		    
		    hscur=table->head;
		    table->head=table->head->next;
		    free(hscur);
		}
	    }
	    else
	    {
		close(table->fd);
	        free(table->progname);
		free(table->branch);
	        free(table);
	        table=NULL;
	    }
	}
	else
	{
	    free(table->progname);
	    free(table->branch);
	    free(table);
	    table=NULL;
	}
        free(filename);
    }
    
    return table;
}

int hs_insert(struct hs_table *table, void *data, hs_compfn compfn)
{
    struct hs_item *cur, *newi;
    int ret=1;
    
    newi=malloc(sizeof(struct hs_item));
    newi->data=malloc(table->datasize);
    memcpy(newi->data, data, table->datasize);
    if ((table->head==NULL) || (compfn(data, table->head->data)==1))
    {
	// The new data is greater than the first item!
	newi->next=table->head;
	table->head=newi;
    }
    else
    {
	int l=0;
	
	cur=table->head;
	ret++;
	while ((!l) && (cur->next!=NULL))
	{
	    if (compfn(data, cur->next->data)==1) l=1;
	    else 
	    {
	        cur=cur->next;
		ret++;
	    }
	}
        newi->next=cur->next;
        cur->next=newi;
    }
    
    return ret;
}

int hs_write(struct hs_table table, int n)
{
    int i=0;
    int errcode=1;
    struct hs_item *cur=table.head;
    
    lseek(table.fd, 0, SEEK_SET);
    while ((i<n) && (cur!=NULL))
    {
        if (write(table.fd, cur->data, table.datasize)==-1) errcode=0;
	cur=cur->next;
	i++;
    }
    ftruncate(table.fd, lseek(table.fd, 0, SEEK_CUR));
    
    return errcode;
}

void hs_free(struct hs_table * table)
{
    if (table!=NULL)
    {
	struct hs_item *cur;
        struct hs_item *tofree;
	
        flock(table->fd, LOCK_UN);
	close(table->fd);
	if (table->progname!=NULL) free(table->progname);
	if (table->branch!=NULL) free(table->branch);
	cur=table->head;
	while (cur!=NULL)
	{
	    tofree=cur;
	    cur=cur->next;
	    free(tofree->data);
	    free(tofree);
	}
	free(table);
    }
}

struct hs_table * hs_readtable(char *progname, char *branch, int datasize)
{
    struct hs_table *table = malloc(sizeof(struct hs_table));
    
    table->datasize=datasize;
    if ((progname==NULL) || (branch==NULL))
    {
	free(table);
	table=NULL;
    }
    else
    {
	char * filename=malloc(strlen(HS_DIRPREFIX)+1);
	
	strcpy(filename, HS_DIRPREFIX);
	filename[strlen(HS_DIRPREFIX)]=0;	
	table->progname=malloc(strlen(progname)+1);
	strcpy(table->progname, progname);
	table->progname[strlen(progname)]=0;
	table->branch=malloc(strlen(branch)+1);
	strcpy(table->branch, branch);
	table->branch[strlen(branch)]=0;
	filename=realloc(filename, strlen(filename) + strlen(table->progname) + strlen(table->branch)+2);
	strcat(filename, table->progname);
	strcat(filename, ".");
	strcat(filename, table->branch);
	table->fd=open(filename, O_RDONLY);
	if (table->fd>0)
	{
	    if (flock(table->fd, LOCK_SH)==0)
	    {
		/* The file opening and locking was successfull! */
	        struct hs_item *hscur;
	        void *cur=malloc(datasize);
	    
	        table->head=malloc(sizeof(struct hs_item));
		hscur=table->head;
		hscur->next=NULL;
		while (read(table->fd, cur, datasize)==datasize)
		{
		    hscur->next=malloc(sizeof(struct hs_item));
		    hscur=hscur->next;
		    hscur->next=NULL;
		    hscur->data=malloc(datasize);
		    memcpy(hscur->data, cur, datasize);
		}		    
		hscur=table->head;
		table->head=table->head->next;
		free(hscur);
	    }
	    else
	    {
		close(table->fd);
	        free(table->progname);
		free(table->branch);
	        free(table);
	        table=NULL;
	    }
	}
	else
	{
	    free(table->progname);
	    free(table->branch);
	    free(table);
	    table=NULL;
	}
        free(filename);
    }
    
    return table;
}
