=begin
  poparser.rb - Generate a .mo

  Copyright (C) 2003-2005 Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.
=end

#
# DO NOT MODIFY!!!!
# This file is automatically generated by racc 1.4.4
# from racc grammer file "src/poparser.ry".
#

require 'racc/parser'


module GetText

  class PoParser < Racc::Parser

module_eval <<'..end src/poparser.ry modeval..id2c720ef3d7', 'src/poparser.ry', 90
  include GetText
  GetText.bindtextdomain("rgettext")

  def unescape(orig)
    ret = orig.gsub(/\\n/, "\n")
    ret.gsub!(/\\t/, "\t")
    ret.gsub!(/\\r/, "\r")
    ret.gsub!(/\\"/, "\"")
    ret
  end
  
  def parse(str, data, ignore_fuzzy = true)
    @comments = []
    @data = data
    @fuzzy = false
    $ignore_fuzzy = ignore_fuzzy
    str.strip!
    @q = []
    until str.empty? do
      case str
      when /\A\s+/
	str = $'
      when /\Amsgid_plural/
	@q.push [:MSGID_PLURAL, $&]
	str = $'
      when /\Amsgid/
	@q.push [:MSGID, $&]
	str = $'
      when /\Amsgstr/
	@q.push [:MSGSTR, $&]
	str = $'
      when /\A\[(\d+)\]/
	@q.push [:PLURAL_NUM, $1]
	str = $'
      when /\A\#~(.*)/
	$stderr.print _("Warning: obsolete msgid is existed.\n")
	$stderr.print "         #{$&}\n"
	@q.push [:COMMENT, $&]
	str = $'
      when /\A\#(.*)/
	@q.push [:COMMENT, $&]
	str = $'      
      when /\A\"(.*)\"/
	@q.push [:STRING, $1]
	str = $'
      else
	#c = str[0,1]
	#@q.push [:STRING, c]
	str = str[1..-1]
      end
    end 
    @q.push [false, '$end']
    if $DEBUG
      @q.each do |a,b|
      puts "[#{a}, #{b}]"
      end
    end
    @yydebug = true if $DEBUG
    do_parse

    if @comments.size > 0
      @data.set_comment(:last, @comments.join("\n"))
    end
    @data
  end
  
  def next_token
    @q.shift
  end

  def on_message(msgid, msgstr)
    @data[msgid] = msgstr
 
    @data.set_comment(msgid, @comments.join("\n"))
    @comments.clear
  end
      
  def on_comment(comment)
    @fuzzy = true if (/fuzzy/ =~ comment)
    @comments << comment
  end 

..end src/poparser.ry modeval..id2c720ef3d7

##### racc 1.4.4 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 0, 9, :_reduce_none,
 2, 9, :_reduce_none,
 2, 9, :_reduce_none,
 4, 11, :_reduce_4,
 5, 11, :_reduce_5,
 2, 13, :_reduce_6,
 1, 13, :_reduce_none,
 3, 14, :_reduce_8,
 1, 10, :_reduce_9,
 2, 12, :_reduce_10,
 1, 12, :_reduce_11 ]

racc_reduce_n = 12

racc_shift_n = 21

racc_action_table = [
     3,     9,     4,     5,    10,    11,    12,    17,    12,     9,
     9,     7,    12,    17,    19,     9,    12 ]

racc_action_check = [
     1,     5,     1,     1,     8,     8,     8,    13,    13,    10,
    11,     3,    14,    15,    17,    19,    20 ]

racc_action_pointer = [
   nil,     0,   nil,    11,   nil,    -5,   nil,   nil,     0,   nil,
     3,     4,   nil,     2,     6,     8,   nil,     7,   nil,     9,
    10 ]

racc_action_default = [
    -1,   -12,    -3,   -12,    -9,   -12,    -2,    21,   -12,   -11,
   -12,   -12,   -10,   -12,    -4,    -5,    -7,   -12,    -6,   -12,
    -8 ]

racc_goto_table = [
     8,    16,     2,    18,     6,    13,    14,    15,     1,   nil,
   nil,   nil,   nil,   nil,    20 ]

racc_goto_check = [
     4,     6,     3,     6,     2,     4,     4,     5,     1,   nil,
   nil,   nil,   nil,   nil,     4 ]

racc_goto_pointer = [
   nil,     8,     3,     1,    -5,    -6,   -12 ]

racc_goto_default = [
   nil,   nil,   nil,   nil,   nil,   nil,   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :COMMENT => 2,
 :MSGID => 3,
 :MSGID_PLURAL => 4,
 :MSGSTR => 5,
 :STRING => 6,
 :PLURAL_NUM => 7 }

racc_use_result_var = true

racc_nt_base = 8

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_token_to_s_table = [
'$end',
'error',
'COMMENT',
'MSGID',
'MSGID_PLURAL',
'MSGSTR',
'STRING',
'PLURAL_NUM',
'$start',
'msgfmt',
'comment',
'message',
'string_list',
'msgstr_plural',
'msgstr_plural_line']

Racc_debug_parser = true

##### racc system variables end #####

 # reduce 0 omitted

 # reduce 1 omitted

 # reduce 2 omitted

 # reduce 3 omitted

module_eval <<'.,.,', 'src/poparser.ry', 36
  def _reduce_4( val, _values, result )
    if @fuzzy and $ignore_fuzzy 
      if val[1] != ""
        $stderr.print _("Warning: fuzzy message was ignored.\n")
        $stderr.print "         msgid '#{val[1]}'\n"
      else
        on_message('', unescape(val[3]))
      end
      @fuzzy = false
    else
      on_message(unescape(val[1]), unescape(val[3]))
    end
    result = ""
   result
  end
.,.,

module_eval <<'.,.,', 'src/poparser.ry', 51
  def _reduce_5( val, _values, result )
    if @fuzzy and $ignore_fuzzy
      if val[1] != ""
        $stderr.print _("Warning: fuzzy message was ignored.\n")
        $stderr.print "msgid = '#{val[1]}\n"
      else
        on_message('', unescape(val[3]))
      end
      @fuzzy = false
    else
      on_message(unescape(val[1]) + "\000" + unescape(val[3]), unescape(val[4]))
    end
    result = ""
   result
  end
.,.,

module_eval <<'.,.,', 'src/poparser.ry', 58
  def _reduce_6( val, _values, result )
    result = val[0] + "\000" + val[1]
   result
  end
.,.,

 # reduce 7 omitted

module_eval <<'.,.,', 'src/poparser.ry', 66
  def _reduce_8( val, _values, result )
    result = val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'src/poparser.ry', 73
  def _reduce_9( val, _values, result )
    on_comment(val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'src/poparser.ry', 81
  def _reduce_10( val, _values, result )
    result = val.delete_if{|item| item == ""}.join
   result
  end
.,.,

module_eval <<'.,.,', 'src/poparser.ry', 85
  def _reduce_11( val, _values, result )
    result = val[0]
   result
  end
.,.,

 def _reduce_none( val, _values, result )
  result
 end

  end   # class PoParser

end   # module GetText
