/*
    Fast, simple sinh/cosh, tanh routines by Joachim Wesner, 
    <joachim.wesner@frankfurt.netsurf.de>, August 1998
*/

/*
    improved and modified by Kazushige Goto <goto@statabo.rim.or.jp>
*/
/*
    Full illegal argument handling added by Joachim Wesner,
    <joachim.wesner@frankfurt.netsurf.de>, November 1998
*/

	.set noat
	.set noreorder

#ifdef __ELF__
	.section .rodata
#else
	.rdata
#endif

	.align 5
R:
	.t_floating 1.50000000000000000000e0
	.t_floating 7.90403062155570247971e-13
	.t_floating 2.50522882658560084394e-8
	.t_floating 1.98412698521330943665e-4
	.t_floating 1.60496107878975427996e-10
	.t_floating 2.75573173261714868501e-6
	.t_floating 8.33333333330282984008e-3
	.t_floating 1.66666666666669904817e-1
	.t_floating 708.39641

	.align 5
Q:
	.t_floating 1.25000000000000000000e0
	.t_floating 1.17728997288643158904e-11
	.t_floating 2.75574210689988112756e-7
	.t_floating 1.38888888918524584792e-3
	.t_floating 5.00000000000004329870e-1
	.t_floating 2.08690610037061432455e-9
	.t_floating 2.48015865557409068024e-5
	.t_floating 4.16666666666089050008e-2
	.t_floating 1.00000000000000000000e0
	.t_floating 708.39641

	.align 5
P:
	.t_floating  4.74999999999999977796e-1
	.t_floating -1.53846739912265128387e-4
	.t_floating -1.44636955237739629407e-3
	.t_floating -8.86309209072598525037e-3
	.t_floating -5.39682536761898340449e-2
	.t_floating  5.52667917226764117758e-4
	.t_floating  3.59065327462071903417e-3
	.t_floating  2.18694800048884821497e-2
	.t_floating  1.33333333328255060346e-1
	.t_floating -3.33333333333299175472e-1
	.t_floating  2.00000000000000000000e1
	.t_floating  1.00000000000000000000e0
	.t_floating -1.00000000000000000000e0
	.t_floating 708.39641

	.align 5
RR:
	.t_floating  1.44269504088896338700e0
	.t_floating  1.00000000000000000000e0
	.t_floating  6.93359375000000000000e-1
	.t_floating -2.12194440054690598415e-4
	.t_floating  6.29768236459390291646e-10
	.t_floating  1.52532278639779265219e-5
	.t_floating  1.33335587324213489593e-3
	.t_floating  5.55041086659065138753e-2
	.t_floating  1.02577755722569533985e-7
	.t_floating  6.54053877719848751881e-9
	.t_floating  1.32077456410841510838e-6
	.t_floating  1.54035094120123436379e-4
	.t_floating  9.61812909725173574571e-3
	.t_floating  2.40226506959042129807e-1
	.t_floating  6.93147180559946507472e-1
	.t_floating  1.00000000000000000000e0

.text
	.align 5
	.globl sinh
	.ent sinh
sinh:
	lda	$30,-16($30)		###
	ldgp	$29,  .-sinh($27)
	fabs	$f16, $f1		# xabs=fabs(x)
	.frame	$30,16,$26,0

#ifdef PROF
	lda	$28, _mcount
	jsr	$28, ($28), _mcount
	unop
	unop
#endif
	.prologue 1

	lda	$28, R			# load address of R
	fneg	$f16, $f19
	clr	$4
	unop

	stt	$f16,0($30)		###
	lda	$1,0x7ff		###
	ldt	$f0,64($28)		###
	sll	$1,52,$1		###
	ldq	$0,0($30)		###
	and	$0,$1,$2		###
	cmpeq	$2,$1,$3		###
	beq	$2,$Denormal		###
	bne	$3,$NaN_and_Inf		###

	cmptle	$f1,$f0,$f11		###
	fbeq	$f11,$Inf		###
	
	mult	$f16, $f16, $f23	### y = x * x;

	mult	$f23,$f23,$f24		# y2 = y * y
	ldt	$f10,  0($28)		# R[0]
	ldt	$f25,  8($28)		# R[1]
	ldt	$f26, 24($28)		# R[3]

	ldt	$f11, 16($28)		# R[2]
	unop
	ldt	$f12, 32($28)		# R[4]
	cmptle	$f1, $f10, $f1		# $f1 = ( R[0] < fabs)

	mult	$f24, $f24, $f22	# y4 = y2 * y2
	ldt	$f14, 40($28)		# R[5]
	mult	$f25, $f23, $f25	# z1 = R[1] * y
	ldt	$f15, 48($28)		# R[6]

	ldt	$f13, 56($28)		# R[7]
	mult	$f11, $f23, $f11	# z2 = R[2] * y
	fbeq	$f1, $continue

	mult	$f26, $f23, $f10	# z3 = R[3] * y
	mult	$f22, $f24, $f27	# y6 = y4 * y2
	mult	$f13, $f23, $f13	# z4 = R[4] * y
	addt	$f25, $f12, $f25	# z1 += R[5]
	addt	$f11, $f14, $f11	# z2 += R[5]

	mult	$f25, $f27, $f1		# z1 * y6
	addt	$f10, $f15, $f10	# z3 += R[6]
	mult	$f11, $f22, $f11
	mult	$f10, $f24, $f10
	addt	$f1,  $f11, $f1
	addt	$f1,  $f10, $f1
	addt	$f1,  $f13, $f0
	mult	$f0,  $f16, $f0
	addt	$f0,  $f16, $f0

	lda	$30,16($30)
	ret	$31,($26),1


$Denormal:
	ble	$4,$NaN			### keep value for sinh and tanh
	ldt	$f0,64($28)
	br	$L99

$NaN_and_Inf:
	andnot	$0,$1,$2
	sll	$2,1,$2
	beq	$2,$Inf
$NaN:
	fmov	$f16,$f0
	br	$L99

$Inf:
	bge	$4,$L97			### +(/-) Inf for sinh, cosh
	ldt	$f0,88($28)		### +/- 1 for tanh
	br	$L98
$L97:	stq	$1,0($30)
	ldt	$f0,0($30)
	bgt	$4,$L99			### always +Inf for cosh
$L98:	cpys	$f16,$f0,$f0
$L99:
	lda	$30,16($30)
	ret	$31,($26),1
	
	.end sinh


	.align 5
	.globl cosh
	.ent cosh
cosh:
	lda	$30,-16($30)		###
	ldgp	$29, .-cosh($27)
	fabs	$f16,	$f1		# $f1 = fabs($f16)
	.frame $30,16,$26,0

#ifdef PROF
	lda	$28, _mcount
	jsr	$28, ($28), _mcount
	unop
	unop
#endif
	.prologue 1

	lda	$28, Q
	fneg	$f16, $f19
	mov	1, $4
	unop

	stt	$f16,0($30)		###
	lda	$1,0x7ff		###
	ldt	$f0,72($28)		###
	sll	$1,52,$1		###
	ldq	$0,0($30)		###
	and	$0,$1,$2		###
	cmpeq	$2,$1,$3		###
	beq	$2,$Denormal		###
	bne	$3,$NaN_and_Inf		###

	cmptle	$f1,$f0,$f11		###
	fbeq	$f11,$Inf		###
	
	mult	$f16, $f16, $f24	### y = x * x

	ldt	$f10,  0($28)		# Q[0]
	unop
	ldt	$f26,  8($28)		# Q[1]
	mult	$f24, $f24, $f25	# y2 = y * y

	ldt	$f11, 16($28)		# Q[2]
	ldt	$f27, 24($28)		# Q[3]
	cmptlt	$f1,  $f10, $f1		# $f1 = ($f1 < Q[0])
	ldt	$f12, 32($28)		# Q[4]

	ldt	$f13, 40($28)		# Q[5]
	ldt	$f15, 48($28)		# Q[6]
	ldt	$f22, 56($28)		# Q[7]
	mult	$f25, $f25, $f23	# y4 = y2 * y2

	ldt	$f14, 64($28)		# Q[8]
	fbeq	$f1, $continue

	mult	$f26, $f24, $f26
	mult	$f23, $f25, $f28

	mult	$f11, $f24, $f11
	mult	$f27, $f24, $f10
	mult	$f12, $f24, $f12
	addt	$f26, $f13, $f26

	addt	$f11, $f15, $f11
	addt	$f10, $f22, $f10
	addt	$f12, $f14, $f12
	mult	$f26, $f28, $f1

	mult	$f11, $f23, $f11
	mult	$f10, $f25, $f10
	addt	$f1,  $f11, $f1
	addt	$f1,  $f10, $f1

	addt	$f1,  $f12, $f0
	lda	$30,16($30)
	ret	$31,($26),1
	.end cosh

	.align 5
	.globl tanh
	.ent tanh
tanh:
	lda	$30,-16($30)		###
	ldgp	$29,.-tanh($27)
	fabs	$f16, $f10
	.frame	$30,16,$26,0

#ifdef PROF
	lda	$28, _mcount
	jsr	$28, ($28), _mcount
	unop
	unop
#endif
	.prologue	1

	lda	$28, P
	fneg	$f16, $f19
	lda	$4,-1
	unop

	stt	$f16,0($30)		###
	lda	$1,0x7ff		###
	ldt	$f0,104($28)		###
	sll	$1,52,$1		###
	ldq	$0,0($30)		###
	and	$0,$1,$2		###
	cmpeq	$2,$1,$3		###
	beq	$2,$Denormal		###
	bne	$3,$NaN_and_Inf		###

	cmptle	$f10,$f0,$f11		###
	fbeq	$f11,$Inf		###
	
	mult	$f16, $f16, $f26	###

	mult	$f26, $f26, $f28
	ldt	$f1,   0($28)		# P[0]
	ldt	$f27,  8($28)		# P[1]

	ldt	$f12, 16($28)		# P[2]
	ldt	$f11, 24($28)		# P[3]
	cmptlt	$f10, $f1,  $f1
	ldt	$f10, 32($28)		# P[4]

	ldt	$f15, 40($28)		# P[5]
	ldt	$f22, 48($28)		# P[6]
	mult	$f28, $f28, $f13
	ldt	$f23, 56($28)		# P[7]

	ldt	$f24, 64($28)		# P[8]
	ldt	$f30, 80($28)
	mult	$f27, $f26, $f27
	fbeq	$f1,$L14

	mult	$f12, $f26, $f12
	ldt	$f14, 72($28)		# P[9]
	mult	$f13, $f13, $f25
 	mult	$f11, $f26, $f11

	addt	$f27, $f15, $f27
	mult	$f10, $f26, $f10
	mult	$f13, $f28, $f15
	addt	$f12, $f22, $f12

	mult	$f14, $f26, $f14
	addt	$f11, $f23, $f11
	mult	$f27,  $f25, $f1
	addt	$f10, $f24, $f10

	mult	$f12, $f15, $f12
	mult	$f11, $f13, $f11
	mult	$f10, $f28, $f10
	addt	$f1,  $f12, $f1

	addt	$f1,  $f11, $f1
	addt	$f1,  $f10, $f1
	addt	$f1,  $f14, $f0
	mult	$f0,  $f16, $f0

	addt	$f0,  $f16, $f0
	lda	$30,16($30)
	ret	$31,($26),1
	.align 4

$L14:
	cmptle	$f10, $f30, $f1
	fbne	$f1, $continue
	fblt	$f16, $L18
	ldt	$f0, 88($28)
	lda	$30,16($30)
	ret	$31,($26),1
$L18:
	ldt	$f0, 96($28)
	lda	$30,16($30)
	ret	$31,($26),1
	.end tanh

	.align 5
	.ent $continue
$continue:
	lda $28, RR			# load address
	ldt	$f0,   0($28)		# R[0]
	ldt	$f1,   8($28)		# R[1]
	ldt	$f11, 24($28)		# R[3]

	ldt	$f10, 16($28)		# R[2]
	mult	$f16, $f0,  $f17	# x  * R[0]
	lda	$30,-32($30)
	mult	$f19, $f0,  $f18	# xm * R[0]

	cvttqc	$f17, $f17		# $f10 -> int
	stt	$f2, 16($30)
	cvttqc	$f18, $f18		# $f1  -> int
	stt	$f3, 24($30)

	cvtqt	$f17, $f17		# int -> double
	cvtqt	$f18, $f18		# int -> double
	fbge	$f16, $37
	subt	$f17, $f1,  $f17	# iexp1 --

	br	$31,$38
$37:
	subt	$f18, $f1,  $f18	# iexp2 --

$38:
	mult	$f17, $f10, $f29	# iexp1 * R[2]
	ldt	$f13,   0($28)		# R[0]
	mult	$f18, $f10, $f30	# iexp2 * R[2]
	ldt	$f12,  32($28)		# R[4]

	mult	$f17, $f11, $f27	# iexp1 * R[3]
	cvttqc	$f17, $f17		# iexp1 -> int  ($f17 is free)
	mult	$f18, $f11, $f28	# iexp2 * R[3]
	cvttqc	$f18, $f18		# iexp2 -> int  ($f18 is free)

	subt	$f16, $f29, $f29	# x  - iexp1*R[2]
	subt	$f19, $f30, $f30	# x  - iexp2*R[2]

	subt	$f29, $f27, $f16	# (x-iexp1*R[2]) - iexp1*R[3]
	stt	$f17,  0($30)
	subt	$f30, $f28, $f19	# (x-iexp2*R[2]) - iexp2*R[3]
	stt	$f18,  8($30)

	mult	$f16, $f13, $f16	# x  *= R[0]
	ldt	$f10,  40($28)		# R[5]
	mult	$f19, $f13, $f19	# xm *= R[0]	/* Calculation end */
	ldt	$f13,  48($28)		# R[6]

	mult	$f16, $f16, $f29	# x2  = x * x
	ldq	$1,    0($30)
	mult	$f19, $f19, $f30	# x2m = xm * xm
	ldq	$2,    8($30)

	mult	$f12, $f16, $f1		# y1  = R[4] * x
	lda	$1,  1022($1)
	mult	$f12, $f19, $f0		# y1m = R[4] * xm
	lda	$2,  1022($2)

	mult	$f29, $f29, $f23	# x4  = x2  * x2
	sll	$1, 52, $1
	mult	$f30, $f30, $f24	# x4m = x2m * x2m
	sll	$2, 52, $2

	mult	$f10, $f16, $f25	# y3  = R[5] * x
	ldt	$f12,  56($28)		# R[7]
	mult	$f10, $f19, $f26	# y3m = R[5] * xm
	ldt	$f10,  64($28)		# R[8]

	mult	$f13, $f16, $f17 	# y4  = R[6] * x
	stq	$1,     0($30)
	mult	$f13, $f19, $f18 	# y4m = R[6] * xm
	stq	$2,     8($30)

	mult	$f12, $f16, $f27	# y5  = R[7] * x
	ldt	$f13, 72($28)		# R[9]
	mult	$f12, $f19, $f28 	# y5m = R[7] * xm
	mult	$f23, $f29, $f11	# x6  = x4  * x2

	mult	$f24, $f30, $f20	# x6m = x4m * x2m
	mult	$f10, $f16, $f21	# y2  = R[8] * x
	mult	$f10, $f19, $f22	# y2m = R[8] * xm
	ldt	$f10, 80($28)		# R[10]

	mult	$f23, $f11, $f14	# x10  = x4 * x6
	addt	$f1,  $f13, $f1		# y1  += R[9]
 	mult	$f24, $f20, $f15	# x10m = x4m * x6m
	addt	$f0,  $f13, $f0		# y1m += R[9]

	mult	$f23, $f23, $f12 	# x8   = x4  * x4
	ldt	$f2,  88($28)		# R[11]
	addt	$f21, $f10, $f21	# y2  += R[10]
	ldt	$f3,  96($28)		# R[12]

	mult	$f24, $f24, $f13	# x8m  = x4m * x4m
	addt	$f22, $f10, $f22	# y2m += R[10]

	mult	$f1,  $f14, $f1		# y1  *= x10
	addt	$f25, $f2, $f25		# y3  += R[11]
	mult	$f0,  $f15, $f0		# y1m *= x10m
	addt	$f26, $f2, $f26		# y3m += R[11]

	mult	$f21, $f12, $f21	# y2  *= x8
	ldt	$f10, 104($28)		# R[13]
	addt	$f17, $f3,  $f14 	# y4  += R[12]
	ldt	$f2,  112($28)		# R[14]

	mult	$f22, $f13, $f22	# y2m *= x8m
	addt	$f18, $f3,  $f15	# y4m += R[12]
	mult	$f25, $f11, $f25	# y3  *= x6
	addt	$f27, $f10, $f27	# y5  += R[13]

	mult	$f26, $f20, $f26	# y3m *= x6m
	addt	$f28, $f10, $f28	# y5m += R[13]

	mult	$f14, $f23, $f23  	# y4  *= x4
	addt	$f1,  $f21, $f1		# y1  += y2
	mult	$f15, $f24, $f24 	# y4m *= x4m
	addt	$f0,  $f22, $f0		# y1m += y2m

	mult	$f27, $f29, $f29	# y5  *= x2
	mult	$f28, $f30, $f30	# y5m *= x2m
	addt	$f1,  $f25, $f1		# y1  += y3
	addt	$f0,  $f26, $f0		# y1m += y3m

	mult	$f2,  $f16, $f27	# y6  = R[14] * x
	ldt	$f10, 120($28)		# R[15]
	mult	$f2,  $f19, $f28	# y6m = R[14] * xm

	addt	$f1,  $f23, $f1		# y1  += y4
	addt	$f0,  $f24, $f0		# y1m += x4m
	addt	$f27, $f10, $f27	# y6  *= R[15]
	addt	$f28, $f10, $f28	# y6m *= R[15]
	addt	$f1,  $f29, $f1		# y1  += y5
	ldt	$f29,    0($30)
	addt	$f0,  $f30, $f0		# y1m += y5m
	ldt	$f30,    8($30)

	addt	$f1,  $f27, $f1		# y1  += y6
	ldt	$f2, 16($30)
	addt	$f0,  $f28, $f0		# y1m += y6m
	ldt	$f3, 24($30)

	mult	$f1,  $f29, $f1		# y1  *= (double)a1
	addq	$30, 32, $30
	mult	$f0,  $f30, $f0		# y1m *= (double)a2
	bgt	$4, $cosh
	blt	$4, $tan
	subt	$f1,  $f0,  $f0		# return y1 - y1m
	lda	$30,16($30)
	ret
$cosh:
	addt	$f1,  $f0,  $f0		# return y1 - y1m
	lda	$30,16($30)
	ret
	.align 4

$tan:
	addt	$f1,  $f0,  $f10	# return y1 - y1m
	subt	$f1,  $f0,  $f11	# return y1 - y1m
	divt	$f11, $f10, $f0
	lda	$30,16($30)
	ret
	.end $continue
