/**
   @file cache/apt/packages.cpp
   @author Peter Rockai <me@mornfall.net>
*/

#include <ept/tests/test-utils.h>
#include <ept/cache/cache.h>

namespace tut {

using namespace ept;
using namespace configuration::apt;

struct cache_apt_packages_shar : common {
    cache::Aggregator agg;
};
TESTGRP( cache_apt_packages );

template<> template<>
void to::test<1> ()
{
    /* cf.Open( progress, false );
    _error->DumpErrors();
    // std::cerr << std::endl << "package count: " << cf . pkgCache () -> HeaderP -> PackageCount;
    ensure_equals( cf.packageCache()->packageCount(), 19113 ); */
}

template<> template<>
void to::test<2> ()
{
    std::set< cache::Package > v;
    std::set< cache::Package >::iterator i;
    cache::Index::iterator j;
    int x = 0;
    for ( j = agg.index().begin(); j != agg.index().end(); ++j ) {
        /* if (x < 50) {
            std::cerr << "pkg(" << x << "): ";
            std::cerr << j->name() << std::endl;
            } */
        ensure( x <= agg.index().packageCount() );
        ++ x;
    }
    ensure_equals( x, agg.index().packageCount() );
}

template<> template<>
void to::test<3> ()
{
    std::set< cache::Package >::iterator i;
    std::set< cache::Package > v( agg.index().begin(), agg.index().end() );
    int x = 0;
    for (i = v.begin(); i != v.end(); ++ i) {
        ensure( x <= agg.index().packageCount() );
        ++x;
    }
    ensure_equals( x, agg.index().packageCount() );
}

template<> template<>
void to::test<4> ()
{
    cache::Package p = agg.index().packageByName( "purring-foo" );
    ensure( p == cache::Package() );
}

template<> template<>
void to::test<5> ()
{
    unsigned int j = 0;
    for ( cache::Index::iterator i = agg.index().begin(); i != agg.index().end(); ++i ) {
        if ( i->hasVersion() )
            ++j;
    }

    ensure_equals( j, 1788u );
}


}

#include <ept/cache/apt/index.tcc>
#include <ept/cache/apt/packages.tcc>
