/*

    Condition class, header
    Copyright (C) 1999-2000 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <pthread.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>


#ifndef CONDITION_HH
    #define CONDITION_HH

    class clCondition
    {
            pthread_cond_t pthcCond;
        public:
            clCondition() { pthread_cond_init(&pthcCond, NULL); }
            ~clCondition() { pthread_cond_destroy(&pthcCond); }
            bool Wait(pthread_mutex_t *pthmCond)
                {
                    if (pthread_cond_wait(&pthcCond, pthmCond) == 0)
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
            bool Wait(pthread_mutex_t *pthmCond, int iCondTO)
                {
                    struct timeval sTimeVal;
                    struct timespec sTimeSpec;
                    gettimeofday(&sTimeVal, NULL);
                    sTimeSpec.tv_sec = sTimeVal.tv_sec + iCondTO / 1000;
                    sTimeSpec.tv_nsec = (sTimeVal.tv_usec + iCondTO * 1000) %
                        1000000 * 1000;
                    if (pthread_cond_timedwait(&pthcCond, pthmCond, 
                        &sTimeSpec) == 0)
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
            void Notify()
                { pthread_cond_signal(&pthcCond); }
            void NotifyAll() 
                { pthread_cond_broadcast(&pthcCond); }
    };

#endif

